/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.endtoend;

import java.util.List;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.spark.Tester;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.utils.test.TestSchema;
import org.apache.spark.sql.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.collection.immutable.Map;

@Tag(value="Sequential")
public class FiltersColumnPruneTests {
    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testExcludeColumns(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withClusteringKey("ck", (CqlField.CqlType)bridge.aInt()).withColumn("a", (CqlField.CqlType)bridge.bigint()).withColumn("b", (CqlField.CqlType)bridge.text()).withColumn("c", (CqlField.CqlType)bridge.ascii()).withColumn("d", (CqlField.CqlType)bridge.list((CqlField.CqlType)bridge.text())).withColumn("e", (CqlField.CqlType)bridge.map((CqlField.CqlType)bridge.bigint(), (CqlField.CqlType)bridge.text()))).withColumns("pk", "ck", "a", "c", "e").withExpectedRowCountPerSSTable(200).withCheck(dataset -> {
            List rows = dataset.collectAsList();
            Assertions.assertThat((List)rows).isNotEmpty();
            for (Row row : rows) {
                Assertions.assertThat((boolean)row.schema().getFieldIndex("pk").isDefined()).isTrue();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("ck").isDefined()).isTrue();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("a").isDefined()).isTrue();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("b").isDefined()).isFalse();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("c").isDefined()).isTrue();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("d").isDefined()).isFalse();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("e").isDefined()).isTrue();
                Assertions.assertThat((int)row.length()).isEqualTo(5);
                Assertions.assertThat((Object)row.get(0)).isInstanceOf(String.class);
                Assertions.assertThat((Object)row.get(1)).isInstanceOf(Integer.class);
                Assertions.assertThat((Object)row.get(2)).isInstanceOf(Long.class);
                Assertions.assertThat((Object)row.get(3)).isInstanceOf(String.class);
                Assertions.assertThat((Object)row.get(4)).isInstanceOf(Map.class);
            }
        }).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testUpsertExcludeColumns(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withClusteringKey("ck", (CqlField.CqlType)bridge.aInt()).withColumn("a", (CqlField.CqlType)bridge.bigint()).withColumn("b", (CqlField.CqlType)bridge.text()).withColumn("c", (CqlField.CqlType)bridge.ascii()).withColumn("d", (CqlField.CqlType)bridge.list((CqlField.CqlType)bridge.text())).withColumn("e", (CqlField.CqlType)bridge.map((CqlField.CqlType)bridge.bigint(), (CqlField.CqlType)bridge.text()))).withColumns("pk", "ck", "a", "c", "e").withUpsert().withExpectedRowCountPerSSTable(200).withCheck(dataset -> {
            List rows = dataset.collectAsList();
            Assertions.assertThat((List)rows).isNotEmpty();
            for (Row row : rows) {
                Assertions.assertThat((boolean)row.schema().getFieldIndex("pk").isDefined()).isTrue();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("ck").isDefined()).isTrue();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("a").isDefined()).isTrue();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("b").isDefined()).isFalse();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("c").isDefined()).isTrue();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("d").isDefined()).isFalse();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("e").isDefined()).isTrue();
                Assertions.assertThat((int)row.length()).isEqualTo(5);
                Assertions.assertThat((Object)row.get(0)).isInstanceOf(String.class);
                Assertions.assertThat((Object)row.get(1)).isInstanceOf(Integer.class);
                Assertions.assertThat((Object)row.get(2)).isInstanceOf(Long.class);
                Assertions.assertThat((Object)row.get(3)).isInstanceOf(String.class);
                Assertions.assertThat((Object)row.get(4)).isInstanceOf(Map.class);
            }
        }).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testExcludeNoColumns(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withClusteringKey("ck", (CqlField.CqlType)bridge.aInt()).withColumn("a", (CqlField.CqlType)bridge.bigint()).withColumn("b", (CqlField.CqlType)bridge.text()).withColumn("c", (CqlField.CqlType)bridge.ascii()).withColumn("d", (CqlField.CqlType)bridge.bigint()).withColumn("e", (CqlField.CqlType)bridge.aFloat()).withColumn("f", (CqlField.CqlType)bridge.bool())).withColumns("pk", "ck", "a", "b", "c", "d", "e", "f").withExpectedRowCountPerSSTable(200).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testUpsertExcludeNoColumns(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withClusteringKey("ck", (CqlField.CqlType)bridge.aInt()).withColumn("a", (CqlField.CqlType)bridge.bigint()).withColumn("b", (CqlField.CqlType)bridge.text()).withColumn("c", (CqlField.CqlType)bridge.ascii()).withColumn("d", (CqlField.CqlType)bridge.bigint()).withColumn("e", (CqlField.CqlType)bridge.aFloat()).withColumn("f", (CqlField.CqlType)bridge.bool())).withColumns("pk", "ck", "a", "b", "c", "d", "e", "f").withUpsert().withExpectedRowCountPerSSTable(200).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testExcludeAllColumns(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withClusteringKey("ck", (CqlField.CqlType)bridge.aInt()).withColumn("a", (CqlField.CqlType)bridge.bigint()).withColumn("b", (CqlField.CqlType)bridge.text()).withColumn("c", (CqlField.CqlType)bridge.ascii()).withColumn("d", (CqlField.CqlType)bridge.bigint()).withColumn("e", (CqlField.CqlType)bridge.aFloat()).withColumn("f", (CqlField.CqlType)bridge.bool())).withColumns("pk", "ck").withExpectedRowCountPerSSTable(200).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testUpsertExcludeAllColumns(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withClusteringKey("ck", (CqlField.CqlType)bridge.aInt()).withColumn("a", (CqlField.CqlType)bridge.bigint()).withColumn("b", (CqlField.CqlType)bridge.text()).withColumn("c", (CqlField.CqlType)bridge.ascii()).withColumn("d", (CqlField.CqlType)bridge.bigint()).withColumn("e", (CqlField.CqlType)bridge.aFloat()).withColumn("f", (CqlField.CqlType)bridge.bool())).withUpsert().withColumns("pk", "ck").withExpectedRowCountPerSSTable(200).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testExcludePartitionOnly(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid())).withColumns("pk").withExpectedRowCountPerSSTable(200).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testExcludeKeysOnly(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withClusteringKey("ck1", (CqlField.CqlType)bridge.text()).withClusteringKey("ck2", (CqlField.CqlType)bridge.bigint())).withColumns("pk", "ck1", "ck2").withExpectedRowCountPerSSTable(200).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testExcludeKeysStaticColumnOnly(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withClusteringKey("ck1", (CqlField.CqlType)bridge.text()).withClusteringKey("ck2", (CqlField.CqlType)bridge.bigint()).withStaticColumn("c1", (CqlField.CqlType)bridge.timestamp())).withColumns("pk", "ck1", "ck2", "c1").withExpectedRowCountPerSSTable(200).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testExcludeStaticColumn(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withClusteringKey("ck", (CqlField.CqlType)bridge.aInt()).withStaticColumn("a", (CqlField.CqlType)bridge.text()).withStaticColumn("b", (CqlField.CqlType)bridge.timestamp()).withColumn("c", (CqlField.CqlType)bridge.bigint()).withStaticColumn("d", (CqlField.CqlType)bridge.uuid())).withColumns("pk", "ck", "c").withExpectedRowCountPerSSTable(200).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testUpsertExcludeStaticColumn(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withClusteringKey("ck", (CqlField.CqlType)bridge.aInt()).withStaticColumn("a", (CqlField.CqlType)bridge.text()).withStaticColumn("b", (CqlField.CqlType)bridge.timestamp()).withColumn("c", (CqlField.CqlType)bridge.bigint()).withStaticColumn("d", (CqlField.CqlType)bridge.uuid())).withColumns("pk", "ck", "c").withUpsert().withExpectedRowCountPerSSTable(200).run(bridge.getVersion());
    }
}

