/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.util.concurrent.Uninterruptibles;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.spark.bulkwriter.SimpleTaskScheduler;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class SimpleTaskSchedulerTest {
    private SimpleTaskScheduler simpleTaskScheduler = new SimpleTaskScheduler();
    private String taskName = "test-task";

    @AfterEach
    public void teardown() {
        this.simpleTaskScheduler.unschedule(this.taskName);
    }

    @Test
    public void testSchedulePeriodic() {
        CountDownLatch latch = new CountDownLatch(10);
        long start = System.nanoTime();
        this.simpleTaskScheduler.schedulePeriodic(this.taskName, Duration.ofMillis(10L), latch::countDown);
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch);
        Assertions.assertThat((long)latch.getCount()).isEqualTo(0L);
        Assertions.assertThat((long)System.nanoTime()).isGreaterThan(start + TimeUnit.MILLISECONDS.toNanos(100L));
    }

    @Test
    public void testSchedulePeriodicSuppressThrows() {
        CountDownLatch latch = new CountDownLatch(10);
        long start = System.nanoTime();
        this.simpleTaskScheduler.schedulePeriodic(this.taskName, Duration.ofMillis(10L), () -> {
            latch.countDown();
            throw new RuntimeException("It fails");
        });
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch);
        Assertions.assertThat((long)latch.getCount()).isEqualTo(0L);
        Assertions.assertThat((long)System.nanoTime()).isGreaterThan(start + TimeUnit.MILLISECONDS.toNanos(100L));
    }
}

