/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.cassandra.cdc.CdcEventTransformer;
import org.apache.cassandra.cdc.api.KeyspaceTypeKey;
import org.apache.cassandra.cdc.avro.CdcEventUtils;
import org.apache.cassandra.cdc.msg.CdcEvent;
import org.apache.cassandra.cdc.msg.Value;
import org.apache.cassandra.cdc.schemastore.SchemaStore;
import org.apache.cassandra.spark.data.CqlField;

public abstract class CdcEventAvroEncoder
implements CdcEventTransformer<GenericData.Record> {
    public final Schema cdcSchema;
    public final Schema ttlSchema;
    public final Schema rangeSchema;
    protected final BinaryEncoder encoder;
    protected final Function<KeyspaceTypeKey, CqlField.CqlType> typeLookup;
    protected final SchemaStore store;

    public CdcEventAvroEncoder(SchemaStore store, Function<KeyspaceTypeKey, CqlField.CqlType> typeLookup, String templatePath) {
        this.cdcSchema = CdcEventAvroEncoder.readSchema(templatePath);
        this.ttlSchema = CdcEventAvroEncoder.extractTtlSchema(this.cdcSchema);
        this.rangeSchema = CdcEventAvroEncoder.extractRangeSchema(this.cdcSchema);
        this.encoder = EncoderFactory.get().binaryEncoder((OutputStream)new ByteArrayOutputStream(0), null);
        this.typeLookup = typeLookup;
        this.store = store;
    }

    @Override
    public abstract GenericData.Record transform(CdcEvent var1);

    protected void applyCommonFields(CdcEvent event, GenericData.Record record, Function<Value, Object> avroFieldEncoder) {
        long timestamp = event.getTimestamp(TimeUnit.MICROSECONDS);
        record.put("timestampMicros", (Object)timestamp);
        record.put("version", (Object)"2");
        record.put("isPartial", (Object)true);
        record.put("sourceTable", (Object)event.table);
        record.put("sourceKeyspace", (Object)event.keyspace);
        record.put("operationType", (Object)CdcEventUtils.getAvroOperationType(event, this.cdcSchema));
        record.put("updateFields", CdcEventUtils.updatedFieldNames(event));
        record.put("range", CdcEventUtils.getRangeTombstoneAvro(event, this.rangeSchema, avroFieldEncoder));
        record.put("ttl", (Object)CdcEventUtils.getTTLAvro(event, this.ttlSchema));
    }

    private static Schema readSchema(String filename) {
        ClassLoader classLoader = CdcEventAvroEncoder.class.getClassLoader();
        InputStream is = classLoader.getResourceAsStream(filename);
        try {
            return new Schema.Parser().parse(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Schema extractTtlSchema(Schema cdcSchema) {
        List nullableTtlUnion = cdcSchema.getField("ttl").schema().getTypes();
        return nullableTtlUnion.stream().filter(schema -> schema.getType() == Schema.Type.RECORD).findFirst().orElseThrow(() -> new IllegalStateException("ttl field should exist in cdc.avsc"));
    }

    private static Schema extractRangeSchema(Schema cdcSchema) {
        List nullableRangeUnion = cdcSchema.getField("range").schema().getTypes();
        return nullableRangeUnion.stream().filter(schema -> schema.getType() == Schema.Type.ARRAY).map(Schema::getElementType).findFirst().orElseThrow(() -> new IllegalStateException("range field should exist in cdc.avsc"));
    }

    public byte[] encode(GenericDatumWriter<GenericRecord> writer, GenericData.Record record) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder binaryEncoder = EncoderFactory.get().binaryEncoder((OutputStream)out, this.encoder);
        try {
            writer.write((Object)record, (Encoder)binaryEncoder);
            binaryEncoder.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }
}

