/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.netty.handler.codec.dns;

import java.util.List;
import o.a.c.sidecar.client.shaded.io.netty.buffer.ByteBuf;
import o.a.c.sidecar.client.shaded.io.netty.channel.ChannelHandler;
import o.a.c.sidecar.client.shaded.io.netty.channel.ChannelHandlerContext;
import o.a.c.sidecar.client.shaded.io.netty.handler.codec.MessageToMessageEncoder;
import o.a.c.sidecar.client.shaded.io.netty.handler.codec.dns.DnsMessageUtil;
import o.a.c.sidecar.client.shaded.io.netty.handler.codec.dns.DnsRecordEncoder;
import o.a.c.sidecar.client.shaded.io.netty.handler.codec.dns.DnsResponse;
import o.a.c.sidecar.client.shaded.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public final class TcpDnsResponseEncoder
extends MessageToMessageEncoder<DnsResponse> {
    private final DnsRecordEncoder encoder;

    public TcpDnsResponseEncoder() {
        this(DnsRecordEncoder.DEFAULT);
    }

    public TcpDnsResponseEncoder(DnsRecordEncoder encoder) {
        this.encoder = ObjectUtil.checkNotNull(encoder, "encoder");
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, DnsResponse response, List<Object> out) throws Exception {
        ByteBuf buf = ctx.alloc().ioBuffer(1024);
        buf.writerIndex(buf.writerIndex() + 2);
        DnsMessageUtil.encodeDnsResponse(this.encoder, response, buf);
        buf.setShort(0, buf.readableBytes() - 2);
        out.add(buf);
    }
}

