/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import java.math.BigInteger;

public class BundleNameGenerator {
    private final String commonName;
    static final char[] PREFIX_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();

    public BundleNameGenerator(String jobId, String sessionId) {
        this.commonName = "_" + jobId + "_" + sessionId + "_";
    }

    static char generatePrefixChar(int seed) {
        int idx = Math.abs(seed % PREFIX_CHARS.length);
        return PREFIX_CHARS[idx];
    }

    public String generate(BigInteger startToken, BigInteger endToken) {
        return BundleNameGenerator.generatePrefixChar(startToken.intValue()) + this.commonName + String.valueOf(startToken) + "_" + String.valueOf(endToken);
    }
}

