/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.types;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.bridge.type.InternalDuration;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.SettableByIndexData;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.DurationType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.DurationSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.spark.data.NativeType;
import org.apache.cassandra.spark.utils.RandomUtils;
import org.jetbrains.annotations.NotNull;

public class Duration
extends NativeType {
    public static final Duration INSTANCE = new Duration();

    public String name() {
        return "duration";
    }

    @Override
    public AbstractType<?> dataType() {
        return DurationType.instance;
    }

    @Override
    public <T> TypeSerializer<T> serializer() {
        return AnalyticsDurationSerializer.INSTANCE;
    }

    @Override
    public DataType driverDataType(boolean isFrozen) {
        return DataType.duration();
    }

    public boolean supportedAsPrimaryKeyColumn() {
        return false;
    }

    public boolean supportedAsMapKey() {
        return false;
    }

    public boolean supportedAsSetElement() {
        return false;
    }

    @Override
    public Object convertForCqlWriter(Object value, CassandraVersion version, boolean isCollectionElement) {
        InternalDuration duration = (InternalDuration)value;
        return isCollectionElement ? AnalyticsDurationSerializer.toCql3FunctionDuration(duration) : AnalyticsDurationSerializer.toCql3Duration(duration);
    }

    @Override
    protected void setInnerValueInternal(SettableByIndexData<?> udtValue, int position, @NotNull Object value) {
        org.apache.cassandra.cql3.functions.types.Duration duration = null;
        duration = value instanceof InternalDuration ? AnalyticsDurationSerializer.toCql3FunctionDuration((InternalDuration)value) : (value instanceof org.apache.cassandra.cql3.Duration ? AnalyticsDurationSerializer.toCql3FunctionDuration((org.apache.cassandra.cql3.Duration)value) : (org.apache.cassandra.cql3.functions.types.Duration)value);
        udtValue.set(position, (Object)duration, org.apache.cassandra.cql3.functions.types.Duration.class);
    }

    @Override
    public Object randomValue(int minCollectionSize) {
        return new InternalDuration(RandomUtils.randomPositiveInt((int)100), RandomUtils.randomPositiveInt((int)100), TimeUnit.MICROSECONDS.toNanos(RandomUtils.randomPositiveInt((int)1000000)));
    }

    private static class AnalyticsDurationSerializer
    extends TypeSerializer<InternalDuration> {
        private static final AnalyticsDurationSerializer INSTANCE = new AnalyticsDurationSerializer();

        private AnalyticsDurationSerializer() {
        }

        public ByteBuffer serialize(InternalDuration value) {
            org.apache.cassandra.cql3.Duration cqlDuration = AnalyticsDurationSerializer.toCql3Duration(value);
            return DurationSerializer.instance.serialize(cqlDuration);
        }

        public <V> InternalDuration deserialize(V v, ValueAccessor<V> valueAccessor) {
            org.apache.cassandra.cql3.Duration cqlDuration = DurationSerializer.instance.deserialize(v, valueAccessor);
            return AnalyticsDurationSerializer.fromCql3Duration(cqlDuration);
        }

        public <V> void validate(V v, ValueAccessor<V> valueAccessor) throws MarshalException {
            DurationSerializer.instance.validate(v, valueAccessor);
        }

        public String toString(InternalDuration duration) {
            return duration == null ? "" : duration.toString();
        }

        public Class<InternalDuration> getType() {
            return InternalDuration.class;
        }

        public static org.apache.cassandra.cql3.Duration toCql3Duration(InternalDuration duration) {
            return AnalyticsDurationSerializer.nullOrConvert(duration, d -> org.apache.cassandra.cql3.Duration.newInstance((int)d.months, (int)d.days, (long)d.nanoseconds));
        }

        public static org.apache.cassandra.cql3.functions.types.Duration toCql3FunctionDuration(InternalDuration duration) {
            return AnalyticsDurationSerializer.nullOrConvert(duration, d -> org.apache.cassandra.cql3.functions.types.Duration.newInstance((int)d.months, (int)d.days, (long)d.nanoseconds));
        }

        public static org.apache.cassandra.cql3.functions.types.Duration toCql3FunctionDuration(org.apache.cassandra.cql3.Duration duration) {
            return AnalyticsDurationSerializer.nullOrConvert(duration, d -> org.apache.cassandra.cql3.functions.types.Duration.newInstance((int)d.getMonths(), (int)d.getDays(), (long)d.getNanoseconds()));
        }

        public static InternalDuration fromCql3Duration(org.apache.cassandra.cql3.Duration duration) {
            return AnalyticsDurationSerializer.nullOrConvert(duration, d -> new InternalDuration(d.getMonths(), d.getDays(), d.getNanoseconds()));
        }

        private static <I, O> O nullOrConvert(I input, Function<I, O> converter) {
            if (input == null) {
                return null;
            }
            return converter.apply(input);
        }
    }
}

