/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.cassandra.spark.utils.ThrowableUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FutureUtils {
    private FutureUtils() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static <T> List<T> awaitAll(Collection<CompletableFuture<T>> futures, boolean acceptPartialResult, Consumer<Throwable> onFailure) {
        ArrayList result = new ArrayList(futures.size());
        for (CompletableFuture<T> future : futures) {
            FutureResult<T> futureResult = FutureUtils.await(future, onFailure);
            if (futureResult.throwable != null) {
                if (acceptPartialResult) continue;
                throw new RuntimeException(ThrowableUtils.rootCause(futureResult.throwable));
            }
            if (futureResult.value == null) continue;
            result.add(futureResult.value);
        }
        return result;
    }

    @NotNull
    public static <T> FutureResult<T> await(CompletableFuture<T> future, Consumer<Throwable> logger) {
        try {
            return FutureResult.success(future.get());
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(exception);
        }
        catch (ExecutionException exception) {
            logger.accept(exception);
            return FutureResult.failed(exception);
        }
    }

    public static <T> CompletableFuture<List<T>> combine(List<CompletableFuture<T>> futures) {
        CompletableFuture result = new CompletableFuture();
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).whenComplete((aVoid, aThrowable) -> {
            if (aThrowable == null) {
                try {
                    result.complete(FutureUtils.awaitAll(futures, false, throwable -> {}));
                }
                catch (Throwable throwable2) {
                    result.completeExceptionally(ThrowableUtils.rootCause(throwable2));
                }
            } else {
                result.completeExceptionally((Throwable)aThrowable);
            }
        });
        return result;
    }

    public static <T> List<T> bestEffortGet(List<CompletableFuture<T>> futures, long timeout, TimeUnit timeUnit) {
        try {
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get(timeout, timeUnit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            // empty catch block
        }
        return futures.stream().map(future -> {
            if (future.isDone()) {
                return ((CompletableFuture)future.exceptionally(t -> null)).join();
            }
            future.cancel(true);
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T> T get(CompletableFuture<T> future) {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(ThrowableUtils.rootCause(e));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static final class FutureResult<T> {
        @Nullable
        public final T value;
        @Nullable
        public final Throwable throwable;

        private FutureResult(@Nullable T value, @Nullable Throwable throwable) {
            this.value = value;
            this.throwable = throwable;
        }

        public static <T> FutureResult<T> failed(@NotNull Throwable throwable) {
            return new FutureResult<Object>(null, throwable);
        }

        public static <T> FutureResult<T> success(@Nullable T value) {
            return new FutureResult<T>(value, null);
        }

        @Nullable
        public T value() {
            return this.value;
        }

        public boolean isSuccess() {
            return this.throwable == null;
        }
    }
}

