/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.tree.segmenttree;

import org.psjava.ds.array.Array;
import org.psjava.ds.tree.BinaryTreeNode;
import org.psjava.ds.tree.BinaryTreeNodeFactory;
import org.psjava.ds.tree.segmenttree.EnhancedRangeUpdatableSegmentTreeOperator;

public class LazyPropagatingSegmentTree<T, U> {
    private final EnhancedRangeUpdatableSegmentTreeOperator<T, U> operator;
    private final int size;
    final BinaryTreeNode<NodeData> root;

    public LazyPropagatingSegmentTree(Array<T> initialData, EnhancedRangeUpdatableSegmentTreeOperator<T, U> operator) {
        this.operator = operator;
        this.size = initialData.size();
        this.root = this.size > 0 ? this.construct(initialData, 0, this.size) : null;
    }

    private BinaryTreeNode<NodeData> construct(Array<T> initialData, int start, int end) {
        if (end - start == 1) {
            return BinaryTreeNodeFactory.create(new NodeData(initialData.get(start)));
        }
        int mid = LazyPropagatingSegmentTree.calcMiddle(start, end);
        BinaryTreeNode<NodeData> left = this.construct(initialData, start, mid);
        BinaryTreeNode<NodeData> right = this.construct(initialData, mid, end);
        BinaryTreeNode<NodeData> node = BinaryTreeNodeFactory.create(new NodeData(this.merge(left, right)));
        node.putLeft(left);
        node.putRight(right);
        return node;
    }

    public T queryRange(int start, int end) {
        return this.queryRangeRecursively(this.root, 0, this.size, start, end);
    }

    private T queryRangeRecursively(BinaryTreeNode<NodeData> node, int nodeStart, int nodeEnd, int rangeStart, int rangeEnd) {
        if (rangeStart == nodeStart && rangeEnd == nodeEnd) {
            return node.getData().merged;
        }
        this.propagateIfLazy(node, nodeStart, nodeEnd);
        int mid = LazyPropagatingSegmentTree.calcMiddle(nodeStart, nodeEnd);
        if (rangeEnd <= mid) {
            return this.queryRangeRecursively(node.getLeft(), nodeStart, mid, rangeStart, rangeEnd);
        }
        if (mid <= rangeStart) {
            return this.queryRangeRecursively(node.getRight(), mid, nodeEnd, rangeStart, rangeEnd);
        }
        return this.operator.mergeSingleValue(this.queryRangeRecursively(node.getLeft(), nodeStart, mid, rangeStart, mid), this.queryRangeRecursively(node.getRight(), mid, nodeEnd, mid, rangeEnd));
    }

    public void updateRange(int start, int end, U updateData) {
        this.updateRangeRecursively(this.root, 0, this.size, start, end, updateData);
    }

    private void updateRangeRecursively(BinaryTreeNode<NodeData> node, int nodeStart, int nodeEnd, int start, int end, U updateData) {
        if (start == nodeStart && end == nodeEnd) {
            this.makeAsLazy(node, start, end, updateData);
        } else {
            this.propagateIfLazy(node, nodeStart, nodeEnd);
            int mid = LazyPropagatingSegmentTree.calcMiddle(nodeStart, nodeEnd);
            if (start < mid) {
                this.updateRangeRecursively(node.getLeft(), nodeStart, mid, start, Math.min(mid, end), updateData);
            }
            if (mid < end) {
                this.updateRangeRecursively(node.getRight(), mid, nodeEnd, Math.max(mid, start), end, updateData);
            }
            node.getData().merged = this.merge(node.getLeft(), node.getRight());
        }
    }

    private static int calcMiddle(int start, int end) {
        return (start + end) / 2;
    }

    private T merge(BinaryTreeNode<NodeData> left, BinaryTreeNode<NodeData> right) {
        return this.operator.mergeSingleValue(left.getData().merged, right.getData().merged);
    }

    private void makeAsLazy(BinaryTreeNode<NodeData> node, int start, int end, U updateData) {
        NodeData data = node.getData();
        T m3 = this.operator.mergeRangeValue(data.merged, end - start, updateData);
        data.merged = m3;
        data.updateDataToBePropagate = !data.lazy ? updateData : this.operator.mergeUpdateData(data.updateDataToBePropagate, updateData);
        data.lazy = true;
    }

    private void propagateIfLazy(BinaryTreeNode<NodeData> node, int start, int end) {
        if (node.getData().lazy) {
            if (end - start > 1) {
                Object value = node.getData().updateDataToBePropagate;
                int mid = LazyPropagatingSegmentTree.calcMiddle(start, end);
                this.makeAsLazy(node.getLeft(), start, mid, value);
                this.makeAsLazy(node.getRight(), mid, end, value);
            }
            node.getData().lazy = false;
            node.getData().updateDataToBePropagate = null;
        }
    }

    public String toString() {
        return this.root.toString();
    }

    class NodeData {
        T merged;
        boolean lazy = false;
        U updateDataToBePropagate = null;

        NodeData(T merged) {
            this.merged = merged;
        }
    }
}

