/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.io.util.RebufferingInputStream;

public class AsyncStreamingInputPlus
extends RebufferingInputStream {
    private static final long DEFAULT_REBUFFER_BLOCK_IN_MILLIS = TimeUnit.MINUTES.toMillis(3L);
    private final Channel channel;
    private ByteBuf currentBuf = Unpooled.EMPTY_BUFFER;
    private final BlockingQueue<ByteBuf> queue = new LinkedBlockingQueue<ByteBuf>();
    private final long rebufferTimeoutNanos;
    private volatile boolean isClosed;

    public AsyncStreamingInputPlus(Channel channel) {
        this(channel, DEFAULT_REBUFFER_BLOCK_IN_MILLIS, TimeUnit.MILLISECONDS);
    }

    AsyncStreamingInputPlus(Channel channel, long rebufferTimeout, TimeUnit rebufferTimeoutUnit) {
        super(Unpooled.EMPTY_BUFFER.nioBuffer());
        this.rebufferTimeoutNanos = rebufferTimeoutUnit.toNanos(rebufferTimeout);
        this.channel = channel;
        channel.config().setAutoRead(false);
    }

    public boolean append(ByteBuf buf) throws IllegalStateException {
        if (this.isClosed) {
            return false;
        }
        this.queue.add(buf);
        if (this.isClosed) {
            while ((buf = (ByteBuf)this.queue.poll()) != null) {
                buf.release();
            }
        }
        return true;
    }

    @Override
    protected void reBuffer() throws EOFException, InputTimeoutException {
        if (this.queue.isEmpty()) {
            this.channel.read();
        }
        this.currentBuf.release();
        this.currentBuf = null;
        this.buffer = null;
        ByteBuf next = null;
        try {
            next = this.queue.poll(this.rebufferTimeoutNanos, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (null == next) {
            throw new InputTimeoutException();
        }
        if (next == Unpooled.EMPTY_BUFFER) {
            throw new EOFException();
        }
        this.currentBuf = next;
        this.buffer = next.nioBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(Consumer consumer, long length) throws IOException {
        while (length > 0L) {
            if (!this.buffer.hasRemaining()) {
                this.reBuffer();
            }
            int position = this.buffer.position();
            int limit = this.buffer.limit();
            this.buffer.limit(position + (int)Math.min(length, (long)(limit - position)));
            try {
                int copied = consumer.accept(this.buffer);
                this.buffer.position(position + copied);
                length -= (long)copied;
            }
            finally {
                this.buffer.limit(limit);
            }
        }
    }

    @VisibleForTesting
    public int unsafeAvailable() {
        long count = this.buffer != null ? (long)this.buffer.remaining() : 0L;
        for (ByteBuf buf : this.queue) {
            count += (long)buf.readableBytes();
        }
        return Ints.checkedCast(count);
    }

    public void maybeIssueRead() {
        if (this.isEmpty()) {
            this.channel.read();
        }
    }

    public boolean isEmpty() {
        return this.queue.isEmpty() && (this.buffer == null || !this.buffer.hasRemaining());
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        if (this.currentBuf != null) {
            this.currentBuf.release();
            this.currentBuf = null;
            this.buffer = null;
        }
        while (true) {
            try {
                ByteBuf buf;
                while ((buf = this.queue.poll(Long.MAX_VALUE, TimeUnit.NANOSECONDS)) != Unpooled.EMPTY_BUFFER) {
                    buf.release();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        this.isClosed = true;
    }

    public void requestClosure() {
        this.queue.add(Unpooled.EMPTY_BUFFER);
    }

    public ByteBufAllocator getAllocator() {
        return this.channel.alloc();
    }

    public static interface Consumer {
        public int accept(ByteBuffer var1) throws IOException;
    }

    public static class InputTimeoutException
    extends IOException {
    }
}

