/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.exceptions;

import com.google.common.primitives.Ints;
import java.io.IOException;
import org.apache.cassandra.db.filter.TombstoneOverwhelmingException;
import org.apache.cassandra.exceptions.IncompatibleSchemaException;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.vint.VIntCoding;

public enum RequestFailureReason {
    UNKNOWN(0),
    READ_TOO_MANY_TOMBSTONES(1),
    TIMEOUT(2),
    INCOMPATIBLE_SCHEMA(3);

    public static final Serializer serializer;
    public final int code;
    private static final RequestFailureReason[] codeToReasonMap;

    private RequestFailureReason(int code) {
        this.code = code;
    }

    public static RequestFailureReason fromCode(int code) {
        if (code < 0) {
            throw new IllegalArgumentException("RequestFailureReason code must be non-negative (got " + code + ')');
        }
        return code < codeToReasonMap.length ? codeToReasonMap[code] : UNKNOWN;
    }

    public static RequestFailureReason forException(Throwable t) {
        if (t instanceof TombstoneOverwhelmingException) {
            return READ_TOO_MANY_TOMBSTONES;
        }
        if (t instanceof IncompatibleSchemaException) {
            return INCOMPATIBLE_SCHEMA;
        }
        return UNKNOWN;
    }

    static {
        serializer = new Serializer();
        RequestFailureReason[] reasons = RequestFailureReason.values();
        int max = -1;
        for (RequestFailureReason r : reasons) {
            max = Math.max(r.code, max);
        }
        RequestFailureReason[] codeMap = new RequestFailureReason[max + 1];
        for (RequestFailureReason reason : reasons) {
            if (codeMap[reason.code] != null) {
                throw new RuntimeException("Two RequestFailureReason-s that map to the same code: " + reason.code);
            }
            codeMap[reason.code] = reason;
        }
        codeToReasonMap = codeMap;
    }

    public static final class Serializer
    implements IVersionedSerializer<RequestFailureReason> {
        private Serializer() {
        }

        @Override
        public void serialize(RequestFailureReason reason, DataOutputPlus out, int version) throws IOException {
            if (version < 12) {
                out.writeShort(reason.code);
            } else {
                out.writeUnsignedVInt(reason.code);
            }
        }

        @Override
        public RequestFailureReason deserialize(DataInputPlus in, int version) throws IOException {
            return RequestFailureReason.fromCode(version < 12 ? in.readUnsignedShort() : Ints.checkedCast(in.readUnsignedVInt()));
        }

        @Override
        public long serializedSize(RequestFailureReason reason, int version) {
            return version < 12 ? 2L : (long)VIntCoding.computeVIntSize(reason.code);
        }
    }
}

