/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics;

import com.google.common.collect.Range;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.cassandra.analytics.SharedClusterSparkIntegrationTestBase;
import org.apache.cassandra.analytics.TestConsistencyLevel;
import org.apache.cassandra.distributed.api.ConsistencyLevel;
import org.apache.cassandra.distributed.api.ICluster;
import org.apache.cassandra.distributed.api.IInstance;
import org.apache.cassandra.distributed.api.IInstanceConfig;
import org.apache.cassandra.distributed.api.Row;
import org.apache.cassandra.distributed.api.SimpleQueryResult;
import org.apache.cassandra.sidecar.common.server.JmxClient;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.spark.bulkwriter.DecoratedKey;
import org.apache.cassandra.spark.bulkwriter.Tokenizer;
import org.apache.cassandra.spark.common.schema.ColumnType;
import org.apache.cassandra.spark.common.schema.ColumnTypes;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.assertj.core.api.Assertions;
import scala.Tuple2;

public abstract class ResiliencyTestBase
extends SharedClusterSparkIntegrationTestBase {
    public static final String QUERY_ALL_ROWS = "SELECT * FROM %s";

    public Set<String> getDataForRange(Range<BigInteger> range, int rowCount) {
        return this.generateExpectedData(rowCount).stream().filter(t -> range.contains((Comparable)((DecoratedKey)t._1()).getToken())).map(t -> String.valueOf(((Object[])t._2())[0]) + ":" + String.valueOf(((Object[])t._2())[1]) + ":" + String.valueOf(((Object[])t._2())[2])).collect(Collectors.toSet());
    }

    public List<Tuple2<DecoratedKey, Object[]>> generateExpectedData(int rowCount) {
        List<ColumnType> columnTypes = Collections.singletonList(ColumnTypes.INT);
        Tokenizer tokenizer = new Tokenizer(Collections.singletonList(0), Collections.singletonList("id"), columnTypes, true);
        return IntStream.range(0, rowCount).mapToObj(recordNum -> {
            Object[] columns = new Object[]{recordNum, "course" + recordNum, recordNum};
            return Tuple2.apply((Object)tokenizer.getDecoratedKey(columns), (Object)columns);
        }).collect(Collectors.toList());
    }

    public Map<IInstance, Set<String>> getInstanceData(List<? extends IInstance> instances, boolean isPending, int rowCount) {
        return instances.stream().collect(Collectors.toMap(Function.identity(), i -> this.filterTokenRangeData(this.rangesForInstance((IInstance)i, isPending), rowCount)));
    }

    public Set<String> filterTokenRangeData(List<Range<BigInteger>> ranges, int rowCount) {
        return ranges.stream().map(range -> this.getDataForRange((Range<BigInteger>)range, rowCount)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Map<IInstance, Set<String>> generateExpectedInstanceData(ICluster<? extends IInstance> cluster, List<? extends IInstance> pendingNodes, int rowCount) {
        List instances = cluster.stream().collect(Collectors.toList());
        Map<IInstance, Set<String>> expectedInstanceData = this.getInstanceData(instances, false, rowCount);
        Map<IInstance, Set<String>> transitioningInstanceData = this.getInstanceData(pendingNodes, true, rowCount);
        expectedInstanceData.putAll(transitioningInstanceData.entrySet().stream().filter(e -> !((Set)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return expectedInstanceData;
    }

    protected void validateData(QualifiedName table, ConsistencyLevel readCL, int rowCount) {
        String query = String.format(QUERY_ALL_ROWS, table);
        Set actualEntries = Arrays.stream(this.cluster.coordinator(1).execute(query, this.mapConsistencyLevel(readCL), new Object[0])).map(columns -> String.format("%s:%s:%s", columns[0], columns[1], columns[2])).collect(Collectors.toSet());
        Assertions.assertThat((int)actualEntries.size()).isEqualTo(rowCount);
        IntStream.range(0, rowCount).forEach(i -> actualEntries.remove(i + ":course" + i + ":" + i));
        Assertions.assertThat(actualEntries).isEmpty();
    }

    protected static QualifiedName uniqueTestTableFullName(String keyspace, Object[] arguments) {
        TestConsistencyLevel cl = (TestConsistencyLevel)arguments[0];
        return ResiliencyTestBase.uniqueTestTableFullName(keyspace, cl.readCL, cl.writeCL);
    }

    protected static QualifiedName uniqueTestTableFullName(String keyspace, ConsistencyLevel readCL, ConsistencyLevel writeCL) {
        String tableName = String.format("r_%s__w_%s", readCL, writeCL).toLowerCase();
        return new QualifiedName(keyspace, tableName);
    }

    public void validateNodeSpecificData(QualifiedName table, Map<? extends IInstance, Set<String>> expectedInstanceData) {
        this.validateNodeSpecificData(table, expectedInstanceData, true);
    }

    public void validateNodeSpecificData(QualifiedName table, Map<? extends IInstance, Set<String>> expectedInstanceData, boolean hasNewNodes) {
        for (IInstance iInstance : expectedInstanceData.keySet()) {
            SimpleQueryResult qr = iInstance.executeInternalWithResult(String.format(QUERY_ALL_ROWS, table), new Object[0]);
            HashSet<CallSite> rows = new HashSet<CallSite>();
            while (qr.hasNext()) {
                Row row = qr.next();
                int id = row.getInteger("id");
                String course = row.getString("course");
                int marks = row.getInteger("marks");
                rows.add((CallSite)((Object)(id + ":" + course + ":" + marks)));
            }
            if (hasNewNodes) {
                Assertions.assertThat(rows).containsExactlyInAnyOrderElementsOf((Iterable)expectedInstanceData.get(iInstance));
                continue;
            }
            Assertions.assertThat(rows).containsAll((Iterable)expectedInstanceData.get(iInstance));
        }
    }

    private List<Range<BigInteger>> rangesForInstance(IInstance instance, boolean isPending) {
        IInstanceConfig config = instance.config();
        Map<List<String>, List<String>> ranges = null;
        try (JmxClient client = this.wrapJmxClient(JmxClient.builder().host(config.broadcastAddress().getAddress().getHostAddress()).port(config.jmxPort()));){
            SSProxy ss = (SSProxy)client.proxy(SSProxy.class, "org.apache.cassandra.db:type=StorageService");
            ranges = isPending ? ss.getPendingRangeToEndpointWithPortMap("spark_test") : ss.getRangeToEndpointWithPortMap("spark_test");
        }
        catch (IOException exception) {
            this.logger.warn("Unable to close JMX client");
        }
        Assertions.assertThat(ranges).isNotNull();
        return ranges.entrySet().stream().filter(e -> ((List)e.getValue()).contains(instance.broadcastAddress().getAddress().getHostAddress() + ":" + instance.broadcastAddress().getPort())).map(e -> this.unwrapRanges((List)e.getKey())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Range<BigInteger>> unwrapRanges(List<String> range) {
        BigInteger end;
        ArrayList<Range<BigInteger>> ranges = new ArrayList<Range<BigInteger>>();
        BigInteger start = new BigInteger(range.get(0));
        if (start.compareTo(end = new BigInteger(range.get(1))) > 0) {
            ranges.add(Range.openClosed((Comparable)start, (Comparable)BigInteger.valueOf(Long.MAX_VALUE)));
            ranges.add((Range<BigInteger>)Range.openClosed((Comparable)BigInteger.valueOf(Long.MIN_VALUE), (Comparable)end));
        } else {
            ranges.add(Range.openClosed((Comparable)start, (Comparable)end));
        }
        return ranges;
    }

    private ConsistencyLevel mapConsistencyLevel(ConsistencyLevel cl) {
        return ConsistencyLevel.valueOf((String)cl.name());
    }

    public static ClusterBuilderConfiguration clusterConfig() {
        ClusterBuilderConfiguration conf = new ClusterBuilderConfiguration();
        conf.additionalInstanceConfig(Map.of("storage_compatibility_mode", "NONE"));
        return conf;
    }

    public static interface SSProxy {
        public Map<List<String>, List<String>> getRangeToEndpointWithPortMap(String var1);

        public Map<List<String>, List<String>> getPendingRangeToEndpointWithPortMap(String var1);
    }
}

