/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.validation;

import org.apache.cassandra.secrets.SecretsProvider;
import org.apache.cassandra.secrets.TestSecretsProvider;
import org.apache.cassandra.spark.validation.TrustStoreValidation;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TrustStoreValidationTests {
    @Test
    public void testUnconfiguredTrustStore() {
        SecretsProvider secrets = TestSecretsProvider.notConfigured();
        TrustStoreValidation validation = new TrustStoreValidation(secrets);
        Throwable throwable = validation.perform();
        Assertions.assertThat((Throwable)throwable).isNull();
    }

    @Test
    public void testMissingTrustStore() {
        SecretsProvider secrets = TestSecretsProvider.forTrustStore("PKCS12", "keystore-missing.p12", "qwerty");
        TrustStoreValidation validation = new TrustStoreValidation(secrets);
        Throwable throwable = validation.perform();
        Assertions.assertThat((Throwable)throwable).isInstanceOf(RuntimeException.class);
        Assertions.assertThat((String)throwable.getMessage()).isEqualTo("TrustStore is empty");
    }

    @Test
    public void testMalformedTrustStore() {
        SecretsProvider secrets = TestSecretsProvider.forTrustStore("PKCS12", "keystore-malformed.p12", "qwerty");
        TrustStoreValidation validation = new TrustStoreValidation(secrets);
        Throwable throwable = validation.perform();
        Assertions.assertThat((Throwable)throwable).isInstanceOf(RuntimeException.class);
        Assertions.assertThat((String)throwable.getMessage()).isEqualTo("TrustStore is misconfigured");
    }

    @Test
    public void testEmptyTrustStore() {
        SecretsProvider secrets = TestSecretsProvider.forTrustStore("PKCS12", "keystore-empty.p12", "qwerty");
        TrustStoreValidation validation = new TrustStoreValidation(secrets);
        Throwable throwable = validation.perform();
        Assertions.assertThat((Throwable)throwable).isInstanceOf(RuntimeException.class);
        Assertions.assertThat((String)throwable.getMessage()).isEqualTo("TrustStore is empty");
    }

    @Test
    public void testInvalidTrustStore() {
        SecretsProvider secrets = TestSecretsProvider.forTrustStore("PKCS12", "keystore-secret.p12", "qwerty");
        TrustStoreValidation validation = new TrustStoreValidation(secrets);
        Throwable throwable = validation.perform();
        Assertions.assertThat((Throwable)throwable).isInstanceOf(RuntimeException.class);
        Assertions.assertThat((String)throwable.getMessage()).isEqualTo("TrustStore contains no certificates");
    }

    @Test
    public void testValidTrustStore() {
        SecretsProvider secrets = TestSecretsProvider.forTrustStore("PKCS12", "keystore-certificate.p12", "qwerty");
        TrustStoreValidation validation = new TrustStoreValidation(secrets);
        Throwable throwable = validation.perform();
        Assertions.assertThat((Throwable)throwable).isNull();
    }
}

