/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import org.apache.cassandra.spark.bulkwriter.CqlTableInfoProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class CqlTableInfoProviderTest {
    @Test
    public void testRemoveDeprecatedOptionsInvalidInput() {
        Assertions.assertThatThrownBy(() -> CqlTableInfoProvider.removeDeprecatedOptions(null)).isInstanceOf(NullPointerException.class);
        Assertions.assertThat((String)CqlTableInfoProvider.removeDeprecatedOptions((String)"")).isEqualTo("");
        Assertions.assertThat((String)CqlTableInfoProvider.removeDeprecatedOptions((String)"qwerty")).isEqualTo("qwerty");
    }

    @Test
    public void testRemoveDeprecatedOptionsOptionNames() {
        Assertions.assertThat((String)CqlTableInfoProvider.removeDeprecatedOptions((String)"... WITH qwerty = 42 ...")).isEqualTo("... WITH qwerty = 42 ...");
        Assertions.assertThat((String)CqlTableInfoProvider.removeDeprecatedOptions((String)"... WITH read_repair_chance = 42 ...")).isEqualTo("... WITH ...");
        Assertions.assertThat((String)CqlTableInfoProvider.removeDeprecatedOptions((String)"... WITH dclocal_read_repair_chance = 42 ...")).isEqualTo("... WITH ...");
        Assertions.assertThat((String)CqlTableInfoProvider.removeDeprecatedOptions((String)"... WITH dclocal_dclocal_read_repair_chance = 42 ...")).isEqualTo("... WITH dclocal_dclocal_read_repair_chance = 42 ...");
    }

    @Test
    public void testRemoveDeprecatedOptionsOptionValues() {
        Assertions.assertThat((String)CqlTableInfoProvider.removeDeprecatedOptions((String)"... WITH read_repair_chance = -42 ...")).isEqualTo("... WITH ...");
        Assertions.assertThat((String)CqlTableInfoProvider.removeDeprecatedOptions((String)"... WITH read_repair_chance = 420.0e-1 ...")).isEqualTo("... WITH ...");
        Assertions.assertThat((String)CqlTableInfoProvider.removeDeprecatedOptions((String)"... WITH read_repair_chance = +.42E+1.0 ...")).isEqualTo("... WITH ...");
        Assertions.assertThat((String)CqlTableInfoProvider.removeDeprecatedOptions((String)"... WITH read_repair_chance = true ...")).isEqualTo("... WITH read_repair_chance = true ...");
    }

    @Test
    public void testRemoveDeprecatedOptionsOptionsOrder() {
        Assertions.assertThat((String)CqlTableInfoProvider.removeDeprecatedOptions((String)"... WITH read_repair_chance = 1 ...")).isEqualTo("... WITH ...");
        Assertions.assertThat((String)CqlTableInfoProvider.removeDeprecatedOptions((String)"... WITH read_repair_chance = 1 AND qwerty = 42 ...")).isEqualTo("... WITH qwerty = 42 ...");
        Assertions.assertThat((String)CqlTableInfoProvider.removeDeprecatedOptions((String)"... WITH qwerty = 42 AND read_repair_chance = 1 ...")).isEqualTo("... WITH qwerty = 42 ...");
        Assertions.assertThat((String)CqlTableInfoProvider.removeDeprecatedOptions((String)"... WITH read_repair_chance = 1 AND qwerty = 42 AND dclocal_read_repair_chance = 1 ...")).isEqualTo("... WITH qwerty = 42 ...");
        Assertions.assertThat((String)CqlTableInfoProvider.removeDeprecatedOptions((String)"... WITH qwerty = 42 AND read_repair_chance = 1 AND asdfgh = 43 ...")).isEqualTo("... WITH qwerty = 42 AND asdfgh = 43 ...");
        Assertions.assertThat((String)CqlTableInfoProvider.removeDeprecatedOptions((String)"... WITH qwerty = 42 AND read_repair_chance = 1 AND asdfgh = 43 AND dclocal_read_repair_chance = 1 AND zxcvbn = 44 ...")).isEqualTo("... WITH qwerty = 42 AND asdfgh = 43 AND zxcvbn = 44 ...");
        Assertions.assertThat((String)CqlTableInfoProvider.removeDeprecatedOptions((String)"... WITH qwerty = 42 AND asdfgh = 43 AND zxcvbn = 44 ...")).isEqualTo("... WITH qwerty = 42 AND asdfgh = 43 AND zxcvbn = 44 ...");
    }

    @Test
    public void testRemoveDeprecatedOptionsStatementCase() {
        Assertions.assertThat((String)CqlTableInfoProvider.removeDeprecatedOptions((String)"... WITH read_repair_chance = 1 AND dclocal_read_repair_chance = 1 ...")).isEqualTo("... WITH ...");
        Assertions.assertThat((String)CqlTableInfoProvider.removeDeprecatedOptions((String)"... WITH READ_REPAIR_CHANCE = 1 AND DCLOCAL_READ_REPAIR_CHANCE = 1 ...")).isEqualTo("... WITH ...");
        Assertions.assertThat((String)CqlTableInfoProvider.removeDeprecatedOptions((String)"... with read_repair_chance = 1 and dclocal_read_repair_chance = 1 ...")).isEqualTo("... with ...");
        Assertions.assertThat((String)CqlTableInfoProvider.removeDeprecatedOptions((String)"... WiTh ReAd_RePaIr_ChAnCe = 1 AnD dClOcAl_ReAd_RePaIr_ChAnCe = 1 ...")).isEqualTo("... WiTh ...");
    }

    @Test
    public void testRemoveDeprecatedOptionsRealStatement() {
        String cql = "CREATE TABLE test_simple_rf_3_batch_10000_splits_3.test (id int, course text, foo text, marks int, PRIMARY KEY ((id, course))) WITH read_repair_chance = 0.0 AND dclocal_read_repair_chance = 0.0 AND gc_grace_seconds = 864000 AND bloom_filter_fp_chance = 0.1 AND caching = { 'keys' : 'ALL', 'rows_per_partition' : 'NONE' } AND comment = '' AND compaction = { 'class' : 'org.apache.cassandra.db.compaction.LeveledCompactionStrategy', 'enabled' : 'true', 'max_threshold' : 32, 'min_threshold' : 4 } AND compression = { 'chunk_length_in_kb' : 16, 'class' : 'org.apache.cassandra.io.compress.ZstdCompressor' } AND default_time_to_live = 0 AND speculative_retry = '99p' AND min_index_interval = 128 AND max_index_interval = 2048 AND crc_check_chance = 1.0 AND cdc = false AND memtable_flush_period_in_ms = 0;";
        String expected = "CREATE TABLE test_simple_rf_3_batch_10000_splits_3.test (id int, course text, foo text, marks int, PRIMARY KEY ((id, course))) WITH gc_grace_seconds = 864000 AND bloom_filter_fp_chance = 0.1 AND caching = { 'keys' : 'ALL', 'rows_per_partition' : 'NONE' } AND comment = '' AND compaction = { 'class' : 'org.apache.cassandra.db.compaction.LeveledCompactionStrategy', 'enabled' : 'true', 'max_threshold' : 32, 'min_threshold' : 4 } AND compression = { 'chunk_length_in_kb' : 16, 'class' : 'org.apache.cassandra.io.compress.ZstdCompressor' } AND default_time_to_live = 0 AND speculative_retry = '99p' AND min_index_interval = 128 AND max_index_interval = 2048 AND crc_check_chance = 1.0 AND cdc = false AND memtable_flush_period_in_ms = 0;";
        String actual = CqlTableInfoProvider.removeDeprecatedOptions((String)cql);
        Assertions.assertThat((String)actual).isEqualTo(expected);
    }
}

