/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.cassandra.cache.KeyCacheKey;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.GaugeProvider;
import org.apache.cassandra.io.sstable.IScrubber;
import org.apache.cassandra.io.sstable.MetricsProviders;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.filter.BloomFilterMetrics;
import org.apache.cassandra.io.sstable.format.AbstractSSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReaderLoadingBuilder;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.format.SortedTableScrubber;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.format.big.BigSSTableReaderLoadingBuilder;
import org.apache.cassandra.io.sstable.format.big.BigTableReader;
import org.apache.cassandra.io.sstable.format.big.BigTableScrubber;
import org.apache.cassandra.io.sstable.format.big.BigTableWriter;
import org.apache.cassandra.io.sstable.format.big.IndexSummaryComponent;
import org.apache.cassandra.io.sstable.format.big.RowIndexEntry;
import org.apache.cassandra.io.sstable.indexsummary.IndexSummaryMetrics;
import org.apache.cassandra.io.sstable.keycache.KeyCacheMetrics;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigFormat
extends AbstractSSTableFormat<BigTableReader, BigTableWriter> {
    private static final Logger logger = LoggerFactory.getLogger(BigFormat.class);
    public static final String NAME = "big";
    private final Version latestVersion = new BigVersion(this, BigVersion.current_version);
    private final BigTableReaderFactory readerFactory = new BigTableReaderFactory();
    private final BigTableWriterFactory writerFactory = new BigTableWriterFactory();

    public BigFormat(Map<String, String> options) {
        super(NAME, options);
    }

    public static boolean is(SSTableFormat<?, ?> format) {
        return format.name().equals(NAME);
    }

    public static BigFormat getInstance() {
        return (BigFormat)Objects.requireNonNull(DatabaseDescriptor.getSSTableFormats().get(NAME), "Unknown SSTable format: big");
    }

    public static boolean isSelected() {
        return BigFormat.is(DatabaseDescriptor.getSelectedSSTableFormat());
    }

    @Override
    public Version getLatestVersion() {
        return this.latestVersion;
    }

    @Override
    public Version getVersion(String version) {
        return new BigVersion(this, version);
    }

    public BigTableWriterFactory getWriterFactory() {
        return this.writerFactory;
    }

    public BigTableReaderFactory getReaderFactory() {
        return this.readerFactory;
    }

    @Override
    public Set<Component> allComponents() {
        return Components.ALL_COMPONENTS;
    }

    @Override
    public Set<Component> primaryComponents() {
        return Components.PRIMARY_COMPONENTS;
    }

    @Override
    public Set<Component> batchComponents() {
        return Components.BATCH_COMPONENTS;
    }

    @Override
    public Set<Component> uploadComponents() {
        return Components.UPLOAD_COMPONENTS;
    }

    @Override
    public Set<Component> mutableComponents() {
        return Components.MUTABLE_COMPONENTS;
    }

    @Override
    public Set<Component> generatedOnLoadComponents() {
        return Components.GENERATED_ON_LOAD_COMPONENTS;
    }

    @Override
    public SSTableFormat.KeyCacheValueSerializer<BigTableReader, RowIndexEntry> getKeyCacheValueSerializer() {
        return KeyCacheValueSerializer.instance;
    }

    @Override
    public IScrubber getScrubber(ColumnFamilyStore cfs, LifecycleTransaction transaction, OutputHandler outputHandler, IScrubber.Options options) {
        Preconditions.checkArgument(cfs.metadata().equals(transaction.onlyOne().metadata()), "SSTable metadata does not match current definition");
        return new BigTableScrubber(cfs, transaction, outputHandler, options);
    }

    @Override
    public MetricsProviders getFormatSpecificMetricsProviders() {
        return BigTableSpecificMetricsProviders.instance;
    }

    @Override
    public void deleteOrphanedComponents(Descriptor descriptor, Set<Component> components) {
        SortedTableScrubber.deleteOrphanedComponents(descriptor, components);
    }

    private void delete(Descriptor desc, List<Component> components) {
        logger.info("Deleting sstable: {}", (Object)desc);
        if (components.remove(SSTableFormat.Components.DATA)) {
            components.add(0, SSTableFormat.Components.DATA);
        }
        if (components.remove(Components.SUMMARY)) {
            components.add(Components.SUMMARY);
        }
        for (Component component : components) {
            logger.trace("Deleting component {} of {}", (Object)component, (Object)desc);
            desc.fileFor(component).deleteIfExists();
        }
    }

    @Override
    public void delete(Descriptor desc) {
        try {
            if (DatabaseDescriptor.shouldInvalidateKeycacheOnSSTableDeletion()) {
                Iterator it = CacheService.instance.keyCache.keyIterator();
                while (it.hasNext()) {
                    KeyCacheKey key = (KeyCacheKey)it.next();
                    if (!key.desc.equals(desc)) continue;
                    it.remove();
                }
            }
            this.delete(desc, Lists.newArrayList(Sets.intersection(this.allComponents(), desc.discoverComponents())));
        }
        catch (Throwable t2) {
            JVMStabilityInspector.inspectThrowable(t2);
        }
    }

    public static class BigFormatFactory
    implements SSTableFormat.Factory {
        @Override
        public String name() {
            return BigFormat.NAME;
        }

        @Override
        public SSTableFormat<?, ?> getInstance(Map<String, String> options) {
            return new BigFormat(options);
        }
    }

    private static class BigTableSpecificMetricsProviders
    implements MetricsProviders {
        private static final BigTableSpecificMetricsProviders instance = new BigTableSpecificMetricsProviders();
        private final Iterable<GaugeProvider<?>> gaugeProviders = Iterables.concat(BloomFilterMetrics.instance.getGaugeProviders(), IndexSummaryMetrics.instance.getGaugeProviders(), KeyCacheMetrics.instance.getGaugeProviders());

        private BigTableSpecificMetricsProviders() {
        }

        @Override
        public Iterable<GaugeProvider<?>> getGaugeProviders() {
            return this.gaugeProviders;
        }
    }

    static class BigVersion
    extends Version {
        public static final String current_version = DatabaseDescriptor.getStorageCompatibilityMode().isBefore(5) ? "nb" : "oa";
        public static final String earliest_supported_version = "ma";
        private final boolean isLatestVersion;
        private final int correspondingMessagingVersion;
        private final boolean hasCommitLogLowerBound;
        private final boolean hasCommitLogIntervals;
        private final boolean hasAccurateMinMax;
        private final boolean hasLegacyMinMax;
        private final boolean hasOriginatingHostId;
        private final boolean hasMaxCompressedLength;
        private final boolean hasPendingRepair;
        private final boolean hasMetadataChecksum;
        private final boolean hasIsTransient;
        private final boolean hasImprovedMinMax;
        private final boolean hasPartitionLevelDeletionPresenceMarker;
        private final boolean hasKeyRange;
        private final boolean hasUintDeletionTime;
        private final boolean hasTokenSpaceCoverage;
        private final boolean hasOldBfFormat;

        BigVersion(BigFormat format, String version) {
            super(format, version);
            this.isLatestVersion = version.compareTo(current_version) == 0;
            this.correspondingMessagingVersion = version.compareTo("oa") >= 0 ? 13 : 10;
            this.hasCommitLogLowerBound = version.compareTo("mb") >= 0;
            this.hasCommitLogIntervals = version.compareTo("mc") >= 0;
            this.hasAccurateMinMax = version.matches("(m[d-z])|(n[a-z])");
            this.hasLegacyMinMax = version.matches("(m[a-z])|(n[a-z])");
            this.hasOriginatingHostId = version.compareTo("nb") >= 0 || version.matches("(m[e-z])");
            this.hasMaxCompressedLength = version.compareTo("na") >= 0;
            this.hasPendingRepair = version.compareTo("na") >= 0;
            this.hasIsTransient = version.compareTo("na") >= 0;
            this.hasMetadataChecksum = version.compareTo("na") >= 0;
            this.hasOldBfFormat = version.compareTo("na") < 0;
            this.hasImprovedMinMax = version.compareTo("oa") >= 0;
            this.hasPartitionLevelDeletionPresenceMarker = version.compareTo("oa") >= 0;
            this.hasKeyRange = version.compareTo("oa") >= 0;
            this.hasUintDeletionTime = version.compareTo("oa") >= 0;
            this.hasTokenSpaceCoverage = version.compareTo("oa") >= 0;
        }

        @Override
        public boolean isLatestVersion() {
            return this.isLatestVersion;
        }

        @Override
        public int correspondingMessagingVersion() {
            return this.correspondingMessagingVersion;
        }

        @Override
        public boolean hasCommitLogLowerBound() {
            return this.hasCommitLogLowerBound;
        }

        @Override
        public boolean hasCommitLogIntervals() {
            return this.hasCommitLogIntervals;
        }

        @Override
        public boolean hasMaxCompressedLength() {
            return this.hasMaxCompressedLength;
        }

        @Override
        public boolean hasPendingRepair() {
            return this.hasPendingRepair;
        }

        @Override
        public boolean hasIsTransient() {
            return this.hasIsTransient;
        }

        @Override
        public boolean hasMetadataChecksum() {
            return this.hasMetadataChecksum;
        }

        @Override
        public boolean hasOldBfFormat() {
            return this.hasOldBfFormat;
        }

        @Override
        public boolean hasAccurateMinMax() {
            return this.hasAccurateMinMax;
        }

        @Override
        public boolean hasLegacyMinMax() {
            return this.hasLegacyMinMax;
        }

        @Override
        public boolean hasOriginatingHostId() {
            return this.hasOriginatingHostId;
        }

        @Override
        public boolean hasImprovedMinMax() {
            return this.hasImprovedMinMax;
        }

        @Override
        public boolean hasTokenSpaceCoverage() {
            return this.hasTokenSpaceCoverage;
        }

        @Override
        public boolean hasPartitionLevelDeletionsPresenceMarker() {
            return this.hasPartitionLevelDeletionPresenceMarker;
        }

        @Override
        public boolean hasUIntDeletionTime() {
            return this.hasUintDeletionTime;
        }

        @Override
        public boolean hasKeyRange() {
            return this.hasKeyRange;
        }

        @Override
        public boolean isCompatible() {
            return this.version.compareTo(earliest_supported_version) >= 0 && this.version.charAt(0) <= current_version.charAt(0);
        }

        @Override
        public boolean isCompatibleForStreaming() {
            return this.isCompatible() && this.version.charAt(0) == current_version.charAt(0);
        }
    }

    static class BigTableWriterFactory
    implements SSTableFormat.SSTableWriterFactory<BigTableWriter, BigTableWriter.Builder> {
        BigTableWriterFactory() {
        }

        @Override
        public long estimateSize(SSTableWriter.SSTableSizeParameters parameters) {
            return (long)((double)(parameters.partitionKeysSize() + parameters.partitionKeysSize() + parameters.dataSize()) * 1.2);
        }

        @Override
        public BigTableWriter.Builder builder(Descriptor descriptor) {
            return new BigTableWriter.Builder(descriptor);
        }
    }

    static class BigTableReaderFactory
    implements SSTableFormat.SSTableReaderFactory<BigTableReader, BigTableReader.Builder> {
        BigTableReaderFactory() {
        }

        public BigTableReader.Builder builder(Descriptor descriptor) {
            return new BigTableReader.Builder(descriptor);
        }

        @Override
        public SSTableReaderLoadingBuilder<BigTableReader, BigTableReader.Builder> loadingBuilder(Descriptor descriptor, TableMetadataRef tableMetadataRef, Set<Component> components) {
            return new BigSSTableReaderLoadingBuilder((SSTable.Builder<?, ?>)((SSTable.Builder)new SSTable.Builder(descriptor).setTableMetadataRef(tableMetadataRef)).setComponents(components));
        }

        @Override
        public Pair<DecoratedKey, DecoratedKey> readKeyRange(Descriptor descriptor, IPartitioner partitioner) throws IOException {
            return IndexSummaryComponent.loadFirstAndLastKey(descriptor.fileFor(Components.SUMMARY), partitioner);
        }

        @Override
        public Class<BigTableReader> getReaderClass() {
            return BigTableReader.class;
        }
    }

    static class KeyCacheValueSerializer
    implements SSTableFormat.KeyCacheValueSerializer<BigTableReader, RowIndexEntry> {
        private static final KeyCacheValueSerializer instance = new KeyCacheValueSerializer();

        KeyCacheValueSerializer() {
        }

        @Override
        public void skip(DataInputPlus input) throws IOException {
            RowIndexEntry.Serializer.skipForCache(input, BigFormat.getInstance().latestVersion);
        }

        @Override
        public RowIndexEntry deserialize(BigTableReader reader, DataInputPlus input) throws IOException {
            return reader.deserializeKeyCacheValue(input);
        }

        @Override
        public void serialize(RowIndexEntry entry, DataOutputPlus output) throws IOException {
            entry.serializeForCache(output);
        }
    }

    public static class Components
    extends SSTableFormat.Components {
        public static final Component PRIMARY_INDEX = Types.PRIMARY_INDEX.getSingleton();
        public static final Component SUMMARY = Types.SUMMARY.getSingleton();
        private static final Set<Component> BATCH_COMPONENTS = ImmutableSet.of(DATA, PRIMARY_INDEX, COMPRESSION_INFO, FILTER, STATS);
        private static final Set<Component> PRIMARY_COMPONENTS = ImmutableSet.of(DATA, PRIMARY_INDEX);
        private static final Set<Component> GENERATED_ON_LOAD_COMPONENTS = ImmutableSet.of(FILTER, SUMMARY);
        private static final Set<Component> MUTABLE_COMPONENTS = ImmutableSet.of(STATS, SUMMARY);
        private static final Set<Component> UPLOAD_COMPONENTS = ImmutableSet.of(DATA, PRIMARY_INDEX, SUMMARY, COMPRESSION_INFO, STATS);
        private static final Set<Component> ALL_COMPONENTS = ImmutableSet.of(DATA, PRIMARY_INDEX, STATS, COMPRESSION_INFO, FILTER, SUMMARY, new Component[]{DIGEST, CRC, TOC});

        public static class Types
        extends SSTableFormat.Components.Types {
            public static final Component.Type PRIMARY_INDEX = Component.Type.createSingleton("PRIMARY_INDEX", "Index.db", true, BigFormat.class);
            public static final Component.Type SUMMARY = Component.Type.createSingleton("SUMMARY", "Summary.db", true, BigFormat.class);
        }
    }
}

