/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.analyzer.filter;

import java.util.Locale;
import org.apache.cassandra.index.sasi.analyzer.filter.FilterPipelineTask;
import org.apache.cassandra.index.sasi.analyzer.filter.StemmerFactory;
import org.tartarus.snowball.SnowballStemmer;

public class StemmingFilters {

    public static class DefaultStemmingFilter
    extends FilterPipelineTask<String, String> {
        private SnowballStemmer stemmer;

        public DefaultStemmingFilter(Locale locale) {
            this.stemmer = StemmerFactory.getStemmer(locale);
        }

        @Override
        public String process(String input) throws Exception {
            if (input == null || this.stemmer == null) {
                return input;
            }
            this.stemmer.setCurrent(input);
            return this.stemmer.stem() ? this.stemmer.getCurrent() : input;
        }
    }
}

