/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.util.List;
import org.apache.cassandra.auth.AllowAllAuthenticator;
import org.apache.cassandra.auth.AllowAllAuthorizer;
import org.apache.cassandra.auth.AllowAllCIDRAuthorizer;
import org.apache.cassandra.auth.AllowAllInternodeAuthenticator;
import org.apache.cassandra.auth.AllowAllNetworkAuthorizer;
import org.apache.cassandra.auth.CassandraRoleManager;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.auth.IAuthorizer;
import org.apache.cassandra.auth.ICIDRAuthorizer;
import org.apache.cassandra.auth.IInternodeAuthenticator;
import org.apache.cassandra.auth.INetworkAuthorizer;
import org.apache.cassandra.auth.IRoleManager;
import org.apache.cassandra.auth.MutualTlsAuthenticator;
import org.apache.cassandra.auth.PasswordAuthenticator;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthConfig {
    private static final Logger logger = LoggerFactory.getLogger(AuthConfig.class);
    private static boolean initialized;

    public static void applyAuth() {
        if (initialized) {
            return;
        }
        initialized = true;
        Config conf = DatabaseDescriptor.getRawConfig();
        IAuthenticator authenticator = AuthConfig.authInstantiate(conf.authenticator, AllowAllAuthenticator.class);
        if (!(authenticator instanceof PasswordAuthenticator || authenticator instanceof MutualTlsAuthenticator || conf.credentials_update_interval == null && conf.credentials_validity.toMilliseconds() == 2000 && conf.credentials_cache_max_entries == 1000)) {
            logger.info("Configuration options credentials_update_interval, credentials_validity and credentials_cache_max_entries may not be applicable for the configured authenticator ({})", (Object)authenticator.getClass().getName());
        }
        DatabaseDescriptor.setAuthenticator(authenticator);
        IAuthorizer authorizer = AuthConfig.authInstantiate(conf.authorizer, AllowAllAuthorizer.class);
        if (!authenticator.requireAuthentication() && authorizer.requireAuthorization()) {
            throw new ConfigurationException(authorizer.getClass().getName() + " has authorization enabled which requires " + authenticator.getClass().getName() + " to enable authentication", false);
        }
        DatabaseDescriptor.setAuthorizer(authorizer);
        IRoleManager roleManager = AuthConfig.authInstantiate(conf.role_manager, CassandraRoleManager.class);
        if (authenticator instanceof PasswordAuthenticator && !(roleManager instanceof CassandraRoleManager)) {
            throw new ConfigurationException(authenticator.getClass().getName() + " requires " + CassandraRoleManager.class.getName(), false);
        }
        DatabaseDescriptor.setRoleManager(roleManager);
        IInternodeAuthenticator internodeAuthenticator = AuthConfig.authInstantiate(conf.internode_authenticator, AllowAllInternodeAuthenticator.class);
        DatabaseDescriptor.setInternodeAuthenticator(internodeAuthenticator);
        INetworkAuthorizer networkAuthorizer = AuthConfig.authInstantiate(conf.network_authorizer, AllowAllNetworkAuthorizer.class);
        if (networkAuthorizer.requireAuthorization() && !authenticator.requireAuthentication()) {
            throw new ConfigurationException(conf.network_authorizer + " can't be used with " + conf.authenticator.class_name, false);
        }
        DatabaseDescriptor.setNetworkAuthorizer(networkAuthorizer);
        ICIDRAuthorizer cidrAuthorizer = AuthConfig.authInstantiate(conf.cidr_authorizer, AllowAllCIDRAuthorizer.class);
        if (cidrAuthorizer.requireAuthorization() && !authenticator.requireAuthentication()) {
            throw new ConfigurationException(conf.cidr_authorizer + " can't be used with " + conf.authenticator, false);
        }
        DatabaseDescriptor.setCIDRAuthorizer(cidrAuthorizer);
        authenticator.validateConfiguration();
        authorizer.validateConfiguration();
        roleManager.validateConfiguration();
        networkAuthorizer.validateConfiguration();
        cidrAuthorizer.validateConfiguration();
        DatabaseDescriptor.getInternodeAuthenticator().validateConfiguration();
    }

    private static <T> T authInstantiate(ParameterizedClass authCls, Class<T> defaultCls) {
        if (authCls != null && authCls.class_name != null) {
            String authPackage = AuthConfig.class.getPackage().getName();
            return (T)ParameterizedClass.newInstance(authCls, List.of("", authPackage));
        }
        try {
            return defaultCls.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ConfigurationException("Failed to instantiate " + defaultCls.getName(), e);
        }
    }
}

