/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jetbrains.annotations.Nullable;

public final class Annotations {
    private Annotations() {
    }

    public static <A extends Annotation> A findAnnotation(Class<A> annoClass, Class<?> aClass, String name, Class<?>[] parameterTypes) {
        A methodId;
        try {
            Method m4 = aClass.getMethod(name, parameterTypes);
            methodId = m4.getAnnotation(annoClass);
            if (methodId != null) {
                return methodId;
            }
        }
        catch (NoSuchMethodException m4) {
            // empty catch block
        }
        Class<?> superclass = aClass.getSuperclass();
        if (superclass != null && superclass != Object.class && (methodId = Annotations.findAnnotation(annoClass, superclass, name, parameterTypes)) != null) {
            return methodId;
        }
        for (Class<?> iClass : aClass.getInterfaces()) {
            methodId = Annotations.findAnnotation(annoClass, iClass, name, parameterTypes);
            if (methodId == null) continue;
            return methodId;
        }
        return null;
    }

    @Nullable
    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationClass) {
        A methodId = method.getAnnotation(annotationClass);
        if (methodId == null) {
            methodId = Annotations.findAnnotation(annotationClass, method.getDeclaringClass(), method.getName(), method.getParameterTypes());
        }
        return methodId;
    }
}

