/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.cleaner.CleanerServiceLocator;
import net.openhft.chronicle.core.internal.util.DirectBufferUtil;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.MonitorReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.util.Time;
import org.jetbrains.annotations.NotNull;
import sun.nio.ch.IOStatus;

public final class IOTools {
    public static final int IOSTATUS_INTERRUPTED = -3;
    private static final Map<Class<?>, AtomicInteger> COUNTER_MAP = new ConcurrentHashMap();
    private static final Set<String> CLOSED_MESSAGES = new HashSet<String>(Arrays.asList("An established connection was aborted by the software in your host machine", "An existing connection was forcibly closed by the remote host", "Broken pipe", "Broken pipe (Write failed)", "Connection reset", "Connection reset by peer", "Remotely Closed", "Software caused connection abort: socket write error", "Socket is closed", "Stream is closed", "Stream closed"));

    private IOTools() {
    }

    public static boolean isClosedException(Exception e) {
        Language.warnOnce();
        return e instanceof IOException && (CLOSED_MESSAGES.contains(e.getMessage()) || e.getClass().getName().contains("Close"));
    }

    public static boolean shallowDeleteDirWithFiles(@NotNull String directory) throws IORuntimeException {
        return IOTools.shallowDeleteDirWithFiles(new File(directory));
    }

    public static boolean shallowDeleteDirWithFiles(@NotNull File dir) throws IORuntimeException {
        return IOTools.deleteDirWithFiles(dir, 1);
    }

    public static boolean deleteDirWithFiles(String ... dirs) throws IORuntimeException {
        boolean result = true;
        for (String dir : dirs) {
            boolean r = IOTools.deleteDirWithFiles(dir, 20);
            result &= r;
        }
        return result;
    }

    public static boolean deleteDirWithFiles(@NotNull String dir, int maxDepth) throws IORuntimeException {
        return IOTools.deleteDirWithFiles(new File(dir), maxDepth);
    }

    public static boolean deleteDirWithFiles(@NotNull File dir) throws IORuntimeException {
        return IOTools.deleteDirWithFiles(dir, 20);
    }

    public static boolean deleteDirWithFiles(@NotNull File dir, int maxDepth) throws IORuntimeException {
        File[] entries = dir.listFiles();
        if (entries == null) {
            return false;
        }
        Stream.of(entries).filter(File::isDirectory).forEach(f -> {
            if (maxDepth < 1) {
                throw new AssertionError((Object)("Contains directory " + f));
            }
            IOTools.deleteDirWithFiles(f, maxDepth - 1);
        });
        Stream.of(entries).forEach(f -> {
            try {
                Files.delete(f.toPath());
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (IOException e) {
                Jvm.debug().on(Closeable.class, "Failed to delete " + f, e);
            }
        });
        return dir.delete();
    }

    public static void deleteDirWithFilesOrThrow(String ... dirs) throws IORuntimeException {
        File[] files = (File[])Arrays.stream(dirs).map(File::new).toArray(File[]::new);
        IOTools.deleteDirWithFilesOrThrow(files);
    }

    public static void deleteDirWithFilesOrThrow(File ... dirs) throws IORuntimeException {
        for (File dir : dirs) {
            if (!IOTools.deleteDirWithFiles(dir) && dir.exists()) {
                throw new AssertionError((Object)("Could not delete " + dir));
            }
        }
    }

    public static void deleteDirWithFilesOrWait(long timeoutMs, @NotNull File dir) {
        long startTs = System.currentTimeMillis();
        do {
            if (IOTools.deleteDirWithFiles(dir)) {
                return;
            }
            if (!dir.exists()) {
                return;
            }
            Jvm.pause(50L);
        } while (System.currentTimeMillis() - startTs < timeoutMs);
        throw new AssertionError((Object)("Failed to delete dir " + dir + " within " + timeoutMs + "ms"));
    }

    @NotNull
    public static URL urlFor(Class<?> clazz, String name) throws FileNotFoundException {
        return IOTools.urlFor(clazz.getClassLoader(), name);
    }

    @NotNull
    public static URL urlFor(ClassLoader classLoader, String name) throws FileNotFoundException {
        URL url = classLoader.getResource(name);
        if (url == null && name.startsWith("/")) {
            url = classLoader.getResource(name.substring(1));
        }
        if (url == null) {
            url = classLoader.getResource(name + ".gz");
        }
        if (url == null && new File(name).exists()) {
            try {
                url = new URL("file", "", new File(name).getAbsolutePath());
            }
            catch (MalformedURLException e) {
                FileNotFoundException fnfe = new FileNotFoundException(name);
                fnfe.initCause(e);
                throw fnfe;
            }
        }
        if (url == null) {
            throw new FileNotFoundException(name);
        }
        return url;
    }

    public static InputStream open(URL url) throws IOException {
        InputStream in = url.openStream();
        if (url.getFile().endsWith(".gz")) {
            return new GZIPInputStream(in);
        }
        return in;
    }

    public static byte[] readFile(Class<?> clazz, @NotNull String name) throws IOException {
        URL url = IOTools.urlFor(clazz, name);
        InputStream is = IOTools.open(url);
        return IOTools.readAsBytes(is);
    }

    /*
     * Loose catch block
     */
    public static byte[] readAsBytes(InputStream is) throws IOException {
        if (is instanceof FileInputStream) {
            try (FileInputStream fis = (FileInputStream)is;){
                byte[] bytes = new byte[fis.available()];
                int read = fis.read(bytes);
                if (read != bytes.length) {
                    throw new AssertionError();
                }
                byte[] byArray = bytes;
                return byArray;
            }
        }
        try {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream(Math.min(512, is.available()));){
                int len;
                byte[] bytes = new byte[1024];
                while ((len = is.read(bytes)) > 0) {
                    out.write(bytes, 0, len);
                }
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Closeable.closeQuietly((Object)is);
        }
    }

    public static void writeFile(@NotNull String filename, @NotNull byte[] bytes) throws IOException {
        try (@NotNull FileOutputStream out0 = new FileOutputStream(filename);){
            OutputStream out = out0;
            if (filename.endsWith(".gz")) {
                out = new GZIPOutputStream(out);
            }
            ((OutputStream)out).write(bytes);
            ((OutputStream)out).close();
        }
    }

    @NotNull
    public static String tempName(@NotNull String filename) {
        int ext = filename.lastIndexOf(46);
        if (ext > 0 && ext > filename.length() - 5) {
            return filename.substring(0, ext) + System.nanoTime() + filename.substring(ext);
        }
        return filename + System.nanoTime();
    }

    public static void clean(ByteBuffer bb) {
        CleanerServiceLocator.cleanerService().clean(bb);
    }

    public static void createDirectories(Path dir) throws IOException {
        block6: {
            if (dir == null || dir.getNameCount() == 0 || Files.isDirectory(dir, new LinkOption[0])) {
                return;
            }
            IOTools.createDirectories(dir.getParent());
            try {
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                if (Files.isSymbolicLink(dir)) {
                    throw new IOException("Symbolic link from " + dir + " to " + Files.readSymbolicLink(dir) + " is broken", e);
                }
                if (Files.isRegularFile(dir, new LinkOption[0])) {
                    throw new IOException("Cannot create a directory with the same name as a file " + dir, e);
                }
            }
            catch (AccessDeniedException e) {
                if (dir.toFile().canWrite()) break block6;
                throw new IOException("Cannot write to " + dir, e);
            }
        }
    }

    static AtomicInteger counter(Class<?> type) {
        return COUNTER_MAP.computeIfAbsent(type, k -> new AtomicInteger());
    }

    public static File createTempFile(String s2) {
        File file = IOTools.createTempDirectory(s2).toFile();
        file.deleteOnExit();
        return file;
    }

    public static Path createTempDirectory(String s2) {
        new File(OS.getTarget()).mkdir();
        return Paths.get(OS.getTarget(), s2 + "-" + Time.uniqueId() + ".tmp");
    }

    public static void unmonitor(Object t2) {
        IOTools.unmonitor(t2, 4);
    }

    private static void unmonitor(Object t2, int depth) {
        if (t2 == null) {
            return;
        }
        if (t2 instanceof Serializable || t2 instanceof MonitorReferenceCounted) {
            return;
        }
        if (t2 instanceof Closeable) {
            AbstractCloseable.unmonitor((Closeable)t2);
        }
        if (t2 instanceof ReferenceCounted) {
            AbstractReferenceCounted.unmonitor((ReferenceCounted)t2);
        }
        if (depth > 0) {
            IOTools.unmonitor(t2.getClass(), t2, depth - 1);
        }
    }

    private static void unmonitor(Class<?> aClass, Object t2, int depth) {
        if (aClass == null || aClass == Object.class) {
            return;
        }
        IOTools.unmonitor(aClass.getSuperclass(), t2, depth);
        for (Field field : aClass.getDeclaredFields()) {
            if (field.getType().isPrimitive() || Modifier.isStatic(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
            }
            catch (Exception e) {
                if (Jvm.isJava9Plus()) continue;
                Jvm.warn().on(IOTools.class, e);
                continue;
            }
            try {
                Object o = field.get(t2);
                if (o == null) continue;
                IOTools.unmonitor(o, depth);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Jvm.warn().on(IOTools.class, e);
            }
        }
    }

    public static boolean isDirectBuffer(ByteBuffer byteBuffer) {
        return byteBuffer.isDirect();
    }

    public static long addressFor(ByteBuffer byteBuffer) {
        return DirectBufferUtil.addressOrThrow(byteBuffer);
    }

    public static int normaliseIOStatus(int n) {
        return IOStatus.normalize(n);
    }

    @NotNull
    static Runnable close3(SocketChannel sc, SocketChannel s2) {
        return () -> {
            Jvm.pause(50L);
            System.out.println("Close " + sc);
            Closeable.closeQuietly((Object)sc);
            Jvm.pause(10L);
            Closeable.closeQuietly((Object)s2);
        };
    }

    @NotNull
    static Runnable close4(SocketChannel sc, SocketChannel s2, Thread main) {
        return () -> {
            Jvm.pause(50L);
            main.interrupt();
            Jvm.pause(10L);
            Closeable.closeQuietly((Object)sc);
            Closeable.closeQuietly((Object)s2);
        };
    }

    private static final class Language {
        static final /* synthetic */ boolean $assertionsDisabled;

        private Language() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void addRegionalMessages() throws IOException {
            try (ServerSocketChannel ssc = ServerSocketChannel.open();){
                Throwable throwable;
                SocketChannel s2;
                OutputStream os2;
                Throwable throwable2;
                SocketChannel s22;
                ssc.bind(new InetSocketAddress(0));
                int port = ssc.socket().getLocalPort();
                InetSocketAddress address = new InetSocketAddress("localhost", port);
                try (Socket s3 = new Socket("localhost", port);){
                    s22 = ssc.accept();
                    throwable2 = null;
                    try {
                        os2 = s3.getOutputStream();
                        s22.close();
                        byte[] bytes = new byte[512];
                        try {
                            for (int i = 0; i < 100; ++i) {
                                os2.write(bytes);
                            }
                        }
                        catch (IOException ioe) {
                            CLOSED_MESSAGES.add(ioe.getMessage());
                        }
                        finally {
                            s3.close();
                        }
                        try {
                            s3.getOutputStream().write(bytes);
                        }
                        catch (IOException ioe) {
                            CLOSED_MESSAGES.add(ioe.getMessage());
                        }
                    }
                    catch (Throwable os2) {
                        throwable2 = os2;
                        throw os2;
                    }
                    finally {
                        if (s22 != null) {
                            if (throwable2 != null) {
                                try {
                                    s22.close();
                                }
                                catch (Throwable os2) {
                                    throwable2.addSuppressed(os2);
                                }
                            } else {
                                s22.close();
                            }
                        }
                    }
                }
                try {
                    s3 = new Socket("localhost", port);
                    var5_8 = null;
                    try {
                        s22 = ssc.accept();
                        throwable2 = null;
                        try {
                            os2 = s3.getOutputStream();
                            os2.close();
                            os2.write(1);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (s22 != null) {
                                if (throwable2 != null) {
                                    try {
                                        s22.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                } else {
                                    s22.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        var5_8 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (s3 != null) {
                            if (var5_8 != null) {
                                try {
                                    s3.close();
                                }
                                catch (Throwable throwable6) {
                                    var5_8.addSuppressed(throwable6);
                                }
                            } else {
                                s3.close();
                            }
                        }
                    }
                }
                catch (IOException ioe) {
                    CLOSED_MESSAGES.add(ioe.getMessage());
                }
                ByteBuffer bytes = ByteBuffer.allocateDirect(1024);
                try (SocketChannel sc = SocketChannel.open(address);){
                    s2 = ssc.accept();
                    throwable = null;
                    try {
                        try {
                            for (int i = 0; i < 100; ++i) {
                                bytes.clear();
                                sc.write(bytes);
                            }
                        }
                        catch (IOException ioe) {
                            CLOSED_MESSAGES.add(ioe.getMessage());
                        }
                    }
                    catch (Throwable ioe) {
                        throwable = ioe;
                        throw ioe;
                    }
                    finally {
                        if (s2 != null) {
                            if (throwable != null) {
                                try {
                                    s2.close();
                                }
                                catch (Throwable ioe) {
                                    throwable.addSuppressed(ioe);
                                }
                            } else {
                                s2.close();
                            }
                        }
                    }
                }
                sc = SocketChannel.open(address);
                var6_9 = null;
                try {
                    s2 = ssc.accept();
                    throwable = null;
                    try {
                        Thread t2 = new Thread(IOTools.close3(sc, s2), "close~3");
                        t2.setDaemon(true);
                        t2.start();
                        try {
                            for (int i = 0; i < 10000; ++i) {
                                bytes.clear();
                                int write = sc.write(bytes);
                                if (!$assertionsDisabled && write <= 0) {
                                    throw new AssertionError();
                                }
                            }
                        }
                        catch (IOException ioe) {
                            CLOSED_MESSAGES.add(ioe.getMessage());
                        }
                    }
                    catch (Throwable t2) {
                        throwable = t2;
                        throw t2;
                    }
                    finally {
                        if (s2 != null) {
                            if (throwable != null) {
                                try {
                                    s2.close();
                                }
                                catch (Throwable t2) {
                                    throwable.addSuppressed(t2);
                                }
                            } else {
                                s2.close();
                            }
                        }
                    }
                }
                catch (Throwable s23) {
                    var6_9 = s23;
                    throw s23;
                }
                finally {
                    if (sc != null) {
                        if (var6_9 != null) {
                            try {
                                sc.close();
                            }
                            catch (Throwable s23) {
                                var6_9.addSuppressed(s23);
                            }
                        } else {
                            sc.close();
                        }
                    }
                }
                sc = SocketChannel.open(address);
                var6_9 = null;
                try {
                    s2 = ssc.accept();
                    throwable = null;
                    try {
                        Thread main = Thread.currentThread();
                        Thread t3 = new Thread(IOTools.close4(sc, s2, main), "close~4");
                        t3.setDaemon(true);
                        t3.start();
                        try {
                            for (int i = 0; i < 10000; ++i) {
                                bytes.clear();
                                int write = sc.write(bytes);
                                if (!$assertionsDisabled && write <= 0) {
                                    throw new AssertionError();
                                }
                            }
                        }
                        catch (IOException ioe) {
                            CLOSED_MESSAGES.add(ioe.getMessage());
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (s2 != null) {
                            if (throwable != null) {
                                try {
                                    s2.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                            } else {
                                s2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable9) {
                    var6_9 = throwable9;
                    throw throwable9;
                }
                finally {
                    if (sc != null) {
                        if (var6_9 != null) {
                            try {
                                sc.close();
                            }
                            catch (Throwable throwable10) {
                                var6_9.addSuppressed(throwable10);
                            }
                        } else {
                            sc.close();
                        }
                    }
                }
            }
        }

        static void warnOnce() {
        }

        static {
            boolean bl = $assertionsDisabled = !IOTools.class.desiredAssertionStatus();
            if (!Locale.getDefault().getLanguage().equals(Locale.ENGLISH.getLanguage())) {
                try {
                    Language.addRegionalMessages();
                }
                catch (IOException ioe) {
                    Jvm.warn().on(IOTools.class, "Running under non-English locale '" + Locale.getDefault().getLanguage() + "', transient exceptions will be reported with higher level than necessary.", ioe);
                }
            }
        }
    }
}

