/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.SSTableSummary;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.SSTableCollector;
import org.apache.cassandra.spark.common.Digest;
import org.apache.cassandra.spark.data.FileSystemSSTable;
import org.apache.cassandra.spark.data.QualifiedTableName;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.parquet.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableLister
implements SSTableCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSTableLister.class);
    private static final Comparator<SSTableCollector.SSTableFilesAndRange> SORT_BY_FIRST_TOKEN_THEN_LAST_TOKEN = Comparator.comparing(sstable -> sstable.summary.firstToken).thenComparing(sstable -> sstable.summary.lastToken);
    private final QualifiedTableName qualifiedTableName;
    private final CassandraBridge bridge;
    private final Queue<SSTableCollector.SSTableFilesAndRange> sstables;
    private final Set<Path> sstableDirectories;
    private final Set<Path> knownFiles;
    private final Map<Path, Digest> fileDigests;
    private long totalSize;

    public SSTableLister(QualifiedTableName qualifiedTableName, CassandraBridge bridge) {
        this.qualifiedTableName = qualifiedTableName;
        this.bridge = bridge;
        this.sstables = new LinkedBlockingQueue<SSTableCollector.SSTableFilesAndRange>();
        this.sstableDirectories = new HashSet<Path>();
        this.fileDigests = new HashMap<Path, Digest>();
        this.knownFiles = new HashSet<Path>();
    }

    @Override
    public void includeDirectory(Path dir) {
        if (!this.sstableDirectories.add(dir)) {
            throw new IllegalArgumentException("The directory has been included already! Input dir: " + String.valueOf(dir) + "; existing directories: " + String.valueOf(this.sstableDirectories));
        }
        this.listSSTables(dir).map(this::createSSTableFilesAndRange).sorted(SORT_BY_FIRST_TOKEN_THEN_LAST_TOKEN).forEach(this.sstables::add);
    }

    @Override
    public void includeSSTable(List<Path> sstableComponents) {
        this.knownFiles.addAll(sstableComponents);
        SSTableCollector.SSTableFilesAndRange sstableAndRange = this.createSSTableFilesAndRange(sstableComponents);
        this.sstables.add(sstableAndRange);
    }

    @Override
    public void includeFileDigests(Map<Path, Digest> fileDigests) {
        this.fileDigests.putAll(fileDigests);
    }

    @Override
    public Map<Path, Digest> fileDigests(Set<Path> files) {
        HashMap<Path, Digest> result = new HashMap<Path, Digest>();
        for (Path file : files) {
            Preconditions.checkState((boolean)this.fileDigests.containsKey(file), (String)"File not found in the fileDigests map. File: %s", (Object[])new Object[]{file});
            result.put(file, this.fileDigests.get(file));
        }
        return result;
    }

    @Override
    public long totalSize() {
        return this.totalSize;
    }

    @Override
    public SSTableCollector.SSTableFilesAndRange peek() {
        return this.sstables.peek();
    }

    @Override
    public SSTableCollector.SSTableFilesAndRange consumeOne() {
        SSTableCollector.SSTableFilesAndRange sstable = this.sstables.poll();
        if (sstable != null) {
            this.totalSize -= sstable.size;
        }
        return sstable;
    }

    @Override
    public boolean isEmpty() {
        return this.sstables.isEmpty();
    }

    private Stream<List<Path>> listSSTables(Path dir) {
        Stream<List<Path>> stream;
        block8: {
            HashMap componentsByPrefix = new HashMap();
            Stream<Path> stream2 = Files.list(dir);
            try {
                stream2.forEach(path -> {
                    if (this.knownFiles.contains(path)) {
                        return;
                    }
                    String ssTablePrefix = this.getSSTablePrefix(path.getFileName().toString());
                    if (ssTablePrefix.isEmpty()) {
                        return;
                    }
                    List prefixPaths = componentsByPrefix.computeIfAbsent(ssTablePrefix, ignored -> new ArrayList(8));
                    prefixPaths.add(path);
                });
                stream = componentsByPrefix.values().stream();
                if (stream2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream2 != null) {
                        try {
                            stream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream2.close();
        }
        return stream;
    }

    private long sizeSum(List<Path> files) {
        return files.stream().mapToLong(path -> {
            try {
                BasicFileAttributes fileAttributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                if (fileAttributes != null && fileAttributes.isRegularFile()) {
                    return fileAttributes.size();
                }
                return 0L;
            }
            catch (IOException e) {
                LOGGER.warn("Failed to get size of file. path={}", path);
                return 0L;
            }
        }).sum();
    }

    private String getSSTablePrefix(String componentName) {
        return componentName.substring(0, componentName.lastIndexOf(45) + 1);
    }

    private SSTable buildSSTable(List<Path> components) {
        List dataComponents = components.stream().filter(path -> path.getFileName().toString().contains("Data.db")).collect(Collectors.toList());
        if (dataComponents.size() != 1) {
            throw new IllegalArgumentException("SSTable should have only one data component");
        }
        return new FileSystemSSTable((Path)dataComponents.get(0), true, () -> ((Stats.DoNothingStats)Stats.DoNothingStats.INSTANCE).bufferingInputStreamStats());
    }

    @NotNull
    private SSTableCollector.SSTableFilesAndRange createSSTableFilesAndRange(List<Path> sstableComponents) {
        SSTable sstable = this.buildSSTable(sstableComponents);
        SSTableSummary summary = this.bridge.getSSTableSummary(this.qualifiedTableName.keyspace(), this.qualifiedTableName.table(), sstable);
        long size = this.sizeSum(sstableComponents);
        this.totalSize += size;
        return new SSTableCollector.SSTableFilesAndRange(summary, sstableComponents, size);
    }
}

