/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.cassandra.spark.bulkwriter.BroadcastableJobInfo;
import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.cassandra.spark.bulkwriter.DataTransportInfo;
import org.apache.cassandra.spark.bulkwriter.DigestAlgorithmSupplier;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.TokenPartitioner;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedWriteConf;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.MultiClusterContainer;
import org.apache.cassandra.spark.bulkwriter.token.ConsistencyLevel;
import org.apache.cassandra.spark.data.QualifiedTableName;
import org.apache.cassandra.spark.utils.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CassandraJobInfo
implements JobInfo {
    protected final BulkSparkConf conf;
    protected final MultiClusterContainer<UUID> restoreJobIds;
    protected final TokenPartitioner tokenPartitioner;

    public CassandraJobInfo(BulkSparkConf conf, MultiClusterContainer<UUID> restoreJobIds, TokenPartitioner tokenPartitioner) {
        Preconditions.checkArgument((restoreJobIds.size() > 0 ? 1 : 0) != 0, (String)"restoreJobIds cannot be empty", (Object[])new Object[0]);
        this.restoreJobIds = restoreJobIds;
        this.conf = conf;
        this.tokenPartitioner = tokenPartitioner;
    }

    public CassandraJobInfo(BroadcastableJobInfo broadcastable) {
        this.conf = broadcastable.getConf();
        this.restoreJobIds = broadcastable.getRestoreJobIds();
        this.tokenPartitioner = new TokenPartitioner(broadcastable.getBroadcastableTokenPartitioner());
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        return this.conf.consistencyLevel;
    }

    @Override
    public String getLocalDC() {
        if (this.isCoordinatedWriteEnabled()) {
            throw new UnsupportedOperationException("Method not supported, when coordinated write is enabled. Call-sites should get localDc from #coordinatedWriteConf() method");
        }
        return this.conf.localDC;
    }

    @Override
    public int sstableDataSizeInMiB() {
        return this.conf.sstableDataSizeInMiB;
    }

    @Override
    public int getCommitBatchSize() {
        return this.conf.commitBatchSize;
    }

    @Override
    public boolean skipExtendedVerify() {
        return this.conf.skipExtendedVerify;
    }

    @Override
    public boolean getSkipClean() {
        return this.conf.getSkipClean();
    }

    @Override
    public DataTransportInfo transportInfo() {
        return this.conf.getTransportInfo();
    }

    @Override
    public int jobKeepAliveMinutes() {
        return this.conf.getJobKeepAliveMinutes();
    }

    @Override
    public long jobTimeoutSeconds() {
        return this.conf.getJobTimeoutSeconds();
    }

    @Override
    public int effectiveSidecarPort() {
        return this.conf.getEffectiveSidecarPort();
    }

    @Override
    public double importCoordinatorTimeoutMultiplier() {
        return this.conf.importCoordinatorTimeoutMultiplier;
    }

    @Override
    @Nullable
    public CoordinatedWriteConf coordinatedWriteConf() {
        return this.conf.coordinatedWriteConf();
    }

    @Override
    public int getCommitThreadsPerInstance() {
        return this.conf.commitThreadsPerInstance;
    }

    @Override
    public UUID getRestoreJobId() {
        try {
            return this.getRestoreJobId(null);
        }
        catch (NoSuchElementException nsee) {
            return this.restoreJobIds.getAnyValue();
        }
    }

    @Override
    public UUID getRestoreJobId(@Nullable String clusterId) {
        return (UUID)this.restoreJobIds.getValueOrThrow(clusterId);
    }

    @Override
    public String getConfiguredJobId() {
        return this.conf.configuredJobId;
    }

    @Override
    public TokenPartitioner getTokenPartitioner() {
        return this.tokenPartitioner;
    }

    @Override
    @NotNull
    public DigestAlgorithmSupplier digestAlgorithmSupplier() {
        return this.conf.digestAlgorithmSupplier;
    }

    @Override
    @NotNull
    public QualifiedTableName qualifiedTableName() {
        return new QualifiedTableName(this.conf.keyspace, this.conf.table, this.conf.quoteIdentifiers);
    }
}

