/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationspec.template.spec.containers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1.integrationspec.template.spec.containers.PortsBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"containerPort", "hostIP", "hostPort", "name", "protocol"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Ports
implements Editable<PortsBuilder>,
KubernetesResource {
    @JsonProperty(value="containerPort")
    @Required
    @JsonPropertyDescription(value="Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer containerPort;
    @JsonProperty(value="hostIP")
    @JsonPropertyDescription(value="What host IP to bind the external port to.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String hostIP;
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer hostPort;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String name;
    @JsonProperty(value="protocol")
    @JsonPropertyDescription(value="Protocol for port. Must be UDP, TCP, or SCTP. Defaults to \"TCP\".")
    @JsonSetter(nulls=Nulls.SKIP)
    private String protocol = "TCP";

    public PortsBuilder edit() {
        return new PortsBuilder(this);
    }

    public Integer getContainerPort() {
        return this.containerPort;
    }

    public void setContainerPort(Integer containerPort) {
        this.containerPort = containerPort;
    }

    public String getHostIP() {
        return this.hostIP;
    }

    public void setHostIP(String hostIP) {
        this.hostIP = hostIP;
    }

    public Integer getHostPort() {
        return this.hostPort;
    }

    public void setHostPort(Integer hostPort) {
        this.hostPort = hostPort;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String toString() {
        return "Ports(containerPort=" + this.getContainerPort() + ", hostIP=" + this.getHostIP() + ", hostPort=" + this.getHostPort() + ", name=" + this.getName() + ", protocol=" + this.getProtocol() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Ports)) {
            return false;
        }
        Ports other = (Ports)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$containerPort = this.getContainerPort();
        Integer other$containerPort = other.getContainerPort();
        if (this$containerPort == null ? other$containerPort != null : !((Object)this$containerPort).equals(other$containerPort)) {
            return false;
        }
        Integer this$hostPort = this.getHostPort();
        Integer other$hostPort = other.getHostPort();
        if (this$hostPort == null ? other$hostPort != null : !((Object)this$hostPort).equals(other$hostPort)) {
            return false;
        }
        String this$hostIP = this.getHostIP();
        String other$hostIP = other.getHostIP();
        if (this$hostIP == null ? other$hostIP != null : !this$hostIP.equals(other$hostIP)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        return !(this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Ports;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $containerPort = this.getContainerPort();
        result = result * 59 + ($containerPort == null ? 43 : ((Object)$containerPort).hashCode());
        Integer $hostPort = this.getHostPort();
        result = result * 59 + ($hostPort == null ? 43 : ((Object)$hostPort).hashCode());
        String $hostIP = this.getHostIP();
        result = result * 59 + ($hostIP == null ? 43 : $hostIP.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        return result;
    }
}

