/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.keycloak.KeycloakComponent;

/**
 * Manage Keycloak instances via Admin API.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface KeycloakComponentBuilderFactory {

    /**
     * Keycloak (camel-keycloak)
     * Manage Keycloak instances via Admin API.
     * 
     * Category: security,management
     * Since: 4.15
     * Maven coordinates: org.apache.camel:camel-keycloak
     * 
     * @return the dsl builder
     */
    static KeycloakComponentBuilder keycloak() {
        return new KeycloakComponentBuilderImpl();
    }

    /**
     * Builder for the Keycloak component.
     */
    interface KeycloakComponentBuilder extends ComponentBuilder<KeycloakComponent> {
    
        /**
         * Filter admin events by authentication client ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param authClient the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder authClient(java.lang.String authClient) {
            doSetProperty("authClient", authClient);
            return this;
        }
    
        /**
         * Filter admin events by authentication IP address.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param authIpAddress the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder authIpAddress(java.lang.String authIpAddress) {
            doSetProperty("authIpAddress", authIpAddress);
            return this;
        }
    
        
        /**
         * Keycloak realm to authenticate against. If not specified, the realm
         * parameter is used for authentication. This is useful when you want to
         * authenticate against one realm (e.g., master) but perform operations
         * on another realm.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: master
         * Group: common
         * 
         * @param authRealm the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder authRealm(java.lang.String authRealm) {
            doSetProperty("authRealm", authRealm);
            return this;
        }
    
        /**
         * Filter admin events by authentication realm.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param authRealmFilter the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder authRealmFilter(java.lang.String authRealmFilter) {
            doSetProperty("authRealmFilter", authRealmFilter);
            return this;
        }
    
        /**
         * Filter admin events by authentication user ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param authUser the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder authUser(java.lang.String authUser) {
            doSetProperty("authUser", authUser);
            return this;
        }
    
        /**
         * Filter events by client ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder client(java.lang.String client) {
            doSetProperty("client", client);
            return this;
        }
    
        /**
         * Keycloak client ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder clientId(java.lang.String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
    
        /**
         * Keycloak client secret.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientSecret the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder clientSecret(java.lang.String clientSecret) {
            doSetProperty("clientSecret", clientSecret);
            return this;
        }
    
        /**
         * Component configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.keycloak.KeycloakConfiguration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder configuration(org.apache.camel.component.keycloak.KeycloakConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        /**
         * Filter events by start date/time in milliseconds since epoch.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dateFrom the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder dateFrom(java.lang.String dateFrom) {
            doSetProperty("dateFrom", dateFrom);
            return this;
        }
    
        /**
         * Filter events by end date/time in milliseconds since epoch.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dateTo the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder dateTo(java.lang.String dateTo) {
            doSetProperty("dateTo", dateTo);
            return this;
        }
    
        
        /**
         * Type of events to consume: events or admin-events.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: events
         * Group: common
         * 
         * @param eventType the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder eventType(java.lang.String eventType) {
            doSetProperty("eventType", eventType);
            return this;
        }
    
        /**
         * Offset for pagination (first result index).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param first the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder first(int first) {
            doSetProperty("first", first);
            return this;
        }
    
        /**
         * Filter events by IP address.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ipAddress the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder ipAddress(java.lang.String ipAddress) {
            doSetProperty("ipAddress", ipAddress);
            return this;
        }
    
        /**
         * To use an existing configured Keycloak admin client.
         * 
         * The option is a:
         * &lt;code&gt;org.keycloak.admin.client.Keycloak&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param keycloakClient the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder keycloakClient(org.keycloak.admin.client.Keycloak keycloakClient) {
            doSetProperty("keycloakClient", keycloakClient);
            return this;
        }
    
        
        /**
         * Maximum number of events to retrieve per poll.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: common
         * 
         * @param maxResults the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder maxResults(int maxResults) {
            doSetProperty("maxResults", maxResults);
            return this;
        }
    
        /**
         * The operation to perform.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.keycloak.KeycloakOperations&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder operation(org.apache.camel.component.keycloak.KeycloakOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
    
        /**
         * Filter admin events by operation types (comma-separated list, e.g.,
         * CREATE,UPDATE,DELETE).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param operationTypes the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder operationTypes(java.lang.String operationTypes) {
            doSetProperty("operationTypes", operationTypes);
            return this;
        }
    
        /**
         * Keycloak password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder password(java.lang.String password) {
            doSetProperty("password", password);
            return this;
        }
    
        
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder pojoRequest(boolean pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
    
        
        /**
         * Keycloak realm, the default is master because usually all the
         * operations are done starting from the master realm.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: master
         * Group: common
         * 
         * @param realm the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder realm(java.lang.String realm) {
            doSetProperty("realm", realm);
            return this;
        }
    
        /**
         * Filter admin events by resource path.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param resourcePath the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder resourcePath(java.lang.String resourcePath) {
            doSetProperty("resourcePath", resourcePath);
            return this;
        }
    
        /**
         * Keycloak server URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serverUrl the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder serverUrl(java.lang.String serverUrl) {
            doSetProperty("serverUrl", serverUrl);
            return this;
        }
    
        /**
         * Filter events by event types (comma-separated list, e.g.,
         * LOGIN,LOGOUT).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param types the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder types(java.lang.String types) {
            doSetProperty("types", types);
            return this;
        }
    
        /**
         * Filter events by user ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param user the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder user(java.lang.String user) {
            doSetProperty("user", user);
            return this;
        }
    
        /**
         * Keycloak username.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder username(java.lang.String username) {
            doSetProperty("username", username);
            return this;
        }
    
        
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default KeycloakComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    }

    class KeycloakComponentBuilderImpl
            extends AbstractComponentBuilder<KeycloakComponent>
            implements KeycloakComponentBuilder {
        @Override
        protected KeycloakComponent buildConcreteComponent() {
            return new KeycloakComponent();
        }
        private org.apache.camel.component.keycloak.KeycloakConfiguration getOrCreateConfiguration(KeycloakComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.keycloak.KeycloakConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "authClient": getOrCreateConfiguration((KeycloakComponent) component).setAuthClient((java.lang.String) value); return true;
            case "authIpAddress": getOrCreateConfiguration((KeycloakComponent) component).setAuthIpAddress((java.lang.String) value); return true;
            case "authRealm": getOrCreateConfiguration((KeycloakComponent) component).setAuthRealm((java.lang.String) value); return true;
            case "authRealmFilter": getOrCreateConfiguration((KeycloakComponent) component).setAuthRealmFilter((java.lang.String) value); return true;
            case "authUser": getOrCreateConfiguration((KeycloakComponent) component).setAuthUser((java.lang.String) value); return true;
            case "client": getOrCreateConfiguration((KeycloakComponent) component).setClient((java.lang.String) value); return true;
            case "clientId": getOrCreateConfiguration((KeycloakComponent) component).setClientId((java.lang.String) value); return true;
            case "clientSecret": getOrCreateConfiguration((KeycloakComponent) component).setClientSecret((java.lang.String) value); return true;
            case "configuration": ((KeycloakComponent) component).setConfiguration((org.apache.camel.component.keycloak.KeycloakConfiguration) value); return true;
            case "dateFrom": getOrCreateConfiguration((KeycloakComponent) component).setDateFrom((java.lang.String) value); return true;
            case "dateTo": getOrCreateConfiguration((KeycloakComponent) component).setDateTo((java.lang.String) value); return true;
            case "eventType": getOrCreateConfiguration((KeycloakComponent) component).setEventType((java.lang.String) value); return true;
            case "first": getOrCreateConfiguration((KeycloakComponent) component).setFirst((int) value); return true;
            case "ipAddress": getOrCreateConfiguration((KeycloakComponent) component).setIpAddress((java.lang.String) value); return true;
            case "keycloakClient": getOrCreateConfiguration((KeycloakComponent) component).setKeycloakClient((org.keycloak.admin.client.Keycloak) value); return true;
            case "maxResults": getOrCreateConfiguration((KeycloakComponent) component).setMaxResults((int) value); return true;
            case "operation": getOrCreateConfiguration((KeycloakComponent) component).setOperation((org.apache.camel.component.keycloak.KeycloakOperations) value); return true;
            case "operationTypes": getOrCreateConfiguration((KeycloakComponent) component).setOperationTypes((java.lang.String) value); return true;
            case "password": getOrCreateConfiguration((KeycloakComponent) component).setPassword((java.lang.String) value); return true;
            case "pojoRequest": getOrCreateConfiguration((KeycloakComponent) component).setPojoRequest((boolean) value); return true;
            case "realm": getOrCreateConfiguration((KeycloakComponent) component).setRealm((java.lang.String) value); return true;
            case "resourcePath": getOrCreateConfiguration((KeycloakComponent) component).setResourcePath((java.lang.String) value); return true;
            case "serverUrl": getOrCreateConfiguration((KeycloakComponent) component).setServerUrl((java.lang.String) value); return true;
            case "types": getOrCreateConfiguration((KeycloakComponent) component).setTypes((java.lang.String) value); return true;
            case "user": getOrCreateConfiguration((KeycloakComponent) component).setUser((java.lang.String) value); return true;
            case "username": getOrCreateConfiguration((KeycloakComponent) component).setUsername((java.lang.String) value); return true;
            case "bridgeErrorHandler": ((KeycloakComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "lazyStartProducer": ((KeycloakComponent) component).setLazyStartProducer((boolean) value); return true;
            case "autowiredEnabled": ((KeycloakComponent) component).setAutowiredEnabled((boolean) value); return true;
            default: return false;
            }
        }
    }
}