/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.callables;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jclouds.compute.domain.ExecResponse;

public class ScriptStillRunningException
extends TimeoutException
implements Supplier<ListenableFuture<ExecResponse>> {
    private final ListenableFuture<ExecResponse> delegate;

    public ScriptStillRunningException(long timeout, TimeUnit unit, ListenableFuture<ExecResponse> delegate) {
        this(String.format("time up waiting %ds for %s to complete. call get() on this exception to get access to the task in progress", TimeUnit.SECONDS.convert(timeout, unit), delegate), delegate);
    }

    public ScriptStillRunningException(String message, ListenableFuture<ExecResponse> delegate) {
        super((String)Preconditions.checkNotNull((Object)message, (Object)"message"));
        this.delegate = (ListenableFuture)Preconditions.checkNotNull(delegate, (Object)"delegate");
    }

    public ListenableFuture<ExecResponse> get() {
        return this.delegate;
    }
}

