/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.features;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.swift.v1.SwiftFallbacks;
import org.jclouds.openstack.swift.v1.binders.BindMetadataToHeaders;
import org.jclouds.openstack.swift.v1.domain.Container;
import org.jclouds.openstack.swift.v1.functions.FalseOnAccepted;
import org.jclouds.openstack.swift.v1.functions.ParseContainerFromHeaders;
import org.jclouds.openstack.swift.v1.options.CreateContainerOptions;
import org.jclouds.openstack.swift.v1.options.ListContainerOptions;
import org.jclouds.openstack.swift.v1.options.UpdateContainerOptions;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Beta
public interface ContainerApi {
    @Named(value="container:list")
    @GET
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    @QueryParams(keys={"format"}, values={"json"})
    public FluentIterable<Container> list();

    @Named(value="container:list")
    @GET
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    @QueryParams(keys={"format"}, values={"json"})
    public FluentIterable<Container> list(ListContainerOptions var1);

    @Named(value="container:create")
    @PUT
    @Path(value="/{containerName}")
    @ResponseParser(value=FalseOnAccepted.class)
    public boolean create(@PathParam(value="containerName") String var1);

    @Named(value="container:create")
    @PUT
    @Path(value="/{containerName}")
    @ResponseParser(value=FalseOnAccepted.class)
    public boolean create(@PathParam(value="containerName") String var1, CreateContainerOptions var2);

    @Named(value="container:get")
    @HEAD
    @Path(value="/{containerName}")
    @ResponseParser(value=ParseContainerFromHeaders.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Container get(@PathParam(value="containerName") String var1);

    @Named(value="container:update")
    @POST
    @Path(value="/{containerName}")
    public void update(@PathParam(value="containerName") String var1, UpdateContainerOptions var2);

    @Named(value="container:updateMetadata")
    @POST
    @Path(value="/{containerName}")
    public void updateMetadata(@PathParam(value="containerName") String var1, @BinderParam(value=BindMetadataToHeaders.BindContainerMetadataToHeaders.class) Map<String, String> var2);

    @Named(value="container:deleteMetadata")
    @POST
    @Path(value="/{containerName}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteMetadata(@PathParam(value="containerName") String var1, @BinderParam(value=BindMetadataToHeaders.BindRemoveContainerMetadataToHeaders.class) Map<String, String> var2);

    @Named(value="container:deleteIfEmpty")
    @DELETE
    @Path(value="/{containerName}")
    @Fallback(value=SwiftFallbacks.TrueOn404FalseOn409.class)
    public boolean deleteIfEmpty(@PathParam(value="containerName") String var1) throws IllegalStateException;
}

