/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.twitter.common.args.Parser;
import com.twitter.common.args.ParserOracle;
import com.twitter.common.args.apt.Configuration;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public final class Parsers
implements ParserOracle {
    public static final Splitter MULTI_VALUE_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings();
    private static final Function<Configuration.ParserInfo, Class<?>> INFO_TO_PARSED_TYPE = new Function<Configuration.ParserInfo, Class<?>>(){

        public Class<?> apply(Configuration.ParserInfo parserInfo) {
            try {
                return Class.forName(parserInfo.parsedType);
            }
            catch (ClassNotFoundException e) {
                throw new Configuration.ConfigurationException((Throwable)e);
            }
        }
    };
    @VisibleForTesting
    static final Function<Configuration.ParserInfo, Parser<?>> INFO_TO_PARSER = new Function<Configuration.ParserInfo, Parser<?>>(){

        public Parser<?> apply(Configuration.ParserInfo parserInfo) {
            try {
                Class<?> parserClass = Class.forName(parserInfo.parserClass);
                Constructor<?> constructor = parserClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return (Parser)constructor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new Configuration.ConfigurationException((Throwable)e);
            }
            catch (InstantiationException e) {
                throw new Configuration.ConfigurationException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new Configuration.ConfigurationException((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new Configuration.ConfigurationException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new Configuration.ConfigurationException((Throwable)e);
            }
        }
    };
    private final ImmutableMap<Class<?>, Parser<?>> registry;

    public Parsers(Map<Class<?>, Parser<?>> parsers) {
        Preconditions.checkNotNull(parsers);
        this.registry = ImmutableMap.copyOf(parsers);
    }

    public <T> Parser<T> get(TypeToken<T> type) throws IllegalArgumentException {
        Parser parser;
        for (Class explicitClass = type.getRawType(); (parser = (Parser)this.registry.get((Object)explicitClass)) == null && explicitClass != null; explicitClass = explicitClass.getSuperclass()) {
        }
        Preconditions.checkArgument((parser != null ? 1 : 0) != 0, (Object)("No parser found for " + type));
        Parser parserT = parser;
        return parserT;
    }

    static Parsers fromConfiguration(Configuration configuration) {
        Map parsers = Maps.transformValues((Map)Maps.uniqueIndex((Iterable)configuration.parserInfo(), INFO_TO_PARSED_TYPE), INFO_TO_PARSER);
        return new Parsers(parsers);
    }
}

