/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.internal.jshell.tool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openjdk.tools.internal.jshell.tool.ArgTokenizer;
import org.openjdk.tools.internal.jshell.tool.JShellTool;

class Feedback {
    private static final Pattern FIELD_PATTERN = Pattern.compile("\\{(.*?)\\}");
    private Mode mode = new Mode("", false);
    private final Map<String, Mode> modeMap = new HashMap<String, Mode>();

    Feedback() {
    }

    public boolean shouldDisplayCommandFluff() {
        return this.mode.commandFluff;
    }

    public String getPre() {
        return this.mode.pre;
    }

    public String getPost() {
        return this.mode.post;
    }

    public String getErrorPre() {
        return this.mode.errorPre;
    }

    public String getErrorPost() {
        return this.mode.errorPost;
    }

    public String getFormat(FormatCase fc, FormatWhen fw, FormatAction fa, FormatResolve fr, boolean hasName, boolean hasType, boolean hasResult) {
        return this.mode.getFormat(fc, fw, fa, fr, hasName, hasType, hasResult);
    }

    public String getPrompt(String nextId) {
        return this.mode.getPrompt(nextId);
    }

    public String getContinuationPrompt(String nextId) {
        return this.mode.getContinuationPrompt(nextId);
    }

    public boolean setFeedback(JShellTool tool, ArgTokenizer at) {
        return new FormatSetter(tool, at).setFeedback();
    }

    public boolean setField(JShellTool tool, ArgTokenizer at) {
        return new FormatSetter(tool, at).setField();
    }

    public boolean setFormat(JShellTool tool, ArgTokenizer at) {
        return new FormatSetter(tool, at).setFormat();
    }

    public boolean setNewMode(JShellTool tool, ArgTokenizer at) {
        return new FormatSetter(tool, at).setNewMode();
    }

    public boolean setPrompt(JShellTool tool, ArgTokenizer at) {
        return new FormatSetter(tool, at).setPrompt();
    }

    public void printFeedbackHelp(JShellTool tool) {
        new FormatSetter(tool, null).printFeedbackHelp();
    }

    public void printFieldHelp(JShellTool tool) {
        new FormatSetter(tool, null).printFieldHelp();
    }

    public void printFormatHelp(JShellTool tool) {
        new FormatSetter(tool, null).printFormatHelp();
    }

    public void printNewModeHelp(JShellTool tool) {
        new FormatSetter(tool, null).printNewModeHelp();
    }

    public void printPromptHelp(JShellTool tool) {
        new FormatSetter(tool, null).printPromptHelp();
    }

    private class FormatSetter {
        private final ArgTokenizer at;
        private final JShellTool tool;
        boolean valid = true;

        FormatSetter(JShellTool tool, ArgTokenizer at) {
            this.tool = tool;
            this.at = at;
        }

        void hard(String format, Object ... args) {
            this.tool.hard(format, args);
        }

        <E extends Enum<E>> void hardEnums(EnumSet<E> es, Function<E, String> e2s) {
            this.hardPairs(es.stream(), ev -> ev.name().toLowerCase(Locale.US), e2s);
        }

        <T> void hardPairs(Stream<T> stream, Function<T, String> a, Function<T, String> b) {
            this.tool.hardPairs(stream, a, b);
        }

        void fluff(String format, Object ... args) {
            this.tool.fluff(format, args);
        }

        void error(String format, Object ... args) {
            this.tool.error(format, args);
        }

        void errorat(String format, Object ... args) {
            Object[] a2 = Arrays.copyOf(args, args.length + 1);
            a2[args.length] = this.at.whole();
            this.tool.error(format + " -- /set %s", a2);
        }

        void fluffRaw(String format, Object ... args) {
            this.tool.fluffRaw(format, args);
        }

        boolean setPrompt() {
            Mode m = this.nextMode();
            String prompt = this.nextFormat();
            String continuationPrompt = this.nextFormat();
            if (this.valid) {
                m.setPrompts(prompt, continuationPrompt);
            } else {
                this.fluff("See '/help /set prompt' for help", new Object[0]);
            }
            return this.valid;
        }

        boolean setNewMode() {
            String[] fluffOpt;
            boolean fluff;
            String umode = this.at.next();
            if (umode == null) {
                this.errorat("Expected new feedback mode", new Object[0]);
                this.valid = false;
            }
            if (Feedback.this.modeMap.containsKey(umode)) {
                this.errorat("Expected a new feedback mode name. %s is a known feedback mode", umode);
                this.valid = false;
            }
            boolean bl = fluff = (fluffOpt = this.at.next("command", "quiet")) == null || fluffOpt.length != 1 || "command".equals(fluffOpt[0]);
            if (fluffOpt != null && fluffOpt.length != 1) {
                this.errorat("Specify either 'command' or 'quiet'", new Object[0]);
                this.valid = false;
            }
            Mode om = null;
            String omode = this.at.next();
            if (omode != null) {
                om = this.toMode(omode);
            }
            if (this.valid) {
                Mode nm = om != null ? new Mode(umode, fluff, om) : new Mode(umode, fluff);
                Feedback.this.modeMap.put(umode, nm);
                this.fluff("Created new feedback mode: %s", nm.name);
            } else {
                this.fluff("See '/help /set newmode' for help", new Object[0]);
            }
            return this.valid;
        }

        boolean setFeedback() {
            Mode m = this.nextMode();
            if (this.valid && m != null) {
                Feedback.this.mode = m;
                this.fluff("Feedback mode: %s", ((Feedback)Feedback.this).mode.name);
            } else {
                this.fluff("See '/help /set feedback' for help", new Object[0]);
            }
            return this.valid;
        }

        boolean setFormat() {
            Mode m = this.nextMode();
            String format = this.nextFormat();
            if (this.valid) {
                String s;
                ArrayList<Case<FormatCase, FormatAction, FormatWhen>> specs = new ArrayList<Case<FormatCase, FormatAction, FormatWhen>>();
                while ((s = this.at.next()) != null) {
                    String[] d = s.split("-");
                    specs.add(new Case<FormatCase, FormatAction, FormatWhen>(this.parseFormatCase(d, 0), this.parseFormatAction(d, 1), this.parseFormatWhen(d, 2)));
                }
                if (this.valid && specs.isEmpty()) {
                    this.errorat("At least one selector required", new Object[0]);
                    this.valid = false;
                }
                if (this.valid) {
                    specs.stream().forEach(c -> m.setCases(format, c.e1, c.e2, c.e3));
                }
            }
            if (!this.valid) {
                this.fluff("See '/help /set format' for help", new Object[0]);
            }
            return this.valid;
        }

        boolean setField() {
            Mode m = this.nextMode();
            String fieldName = this.at.next();
            FormatField field = this.parseFormatSelector(fieldName, EnumSet.allOf(FormatField.class), "field");
            String format = this.nextFormat();
            if (this.valid) {
                switch (field) {
                    case ACTION: {
                        String s;
                        ArrayList specs = new ArrayList();
                        while ((s = this.at.next()) != null) {
                            String[] d = s.split("-");
                            specs.add(new Case(this.parseFormatAction(d, 0), this.parseFormatWhen(d, 1)));
                        }
                        if (this.valid && specs.isEmpty()) {
                            this.errorat("At least one selector required", new Object[0]);
                            this.valid = false;
                        }
                        if (!this.valid) break;
                        specs.stream().forEach(c -> m.setActions(format, c.e1, c.e2));
                        break;
                    }
                    case RESOLVE: {
                        String s;
                        ArrayList specs = new ArrayList();
                        while ((s = this.at.next()) != null) {
                            String[] d = s.split("-");
                            specs.add(new Case(this.parseFormatResolve(d, 0), this.parseFormatWhen(d, 1)));
                        }
                        if (this.valid && specs.isEmpty()) {
                            this.errorat("At least one selector required", new Object[0]);
                            this.valid = false;
                        }
                        if (!this.valid) break;
                        specs.stream().forEach(c -> m.setResolves(format, c.e1, c.e2));
                        break;
                    }
                    case WHEN: {
                        String s;
                        ArrayList specs = new ArrayList();
                        while ((s = this.at.next()) != null) {
                            String[] d = s.split("-");
                            specs.add(new Case(this.parseFormatWhen(d, 1), null));
                        }
                        if (this.valid && specs.isEmpty()) {
                            this.errorat("At least one selector required", new Object[0]);
                            this.valid = false;
                        }
                        if (!this.valid) break;
                        specs.stream().forEach(c -> m.setWhens(format, c.e1));
                        break;
                    }
                    case NAME: {
                        m.setName(format);
                        break;
                    }
                    case TYPE: {
                        m.setType(format);
                        break;
                    }
                    case RESULT: {
                        m.setResult(format);
                        break;
                    }
                    case PRE: {
                        m.setPre(format);
                        break;
                    }
                    case POST: {
                        m.setPost(format);
                        break;
                    }
                    case ERRORPRE: {
                        m.setErrorPre(format);
                        break;
                    }
                    case ERRORPOST: {
                        m.setErrorPost(format);
                    }
                }
            }
            if (!this.valid) {
                this.fluff("See '/help /set field' for help", new Object[0]);
            }
            return this.valid;
        }

        Mode nextMode() {
            String umode = this.at.next();
            return this.toMode(umode);
        }

        Mode toMode(String umode) {
            if (umode == null) {
                this.errorat("Expected a feedback mode", new Object[0]);
                this.valid = false;
                return null;
            }
            Mode m = (Mode)Feedback.this.modeMap.get(umode);
            if (m != null) {
                return m;
            }
            Mode[] matches = (Mode[])Feedback.this.modeMap.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(umode)).map(e -> (Mode)e.getValue()).toArray(Mode[]::new);
            if (matches.length == 1) {
                return matches[0];
            }
            this.valid = false;
            if (matches.length == 0) {
                this.errorat("Does not match any current feedback mode: %s", umode);
            } else {
                this.errorat("Matchs more then one current feedback mode: %s", umode);
            }
            this.fluff("The feedback mode should be one of the following:", new Object[0]);
            Feedback.this.modeMap.keySet().stream().forEach(mk -> this.fluff("   %s", mk));
            this.fluff("You may also use just enough letters to make it unique.", new Object[0]);
            return null;
        }

        final String nextFormat() {
            String format = this.at.next();
            if (format == null) {
                this.errorat("Expected format missing", new Object[0]);
                this.valid = false;
                return null;
            }
            if (!this.at.isQuoted()) {
                this.errorat("Format '%s' must be quoted", format);
                this.valid = false;
                return null;
            }
            return format;
        }

        final Set<FormatCase> parseFormatCase(String[] s, int i) {
            return this.parseFormatSelectorStar(s, i, FormatCase.class, EnumSet.allOf(FormatCase.class), "case");
        }

        final Set<FormatAction> parseFormatAction(String[] s, int i) {
            return this.parseFormatSelectorStar(s, i, FormatAction.class, EnumSet.of(FormatAction.ADDED, FormatAction.MODIFIED, FormatAction.REPLACED), "action");
        }

        final Set<FormatResolve> parseFormatResolve(String[] s, int i) {
            return this.parseFormatSelectorStar(s, i, FormatResolve.class, EnumSet.of(FormatResolve.DEFINED, FormatResolve.NOTDEFINED), "resolve");
        }

        final Set<FormatWhen> parseFormatWhen(String[] s, int i) {
            return this.parseFormatSelectorStar(s, i, FormatWhen.class, EnumSet.of(FormatWhen.PRIMARY), "when");
        }

        final <E extends Enum<E>> Set<E> parseFormatSelectorStar(String[] sa, int i, Class<E> klass, EnumSet<E> defaults, String label) {
            String s;
            String string = s = sa.length > i ? sa[i] : null;
            if (s == null || s.isEmpty()) {
                return defaults;
            }
            EnumSet<E> set = EnumSet.noneOf(klass);
            EnumSet<E> values = EnumSet.allOf(klass);
            for (String as : s.split(",")) {
                if (as.equals("*")) {
                    set.addAll(values);
                    continue;
                }
                if (as.isEmpty()) continue;
                set.add(this.parseFormatSelector(as, values, label));
            }
            return set;
        }

        final <E extends Enum<E>> E parseFormatSelector(String s, EnumSet<E> values, String label) {
            if (s == null) {
                this.valid = false;
                return null;
            }
            String u = s.toUpperCase(Locale.US);
            for (Enum c : values) {
                if (!c.name().startsWith(u)) continue;
                return (E)c;
            }
            this.errorat("Not a valid %s: %s, must be one of: %s", label, s, values.stream().map(v -> v.name().toLowerCase(Locale.US)).collect(Collectors.joining(" ")));
            this.valid = false;
            return (E)((Enum)values.iterator().next());
        }

        final void printFormatHelp() {
            this.hard("Set the format for reporting a snippet event.", new Object[0]);
            this.hard("", new Object[0]);
            this.hard("/set format <mode> \"<format>\" <selector>...", new Object[0]);
            this.hard("", new Object[0]);
            this.hard("Where <mode> is the name of a previously defined feedback mode -- see '/help /set newmode'.", new Object[0]);
            this.hard("Where <format> is a quoted string which will have these field substitutions:", new Object[0]);
            this.hard("   {action}    == The action, e.g.: Added, Modified, Assigned, ...", new Object[0]);
            this.hard("   {name}      == The name, e.g.: the variable name, ...", new Object[0]);
            this.hard("   {type}      == The type name", new Object[0]);
            this.hard("   {resolve}   == Unresolved info, e.g.: ', however, it cannot be invoked until'", new Object[0]);
            this.hard("   {result}    == The result value", new Object[0]);
            this.hard("   {when}      == The entered snippet or a resultant update", new Object[0]);
            this.hard("   {pre}       == The feedback prefix", new Object[0]);
            this.hard("   {post}      == The feedback postfix", new Object[0]);
            this.hard("   {errorpre}  == The error prefix", new Object[0]);
            this.hard("   {errorpost} == The error postfix", new Object[0]);
            this.hard("Use '/set field' to set the format of these substitutions.", new Object[0]);
            this.hard("Where <selector> is the context in which the format is applied.", new Object[0]);
            this.hard("The structure of selector is: <case>[-<action>[-<when>]]", new Object[0]);
            this.hard("Where each field component may be missing (indicating defaults),", new Object[0]);
            this.hard("star (indicating all), or a comma separated list of field values.", new Object[0]);
            this.hard("For case, the field values are:", new Object[0]);
            this.hardEnums(EnumSet.allOf(FormatCase.class), ev -> ev.doc);
            this.hard("For action, the field values are:", new Object[0]);
            this.hardEnums(EnumSet.allOf(FormatAction.class), ev -> ev.doc);
            this.hard("For when, the field values are:", new Object[0]);
            this.hardEnums(EnumSet.allOf(FormatWhen.class), ev -> ev.doc);
            this.hard("", new Object[0]);
            this.hard("Example:", new Object[0]);
            this.hard("   /set format example '{pre}{action} variable {name}, reset to null{post}' varreset-*-update", new Object[0]);
        }

        final void printFieldHelp() {
            this.hard("Set the format of a field substitution as used in '/set format'.", new Object[0]);
            this.hard("", new Object[0]);
            this.hard("/set field <mode> <field> \"<format>\" <selector>...", new Object[0]);
            this.hard("", new Object[0]);
            this.hard("Where <mode> is the name of a previously defined feedback mode -- see '/set newmode'.", new Object[0]);
            this.hard("Where <field> is context-specific format to set, each with its own selector structure:", new Object[0]);
            this.hard("   action    == The action. The selector: <action>-<when>.", new Object[0]);
            this.hard("   name      == The name.  '%%s' is the name.  No selectors.", new Object[0]);
            this.hard("   type      == The type name.  '%%s' is the type. No selectors.", new Object[0]);
            this.hard("   resolve   == Unresolved info.  '%%s' is the unresolved list. The selector: <resolve>-<when>.", new Object[0]);
            this.hard("   result    == The result value.  '%%s' is the result value. No selectors.", new Object[0]);
            this.hard("   when      == The entered snippet or a resultant update. The selector: <when>", new Object[0]);
            this.hard("   pre       == The feedback prefix. No selectors.", new Object[0]);
            this.hard("   post      == The feedback postfix. No selectors.", new Object[0]);
            this.hard("   errorpre  == The error prefix. No selectors.", new Object[0]);
            this.hard("   errorpost == The error postfix. No selectors.", new Object[0]);
            this.hard("Where <format> is a quoted string -- see the description specific to the field (above).", new Object[0]);
            this.hard("Where <selector> is the context in which the format is applied (see above).", new Object[0]);
            this.hard("For action, the field values are:", new Object[0]);
            this.hardEnums(EnumSet.allOf(FormatAction.class), ev -> ev.doc);
            this.hard("For when, the field values are:", new Object[0]);
            this.hardEnums(EnumSet.allOf(FormatWhen.class), ev -> ev.doc);
            this.hard("For resolve, the field values are:", new Object[0]);
            this.hardEnums(EnumSet.allOf(FormatResolve.class), ev -> ev.doc);
            this.hard("", new Object[0]);
            this.hard("Example:", new Object[0]);
            this.hard("   /set field example resolve ' which cannot be invoked until%%s is declared' defined-update", new Object[0]);
        }

        final void printFeedbackHelp() {
            this.hard("Set the feedback mode describing displayed feedback for entered snippets and commands.", new Object[0]);
            this.hard("", new Object[0]);
            this.hard("/set feedback <mode>", new Object[0]);
            this.hard("", new Object[0]);
            this.hard("Where <mode> is the name of a previously defined feedback mode.", new Object[0]);
            this.hard("Currently defined feedback modes:", new Object[0]);
            Feedback.this.modeMap.keySet().stream().forEach(m -> this.hard("   %s", m));
            this.hard("User-defined modes can be added, see '/help /set newmode'", new Object[0]);
        }

        final void printNewModeHelp() {
            this.hard("Create a user-defined feedback mode, optionally copying from an existing mode.", new Object[0]);
            this.hard("", new Object[0]);
            this.hard("/set newmode <new-mode> [command|quiet [<old-mode>]]", new Object[0]);
            this.hard("", new Object[0]);
            this.hard("Where <new-mode> is the name of a mode you wish to create.", new Object[0]);
            this.hard("Where <old-mode> is the name of a previously defined feedback mode.", new Object[0]);
            this.hard("If <old-mode> is present, its settings are copied to the new mode.", new Object[0]);
            this.hard("'command' vs 'quiet' determines if informative/verifying command feedback is displayed.", new Object[0]);
            this.hard("", new Object[0]);
            this.hard("Once the new mode is created, use '/set format', '/set field', and '/set prompt' to configure it.", new Object[0]);
            this.hard("Use '/set feedback' to use the new mode.", new Object[0]);
        }

        final void printPromptHelp() {
            this.hard("Set the prompts.  Both the normal prompt and the continuation-prompt must be set.", new Object[0]);
            this.hard("", new Object[0]);
            this.hard("/set prompt <mode> \"<prompt>\" \"<continuation-propmt>\"", new Object[0]);
            this.hard("", new Object[0]);
            this.hard("Where <mode> is the name of a previously defined feedback mode.", new Object[0]);
            this.hard("Where <prompt> and <continuation-propmt> are quoted strings printed as input promptds;", new Object[0]);
            this.hard("Both may optionally contain '%%s' which will be substituted with the next snippet id --", new Object[0]);
            this.hard("note that what is entered may not be assigned that id, for example it may be an error or command.", new Object[0]);
            this.hard("The continuation-prompt is used on the second and subsequent lines of a multi-line snippet.", new Object[0]);
        }

        class Case<E1 extends Enum<E1>, E2 extends Enum<E2>, E3 extends Enum<E3>> {
            Set<E1> e1;
            Set<E2> e2;
            Set<E3> e3;

            Case(Set<E1> e1, Set<E2> e2, Set<E3> e3) {
                this.e1 = e1;
                this.e2 = e2;
                this.e3 = e3;
            }

            Case(Set<E1> e1, Set<E2> e2) {
                this.e1 = e1;
                this.e2 = e2;
            }
        }
    }

    public static enum FormatResolve {
        OK("resolved correctly"),
        DEFINED("defined despite recoverably unresolved references"),
        NOTDEFINED("not defined because of recoverably unresolved references");

        String doc;

        private FormatResolve(String doc) {
            this.doc = doc;
        }
    }

    public static enum FormatWhen {
        PRIMARY("the entered snippet"),
        UPDATE("an update to a dependent snippet");

        String doc;

        private FormatWhen(String doc) {
            this.doc = doc;
        }
    }

    public static enum FormatAction {
        ADDED("snippet has been added"),
        MODIFIED("an existing snippet has been modified"),
        REPLACED("an existing snippet has been replaced with a new snippet"),
        OVERWROTE("an existing snippet has been overwritten"),
        DROPPED("snippet has been dropped"),
        REJECTED("snippet has failed and been rejected");

        String doc;

        private FormatAction(String doc) {
            this.doc = doc;
        }
    }

    public static enum FormatCase {
        IMPORT("import declaration: {action} {name}"),
        CLASS("class, interface, enum, or annotation declaration: {action} {name} {resolve}"),
        INTERFACE("class, interface, enum, or annotation declaration: {action} {name} {resolve}"),
        ENUM("class, interface, enum, or annotation declaration: {action} {name} {resolve}"),
        ANNOTATION("annotation interface declaration: {action} {name} {resolve}"),
        METHOD("method declaration: {action} {name} {type}==parameter-types {resolve}"),
        VARDECL("variable declaration: {action} {name} {type} {resolve}"),
        VARDECLRECOVERABLE("recoverably failed variable declaration: {action} {name} {resolve}"),
        VARINIT("variable declaration with init: {action} {name} {type} {resolve} {result}"),
        VARRESET("variable reset on update: {action} {name}"),
        EXPRESSION("expression: {action}=='Saved to scratch variable' {name} {type} {result}"),
        VARVALUE("variable value expression: {action} {name} {type} {result}"),
        ASSIGNMENT("assign variable: {action} {name} {type} {result}"),
        STATEMENT("statement: {action}");

        String doc;

        private FormatCase(String doc) {
            this.doc = doc;
        }
    }

    public static enum FormatField {
        WHEN,
        ACTION,
        RESOLVE("%1$s"),
        NAME("%2$s"),
        TYPE("%3$s"),
        RESULT("%4$s"),
        PRE,
        POST,
        ERRORPRE,
        ERRORPOST;

        String form;

        private FormatField(String s) {
            this.form = s;
        }

        private FormatField() {
            this.form = null;
        }
    }

    private class Mode {
        final String name;
        final boolean commandFluff;
        final EnumMap<FormatCase, EnumMap<FormatAction, EnumMap<FormatWhen, String>>> cases;
        final EnumMap<FormatAction, EnumMap<FormatWhen, String>> actions;
        final EnumMap<FormatResolve, EnumMap<FormatWhen, String>> resolves;
        final EnumMap<FormatWhen, String> whens;
        final EnumMap<FormatField, Function<Context, String>> fields = new EnumMap(FormatField.class);
        String fname = "%s";
        String ftype = "%s";
        String fresult = "%s";
        String pre = "|  ";
        String post = "\n";
        String errorPre = "|  Error: ";
        String errorPost = "\n";
        String prompt = "\n-> ";
        String continuationPrompt = ">> ";

        Mode(String name, boolean commandFluff) {
            this.fields.put(FormatField.WHEN, c -> c.when());
            this.fields.put(FormatField.ACTION, c -> c.action());
            this.fields.put(FormatField.RESOLVE, c -> c.resolve());
            this.fields.put(FormatField.NAME, c -> c.name());
            this.fields.put(FormatField.TYPE, c -> c.type());
            this.fields.put(FormatField.RESULT, c -> c.result());
            this.fields.put(FormatField.PRE, c -> this.pre);
            this.fields.put(FormatField.POST, c -> this.post);
            this.fields.put(FormatField.ERRORPRE, c -> this.errorPre);
            this.fields.put(FormatField.ERRORPOST, c -> this.errorPost);
            this.name = name;
            this.commandFluff = commandFluff;
            this.cases = new EnumMap(FormatCase.class);
            for (FormatCase formatCase : FormatCase.values()) {
                EnumMap ac = new EnumMap(FormatAction.class);
                this.cases.put(formatCase, ac);
                for (FormatAction formatAction : FormatAction.values()) {
                    EnumMap<FormatWhen, String> aw = new EnumMap<FormatWhen, String>(FormatWhen.class);
                    ac.put(formatAction, aw);
                    for (FormatWhen fw : FormatWhen.values()) {
                        aw.put(fw, "");
                    }
                }
            }
            this.actions = new EnumMap(FormatAction.class);
            for (Enum enum_ : FormatAction.values()) {
                EnumMap<FormatWhen, String> afw = new EnumMap<FormatWhen, String>(FormatWhen.class);
                this.actions.put((FormatAction)enum_, afw);
                for (Enum enum_2 : FormatWhen.values()) {
                    afw.put((FormatWhen)enum_2, enum_.name() + "-" + enum_2.name());
                }
            }
            this.resolves = new EnumMap(FormatResolve.class);
            for (Enum enum_ : FormatResolve.values()) {
                EnumMap<FormatWhen, String> arw = new EnumMap<FormatWhen, String>(FormatWhen.class);
                this.resolves.put((FormatResolve)enum_, arw);
                for (Enum enum_3 : FormatWhen.values()) {
                    arw.put((FormatWhen)enum_3, enum_.name() + "-" + enum_3.name() + ": %s");
                }
            }
            this.whens = new EnumMap(FormatWhen.class);
            for (Enum enum_ : FormatWhen.values()) {
                this.whens.put((FormatWhen)enum_, enum_.name());
            }
        }

        Mode(String name, boolean commandFluff, Mode m) {
            this.fields.put(FormatField.WHEN, c -> c.when());
            this.fields.put(FormatField.ACTION, c -> c.action());
            this.fields.put(FormatField.RESOLVE, c -> c.resolve());
            this.fields.put(FormatField.NAME, c -> c.name());
            this.fields.put(FormatField.TYPE, c -> c.type());
            this.fields.put(FormatField.RESULT, c -> c.result());
            this.fields.put(FormatField.PRE, c -> this.pre);
            this.fields.put(FormatField.POST, c -> this.post);
            this.fields.put(FormatField.ERRORPRE, c -> this.errorPre);
            this.fields.put(FormatField.ERRORPOST, c -> this.errorPost);
            this.name = name;
            this.commandFluff = commandFluff;
            this.cases = new EnumMap(FormatCase.class);
            for (FormatCase formatCase : FormatCase.values()) {
                EnumMap<FormatAction, EnumMap<FormatWhen, String>> ac = new EnumMap<FormatAction, EnumMap<FormatWhen, String>>(FormatAction.class);
                EnumMap<FormatAction, EnumMap<FormatWhen, String>> mc = m.cases.get((Object)formatCase);
                this.cases.put(formatCase, ac);
                for (FormatAction fa : FormatAction.values()) {
                    EnumMap<FormatWhen, String> aw = new EnumMap<FormatWhen, String>(mc.get((Object)fa));
                    ac.put(fa, aw);
                }
            }
            this.actions = new EnumMap(FormatAction.class);
            for (Enum enum_ : FormatAction.values()) {
                EnumMap<FormatWhen, String> afw = new EnumMap<FormatWhen, String>(m.actions.get(enum_));
                this.actions.put((FormatAction)enum_, afw);
            }
            this.resolves = new EnumMap(FormatResolve.class);
            for (Enum enum_ : FormatResolve.values()) {
                EnumMap<FormatWhen, String> arw = new EnumMap<FormatWhen, String>(m.resolves.get(enum_));
                this.resolves.put((FormatResolve)enum_, arw);
            }
            this.whens = new EnumMap<FormatWhen, String>(m.whens);
            this.fname = m.fname;
            this.ftype = m.ftype;
            this.fresult = m.fresult;
            this.pre = m.pre;
            this.post = m.post;
            this.errorPre = m.errorPre;
            this.errorPost = m.errorPost;
            this.prompt = m.prompt;
            this.continuationPrompt = m.continuationPrompt;
        }

        String getFormat(FormatCase fc, FormatWhen fw, FormatAction fa, FormatResolve fr, boolean hasName, boolean hasType, boolean hasResult) {
            Context context = new Context(fc, fw, fa, fr, hasName, hasType, hasResult);
            return context.format();
        }

        void setCases(String format, Collection<FormatCase> cc, Collection<FormatAction> ca, Collection<FormatWhen> cw) {
            for (FormatCase fc : cc) {
                EnumMap<FormatAction, EnumMap<FormatWhen, String>> ma = this.cases.get((Object)fc);
                for (FormatAction fa : ca) {
                    EnumMap<FormatWhen, String> mw = ma.get((Object)fa);
                    for (FormatWhen fw : cw) {
                        mw.put(fw, format);
                    }
                }
            }
        }

        void setActions(String format, Collection<FormatAction> ca, Collection<FormatWhen> cw) {
            for (FormatAction fa : ca) {
                EnumMap<FormatWhen, String> mw = this.actions.get((Object)fa);
                for (FormatWhen fw : cw) {
                    mw.put(fw, format);
                }
            }
        }

        void setResolves(String format, Collection<FormatResolve> cr, Collection<FormatWhen> cw) {
            for (FormatResolve fr : cr) {
                EnumMap<FormatWhen, String> mw = this.resolves.get((Object)fr);
                for (FormatWhen fw : cw) {
                    mw.put(fw, format);
                }
            }
        }

        void setWhens(String format, Collection<FormatWhen> cw) {
            for (FormatWhen fw : cw) {
                this.whens.put(fw, format);
            }
        }

        void setName(String s) {
            this.fname = s;
        }

        void setType(String s) {
            this.ftype = s;
        }

        void setResult(String s) {
            this.fresult = s;
        }

        void setPre(String s) {
            this.pre = s;
        }

        void setPost(String s) {
            this.post = s;
        }

        void setErrorPre(String s) {
            this.errorPre = s;
        }

        void setErrorPost(String s) {
            this.errorPost = s;
        }

        String getPre() {
            return this.pre;
        }

        String getPost() {
            return this.post;
        }

        String getErrorPre() {
            return this.errorPre;
        }

        String getErrorPost() {
            return this.errorPost;
        }

        void setPrompts(String prompt, String continuationPrompt) {
            this.prompt = prompt;
            this.continuationPrompt = continuationPrompt;
        }

        String getPrompt(String nextId) {
            return String.format(this.prompt, nextId);
        }

        String getContinuationPrompt(String nextId) {
            return String.format(this.continuationPrompt, nextId);
        }

        class Context {
            final FormatCase fc;
            final FormatAction fa;
            final FormatResolve fr;
            final FormatWhen fw;
            final boolean hasName;
            final boolean hasType;
            final boolean hasResult;

            Context(FormatCase fc, FormatWhen fw, FormatAction fa, FormatResolve fr, boolean hasName, boolean hasType, boolean hasResult) {
                this.fc = fc;
                this.fa = fa;
                this.fr = fr;
                this.fw = fw;
                this.hasName = hasName;
                this.hasType = hasType;
                this.hasResult = hasResult;
            }

            String when() {
                return Mode.this.whens.get((Object)this.fw);
            }

            String action() {
                return Mode.this.actions.get((Object)this.fa).get((Object)this.fw);
            }

            String resolve() {
                return String.format(Mode.this.resolves.get((Object)this.fr).get((Object)this.fw), FormatField.RESOLVE.form);
            }

            String name() {
                return this.hasName ? String.format(Mode.this.fname, FormatField.NAME.form) : "";
            }

            String type() {
                return this.hasType ? String.format(Mode.this.ftype, FormatField.TYPE.form) : "";
            }

            String result() {
                return this.hasResult ? String.format(Mode.this.fresult, FormatField.RESULT.form) : "";
            }

            String format() {
                String format = Mode.this.cases.get((Object)this.fc).get((Object)this.fa).get((Object)this.fw);
                if (format == null) {
                    return "";
                }
                Matcher m = FIELD_PATTERN.matcher(format);
                StringBuffer sb = new StringBuffer(format.length());
                while (m.find()) {
                    String fieldName = m.group(1).toUpperCase(Locale.US);
                    String sub = null;
                    for (FormatField f : FormatField.values()) {
                        if (!f.name().startsWith(fieldName)) continue;
                        sub = Mode.this.fields.get((Object)f).apply(this);
                        break;
                    }
                    if (sub == null) continue;
                    m.appendReplacement(sb, Matcher.quoteReplacement(sub));
                }
                m.appendTail(sb);
                return sb.toString();
            }
        }
    }
}

