/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util.concurrent;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RetryingFutureTask
extends FutureTask<Boolean> {
    private static Logger LOG = Logger.getLogger(RetryingFutureTask.class.getName());
    protected final ExecutorService executor;
    protected final int maxRetries;
    protected int numRetries = 0;
    protected final Callable<Boolean> callable;

    public RetryingFutureTask(ExecutorService executor, Callable<Boolean> callable, int maxRetries) {
        super(callable);
        this.callable = (Callable)Preconditions.checkNotNull(callable);
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor);
        this.maxRetries = maxRetries;
    }

    protected void retry() {
        this.executor.execute(this);
    }

    @Override
    public void run() {
        boolean success = false;
        try {
            success = this.callable.call();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Exception while executing task.", e);
        }
        if (!success) {
            ++this.numRetries;
            if (this.numRetries > this.maxRetries) {
                LOG.severe("Task did not complete after " + this.maxRetries + " retries, giving up.");
            } else {
                LOG.info("Task was not successful, resubmitting (num retries: " + this.numRetries + ")");
                this.retry();
            }
        } else {
            this.set(true);
        }
    }
}

