/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util;

import com.google.common.annotations.VisibleForTesting;
import com.twitter.common.base.MorePreconditions;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BuildInfo {
    private static final Logger LOG = Logger.getLogger(BuildInfo.class.getName());
    private static final String DEFAULT_BUILD_PROPERTIES_PATH = "build.properties";
    private final String resourcePath;
    private Properties properties = null;

    public BuildInfo() {
        this(DEFAULT_BUILD_PROPERTIES_PATH);
    }

    public BuildInfo(String resourcePath) {
        this.resourcePath = MorePreconditions.checkNotBlank((String)resourcePath);
    }

    @VisibleForTesting
    public BuildInfo(Properties properties) {
        this.resourcePath = null;
        this.properties = properties;
    }

    private void fetchProperties() {
        this.properties = new Properties();
        LOG.info("Fetching build properties from " + this.resourcePath);
        InputStream in = ClassLoader.getSystemResourceAsStream(this.resourcePath);
        if (in == null) {
            LOG.warning("Failed to fetch build properties from " + this.resourcePath);
            return;
        }
        try {
            this.properties.load(in);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to load properties file " + this.resourcePath, e);
        }
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.fetchProperties();
        }
        return this.properties;
    }

    public static enum Key {
        PATH("build.path"),
        USER("build.user.name"),
        MACHINE("build.machine"),
        DATE("build.date"),
        TIME("build.time"),
        TIMESTAMP("build.timestamp"),
        GIT_TAG("build.git.tag"),
        GIT_REVISION("build.git.revision"),
        GIT_REVISION_NUMBER("build.git.revision.number"),
        GIT_BRANCHNAME("build.git.branchname");

        public final String value;

        private Key(String value) {
            this.value = value;
        }
    }
}

