/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.stream;

import com.google.common.base.Stopwatch;
import com.twitter.util.Future;
import com.twitter.util.FutureEventListener;
import com.twitter.util.Promise;
import com.twitter.util.Return;
import com.twitter.util.Try;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.common.util.Sequencer;
import org.apache.distributedlog.exceptions.ChecksumFailedException;
import org.apache.distributedlog.exceptions.DLException;
import org.apache.distributedlog.exceptions.OwnershipAcquireFailedException;
import org.apache.distributedlog.service.ResponseUtils;
import org.apache.distributedlog.service.stream.StreamOp;
import org.apache.distributedlog.thrift.service.ResponseHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public abstract class AbstractStreamOp<Response>
implements StreamOp {
    private static final Logger logger = LoggerFactory.getLogger(AbstractStreamOp.class);
    protected final String stream;
    protected final OpStatsLogger opStatsLogger;
    private final Promise<Response> result = new Promise();
    protected final Stopwatch stopwatch = Stopwatch.createUnstarted();
    protected final Long checksum;
    protected final Feature checksumDisabledFeature;

    public AbstractStreamOp(String stream, OpStatsLogger statsLogger, Long checksum, Feature checksumDisabledFeature) {
        this.stream = stream;
        this.opStatsLogger = statsLogger;
        this.stopwatch.reset().start();
        this.checksum = checksum;
        this.checksumDisabledFeature = checksumDisabledFeature;
    }

    @Override
    public String streamName() {
        return this.stream;
    }

    @Override
    public Stopwatch stopwatch() {
        return this.stopwatch;
    }

    @Override
    public void preExecute() throws DLException {
        Long serverChecksum;
        if (!this.checksumDisabledFeature.isAvailable() && null != this.checksum && null != (serverChecksum = this.computeChecksum()) && !this.checksum.equals(serverChecksum)) {
            throw new ChecksumFailedException();
        }
    }

    @Override
    public Long computeChecksum() {
        return null;
    }

    @Override
    public Future<Void> execute(AsyncLogWriter writer, Sequencer sequencer, Object txnLock) {
        this.stopwatch.reset().start();
        return this.executeOp(writer, sequencer, txnLock).addEventListener(new FutureEventListener<Response>(){

            public void onSuccess(Response response) {
                AbstractStreamOp.this.opStatsLogger.registerSuccessfulEvent(AbstractStreamOp.this.stopwatch.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
                AbstractStreamOp.this.setResponse(response);
            }

            public void onFailure(Throwable cause) {
            }
        }).voided();
    }

    @Override
    public void fail(Throwable cause) {
        if (cause instanceof OwnershipAcquireFailedException) {
            OwnershipAcquireFailedException oafe = (OwnershipAcquireFailedException)cause;
            this.fail(ResponseUtils.ownerToHeader(oafe.getCurrentOwner()));
        } else {
            this.opStatsLogger.registerFailedEvent(this.stopwatch.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
            this.fail(ResponseUtils.exceptionToHeader(cause));
        }
    }

    protected void setResponse(Response response) {
        Return responseTry = new Return(response);
        boolean isEmpty = this.result.updateIfEmpty((Try)responseTry);
        if (!isEmpty) {
            Option resultTry = this.result.poll();
            logger.error("Result set multiple times. Value='{}', New='{}'", (Object)resultTry, (Object)responseTry);
        }
    }

    public Future<Response> result() {
        return this.result;
    }

    protected abstract Future<Response> executeOp(AsyncLogWriter var1, Sequencer var2, Object var3);

    protected abstract void fail(ResponseHeader var1);

    public static OpStatsLogger requestStat(StatsLogger statsLogger, String opName) {
        return AbstractStreamOp.requestLogger(statsLogger).getOpStatsLogger(opName);
    }

    public static StatsLogger requestLogger(StatsLogger statsLogger) {
        return statsLogger.scope("request");
    }

    public static StatsLogger requestScope(StatsLogger statsLogger, String scope) {
        return AbstractStreamOp.requestLogger(statsLogger).scope(scope);
    }
}

