/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.placement;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TMemoryBuffer;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.apache.thrift.transport.TTransport;

public class StreamLoad
implements Comparable {
    private static final int BUFFER_SIZE = 4096;
    public final String stream;
    private final int load;

    public StreamLoad(String stream, int load) {
        this.stream = stream;
        this.load = load;
    }

    public int getLoad() {
        return this.load;
    }

    public String getStream() {
        return this.stream;
    }

    protected org.apache.distributedlog.service.placement.thrift.StreamLoad toThrift() {
        org.apache.distributedlog.service.placement.thrift.StreamLoad tStreamLoad = new org.apache.distributedlog.service.placement.thrift.StreamLoad();
        return tStreamLoad.setStream(this.stream).setLoad(this.load);
    }

    public byte[] serialize() throws IOException {
        TMemoryBuffer transport = new TMemoryBuffer(4096);
        TJSONProtocol protocol = new TJSONProtocol((TTransport)transport);
        try {
            this.toThrift().write((TProtocol)protocol);
            transport.flush();
            return transport.toString(Charsets.UTF_8.name()).getBytes(Charsets.UTF_8);
        }
        catch (TException e) {
            throw new IOException("Failed to serialize stream load : ", e);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IOException("Failed to serialize stream load : ", uee);
        }
    }

    public static StreamLoad deserialize(byte[] data) throws IOException {
        org.apache.distributedlog.service.placement.thrift.StreamLoad tStreamLoad = new org.apache.distributedlog.service.placement.thrift.StreamLoad();
        TMemoryInputTransport transport = new TMemoryInputTransport(data);
        TJSONProtocol protocol = new TJSONProtocol((TTransport)transport);
        try {
            tStreamLoad.read((TProtocol)protocol);
            return new StreamLoad(tStreamLoad.getStream(), tStreamLoad.getLoad());
        }
        catch (TException e) {
            throw new IOException("Failed to deserialize stream load : ", e);
        }
    }

    public int compareTo(Object o) {
        StreamLoad other = (StreamLoad)o;
        if (this.load == other.getLoad()) {
            return this.stream.compareTo(other.getStream());
        }
        return Long.compare(this.load, other.getLoad());
    }

    public boolean equals(Object o) {
        if (!(o instanceof StreamLoad)) {
            return false;
        }
        StreamLoad other = (StreamLoad)o;
        return this.stream.equals(other.getStream()) && this.load == other.getLoad();
    }

    public String toString() {
        return String.format("StreamLoad<Stream: %s, Load: %d>", this.stream, this.load);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.stream).append(this.load).build();
    }
}

