/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.NoSuchElementException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.PendingReadOp;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.util.MathUtils;

class ListenerBasedPendingReadOp
extends PendingReadOp {
    final BookkeeperInternalCallbacks.ReadEntryListener listener;

    ListenerBasedPendingReadOp(LedgerHandle lh, ScheduledExecutorService scheduler, long startEntryId, long endEntryId, BookkeeperInternalCallbacks.ReadEntryListener listener, Object ctx) {
        super(lh, scheduler, startEntryId, endEntryId, null, ctx);
        this.listener = listener;
    }

    @Override
    protected void submitCallback(int code) {
        PendingReadOp.LedgerEntryRequest request;
        while ((request = (PendingReadOp.LedgerEntryRequest)this.seq.peek()) != null) {
            if (!request.isComplete()) {
                return;
            }
            this.seq.remove();
            long latencyNanos = MathUtils.elapsedNanos(this.requestTimeNanos);
            if (0 == request.getRc()) {
                this.readOpLogger.registerSuccessfulEvent(latencyNanos, TimeUnit.NANOSECONDS);
            } else {
                this.readOpLogger.registerFailedEvent(latencyNanos, TimeUnit.NANOSECONDS);
            }
            this.listener.onEntryComplete(request.getRc(), this.lh, request, this.ctx);
        }
        this.cancelSpeculativeTask(true);
    }

    @Override
    public boolean hasMoreElements() {
        return false;
    }

    @Override
    public LedgerEntry nextElement() throws NoSuchElementException {
        throw new NoSuchElementException();
    }
}

