/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.internal.jshell.remote;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.openjdk.tools.internal.jshell.remote.RemoteClassLoader;
import org.openjdk.tools.internal.jshell.remote.RemoteCodes;
import org.openjdk.tools.internal.jshell.remote.RemoteResolutionException;

class RemoteAgent {
    private final RemoteClassLoader loader = new RemoteClassLoader();
    private final Map<String, Class<?>> klasses = new TreeMap();
    private boolean inClientCode;
    private boolean expectingStop;
    private final StopExecutionException stopException = new StopExecutionException();

    RemoteAgent() {
    }

    public static void main(String[] args) throws Exception {
        String loopBack = null;
        Socket socket = new Socket(loopBack, Integer.parseInt(args[0]));
        new RemoteAgent().commandLoop(socket);
    }

    void commandLoop(Socket socket) throws IOException {
        ObjectInputStream in = new ObjectInputStream(socket.getInputStream());
        OutputStream socketOut = socket.getOutputStream();
        System.setOut(new PrintStream(new MultiplexingOutputStream("out", socketOut), true));
        System.setErr(new PrintStream(new MultiplexingOutputStream("err", socketOut), true));
        ObjectOutputStream out = new ObjectOutputStream(new MultiplexingOutputStream("command", socketOut));
        block23: while (true) {
            int cmd = in.readInt();
            switch (cmd) {
                case 0: {
                    return;
                }
                case 1: {
                    try {
                        int count = in.readInt();
                        ArrayList<String> names = new ArrayList<String>(count);
                        for (int i = 0; i < count; ++i) {
                            String name = in.readUTF();
                            byte[] kb = (byte[])in.readObject();
                            this.loader.delare(name, kb);
                            names.add(name);
                        }
                        for (String name : names) {
                            Class<?> klass = this.loader.loadClass(name);
                            this.klasses.put(name, klass);
                            klass.getDeclaredMethods();
                        }
                        out.writeInt(100);
                        out.flush();
                    }
                    catch (IOException | ClassCastException | ClassNotFoundException ex) {
                        this.debug("*** Load failure: %s\n", ex);
                        out.writeInt(101);
                        out.writeUTF(ex.toString());
                        out.flush();
                    }
                    continue block23;
                }
                case 3: {
                    String name = in.readUTF();
                    Class<?> klass = this.klasses.get(name);
                    if (klass == null) {
                        this.debug("*** Invoke failure: no such class loaded %s\n", name);
                        out.writeInt(101);
                        out.writeUTF("no such class loaded: " + name);
                        out.flush();
                        continue block23;
                    }
                    try {
                        Object res;
                        Method doitMethod = klass.getDeclaredMethod("do_it$", new Class[0]);
                        doitMethod.setAccessible(true);
                        try {
                            this.clientCodeEnter();
                            res = doitMethod.invoke(null, new Object[0]);
                        }
                        catch (InvocationTargetException ex) {
                            if (ex.getCause() instanceof StopExecutionException) {
                                this.expectingStop = false;
                                throw (StopExecutionException)ex.getCause();
                            }
                            throw ex;
                        }
                        catch (StopExecutionException ex) {
                            this.expectingStop = false;
                            throw ex;
                        }
                        finally {
                            this.clientCodeLeave();
                        }
                        out.writeInt(100);
                        out.writeUTF(RemoteAgent.valueString(res));
                        out.flush();
                    }
                    catch (InvocationTargetException ex) {
                        Throwable cause = ex.getCause();
                        StackTraceElement[] elems = cause.getStackTrace();
                        if (cause instanceof RemoteResolutionException) {
                            out.writeInt(103);
                            out.writeInt(((RemoteResolutionException)cause).id);
                        } else {
                            out.writeInt(102);
                            out.writeUTF(cause.getClass().getName());
                            out.writeUTF(cause.getMessage() == null ? "<none>" : cause.getMessage());
                        }
                        out.writeInt(elems.length);
                        for (StackTraceElement ste : elems) {
                            out.writeUTF(ste.getClassName());
                            out.writeUTF(ste.getMethodName());
                            out.writeUTF(ste.getFileName() == null ? "<none>" : ste.getFileName());
                            out.writeInt(ste.getLineNumber());
                        }
                        out.flush();
                    }
                    catch (IllegalAccessException | NoSuchMethodException ex) {
                        this.debug("*** Invoke failure: %s -- %s\n", ex, ex.getCause());
                        out.writeInt(101);
                        out.writeUTF(ex.toString());
                        out.flush();
                    }
                    catch (StopExecutionException ex) {
                        try {
                            out.writeInt(104);
                            out.flush();
                        }
                        catch (IOException err) {
                            this.debug("*** Error writing killed result: %s -- %s\n", ex, ex.getCause());
                        }
                    }
                    System.out.flush();
                    continue block23;
                }
                case 5: {
                    String classname = in.readUTF();
                    String varname = in.readUTF();
                    Class<?> klass = this.klasses.get(classname);
                    if (klass == null) {
                        this.debug("*** Var value failure: no such class loaded %s\n", classname);
                        out.writeInt(101);
                        out.writeUTF("no such class loaded: " + classname);
                        out.flush();
                        continue block23;
                    }
                    try {
                        Field var = klass.getDeclaredField(varname);
                        var.setAccessible(true);
                        Object res = var.get(null);
                        out.writeInt(100);
                        out.writeUTF(RemoteAgent.valueString(res));
                        out.flush();
                    }
                    catch (Exception ex) {
                        this.debug("*** Var value failure: no such field %s.%s\n", classname, varname);
                        out.writeInt(101);
                        out.writeUTF("no such field loaded: " + varname + " in class: " + classname);
                        out.flush();
                    }
                    continue block23;
                }
                case 4: {
                    String cp = in.readUTF();
                    for (String path : cp.split(File.pathSeparator)) {
                        this.loader.addURL(new File(path).toURI().toURL());
                    }
                    out.writeInt(100);
                    out.flush();
                    continue block23;
                }
            }
            this.debug("*** Bad command code: %d\n", cmd);
        }
    }

    void clientCodeEnter() {
        this.expectingStop = false;
        this.inClientCode = true;
    }

    void clientCodeLeave() {
        this.inClientCode = false;
        while (this.expectingStop) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException ex) {
                this.debug("*** Sleep interrupted while waiting for stop exception: %s\n", ex);
            }
        }
    }

    private void debug(String format, Object ... args) {
        System.err.printf("REMOTE: " + format, args);
    }

    static String valueString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + RemoteAgent.expunge((String)value) + "\"";
        }
        if (value instanceof Character) {
            return "'" + value + "'";
        }
        return RemoteAgent.expunge(value.toString());
    }

    static String expunge(String s) {
        StringBuilder sb = new StringBuilder();
        for (String comp : RemoteCodes.prefixPattern.split(s)) {
            sb.append(comp);
        }
        return sb.toString();
    }

    private static final class MultiplexingOutputStream
    extends OutputStream {
        private static final int PACKET_SIZE = 127;
        private final byte[] name;
        private final OutputStream delegate;

        public MultiplexingOutputStream(String name, OutputStream delegate) {
            try {
                this.name = name.getBytes("UTF-8");
                this.delegate = delegate;
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            OutputStream outputStream = this.delegate;
            synchronized (outputStream) {
                this.delegate.write(this.name.length);
                this.delegate.write(this.name);
                this.delegate.write(1);
                this.delegate.write(b);
                this.delegate.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            OutputStream outputStream = this.delegate;
            synchronized (outputStream) {
                int i = 0;
                while (len > 0) {
                    int size = Math.min(127, len);
                    this.delegate.write(this.name.length);
                    this.delegate.write(this.name);
                    this.delegate.write(size);
                    this.delegate.write(b, off + i, size);
                    i += size;
                    len -= size;
                }
                this.delegate.flush();
            }
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.delegate.close();
        }
    }

    private class StopExecutionException
    extends ThreadDeath {
        private StopExecutionException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

