/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.benchmark.stream;

import java.util.Enumeration;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerStreamReader
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(LedgerStreamReader.class);
    private final LedgerHandle lh;
    private final long lac;
    private final BookkeeperInternalCallbacks.ReadEntryListener readEntryListener;
    private final int concurrency;
    private final AtomicLong nextReadEntry = new AtomicLong(0L);
    private final CountDownLatch done = new CountDownLatch(1);
    private final ConcurrentLinkedQueue<PendingReadRequest> pendingReads = new ConcurrentLinkedQueue();

    public LedgerStreamReader(LedgerHandle lh, BookkeeperInternalCallbacks.ReadEntryListener readEntryListener, int concurrency) {
        long entryId;
        this.lh = lh;
        this.lac = lh.getLastAddConfirmed();
        this.readEntryListener = readEntryListener;
        this.concurrency = concurrency;
        for (int i = 0; i < concurrency && (entryId = this.nextReadEntry.getAndIncrement()) <= this.lac; ++i) {
            PendingReadRequest request = new PendingReadRequest(entryId);
            this.pendingReads.add(request);
            request.read();
        }
        if (this.pendingReads.isEmpty()) {
            this.done.countDown();
        }
    }

    synchronized void triggerCallbacks() {
        PendingReadRequest request;
        while ((request = this.pendingReads.peek()) != null && request.isDone) {
            this.pendingReads.remove();
            request.complete(this.readEntryListener);
        }
        if (this.pendingReads.isEmpty()) {
            this.done.countDown();
        }
    }

    @Override
    public void run() {
        try {
            this.done.await();
        }
        catch (InterruptedException e) {
            logger.info("Interrupted on stream reading ledger {} : ", (Object)this.lh.getId(), (Object)e);
        }
    }

    class PendingReadRequest
    implements AsyncCallback.ReadCallback {
        final long entryId;
        boolean isDone = false;
        int rc;
        LedgerEntry entry = null;

        PendingReadRequest(long entryId) {
            this.entryId = entryId;
        }

        void read() {
            LedgerStreamReader.this.lh.asyncReadEntries(this.entryId, this.entryId, (AsyncCallback.ReadCallback)this, null);
        }

        void complete(BookkeeperInternalCallbacks.ReadEntryListener listener) {
            listener.onEntryComplete(this.rc, LedgerStreamReader.this.lh, this.entry, null);
        }

        public void readComplete(int rc, LedgerHandle lh, Enumeration<LedgerEntry> enumeration, Object ctx) {
            this.rc = rc;
            this.entry = 0 == rc && enumeration.hasMoreElements() ? enumeration.nextElement() : null;
            this.isDone = true;
            long nextEntry = LedgerStreamReader.this.nextReadEntry.getAndIncrement();
            if (nextEntry <= LedgerStreamReader.this.lac) {
                PendingReadRequest nextRead = new PendingReadRequest(nextEntry);
                LedgerStreamReader.this.pendingReads.add(nextRead);
                nextRead.read();
            }
            LedgerStreamReader.this.triggerCallbacks();
        }
    }
}

