/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.benchmark;

import com.google.common.base.Preconditions;
import com.twitter.finagle.stats.OstrichStatsReceiver;
import com.twitter.finagle.stats.StatsReceiver;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.NullStatsProvider;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.bookkeeper.util.ReflectionUtils;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.benchmark.DLWriterWorker;
import org.apache.distributedlog.benchmark.ReaderWorker;
import org.apache.distributedlog.benchmark.Worker;
import org.apache.distributedlog.benchmark.WriterWorker;
import org.apache.distributedlog.benchmark.utils.ShiftableRateLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Benchmarker {
    private static final Logger logger = LoggerFactory.getLogger(Benchmarker.class);
    static final String USAGE = "Benchmarker [-u <uri>] [-c <conf>] [-s serverset] [-m (read|write|dlwrite)]";
    final String[] args;
    final Options options = new Options();
    int rate = 100;
    int maxRate = 1000;
    int changeRate = 100;
    int changeRateSeconds = 1800;
    int concurrency = 10;
    String streamPrefix = "dlog-loadtest";
    int shardId = -1;
    int numStreams = 10;
    List<String> serversetPaths = new ArrayList<String>();
    List<String> finagleNames = new ArrayList<String>();
    int msgSize = 256;
    String mode = null;
    int durationMins = 60;
    URI dlUri = null;
    int batchSize = 0;
    int readersPerStream = 1;
    Integer maxStreamId = null;
    int truncationInterval = 3600;
    Integer startStreamId = null;
    Integer endStreamId = null;
    int hostConnectionCoreSize = 10;
    int hostConnectionLimit = 10;
    boolean thriftmux = false;
    boolean handshakeWithClientInfo = false;
    boolean readFromHead = false;
    int sendBufferSize = 0x100000;
    int recvBufferSize = 0x100000;
    boolean enableBatching = false;
    int batchBufferSize = 262144;
    int batchFlushIntervalMicros = 2000;
    String routingServiceFinagleNameString;
    final DistributedLogConfiguration conf = new DistributedLogConfiguration();
    final StatsReceiver statsReceiver = new OstrichStatsReceiver();
    StatsProvider statsProvider = null;

    Benchmarker(String[] args) {
        this.args = args;
        this.options.addOption("s", "serverset", true, "Proxy Server Set (separated by ',')");
        this.options.addOption("fn", "finagle-name", true, "Write proxy finagle name (separated by ',')");
        this.options.addOption("c", "conf", true, "DistributedLog Configuration File");
        this.options.addOption("u", "uri", true, "DistributedLog URI");
        this.options.addOption("i", "shard", true, "Shard Id");
        this.options.addOption("p", "provider", true, "DistributedLog Stats Provider");
        this.options.addOption("d", "duration", true, "Duration (minutes)");
        this.options.addOption("sp", "streamprefix", true, "Stream Prefix");
        this.options.addOption("sc", "streamcount", true, "Number of Streams");
        this.options.addOption("ms", "messagesize", true, "Message Size (bytes)");
        this.options.addOption("bs", "batchsize", true, "Batch Size");
        this.options.addOption("r", "rate", true, "Rate limit (requests/second)");
        this.options.addOption("mr", "max-rate", true, "Maximum Rate limit (requests/second)");
        this.options.addOption("cr", "change-rate", true, "Rate to increase each change period (requests/second)");
        this.options.addOption("ci", "change-interval", true, "Rate to increase period, seconds");
        this.options.addOption("t", "concurrency", true, "Concurrency (number of threads)");
        this.options.addOption("m", "mode", true, "Benchmark mode (read/write)");
        this.options.addOption("rps", "readers-per-stream", true, "Number readers per stream");
        this.options.addOption("msid", "max-stream-id", true, "Max Stream ID");
        this.options.addOption("ti", "truncation-interval", true, "Truncation interval in seconds");
        this.options.addOption("ssid", "start-stream-id", true, "Start Stream ID");
        this.options.addOption("esid", "end-stream-id", true, "Start Stream ID");
        this.options.addOption("hccs", "host-connection-core-size", true, "Finagle hostConnectionCoreSize");
        this.options.addOption("hcl", "host-connection-limit", true, "Finagle hostConnectionLimit");
        this.options.addOption("mx", "thriftmux", false, "Enable thriftmux (write mode only)");
        this.options.addOption("hsci", "handshake-with-client-info", false, "Enable handshaking with client info");
        this.options.addOption("rfh", "read-from-head", false, "Read from head of the stream");
        this.options.addOption("sb", "send-buffer", true, "Channel send buffer size, in bytes");
        this.options.addOption("rb", "recv-buffer", true, "Channel recv buffer size, in bytes");
        this.options.addOption("bt", "enable-batch", false, "Enable batching on writers");
        this.options.addOption("bbs", "batch-buffer-size", true, "The batch buffer size in bytes");
        this.options.addOption("bfi", "batch-flush-interval", true, "The batch buffer flush interval in micros");
        this.options.addOption("rs", "routing-service", true, "The routing service finagle name for server-side routing");
        this.options.addOption("h", "help", false, "Print usage.");
    }

    void printUsage() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(USAGE, this.options);
    }

    void run() throws Exception {
        logger.info("Running benchmark.");
        BasicParser parser = new BasicParser();
        CommandLine cmdline = parser.parse(this.options, this.args);
        if (cmdline.hasOption("h")) {
            this.printUsage();
            System.exit(0);
        }
        if (cmdline.hasOption("s")) {
            String serversetPathStr = cmdline.getOptionValue("s");
            this.serversetPaths = Arrays.asList(StringUtils.split((String)serversetPathStr, (char)','));
        }
        if (cmdline.hasOption("fn")) {
            String finagleNameStr = cmdline.getOptionValue("fn");
            this.finagleNames = Arrays.asList(StringUtils.split((String)finagleNameStr, (char)','));
        }
        if (cmdline.hasOption("i")) {
            this.shardId = Integer.parseInt(cmdline.getOptionValue("i"));
        }
        if (cmdline.hasOption("d")) {
            this.durationMins = Integer.parseInt(cmdline.getOptionValue("d"));
        }
        if (cmdline.hasOption("sp")) {
            this.streamPrefix = cmdline.getOptionValue("sp");
        }
        if (cmdline.hasOption("sc")) {
            this.numStreams = Integer.parseInt(cmdline.getOptionValue("sc"));
        }
        if (cmdline.hasOption("ms")) {
            this.msgSize = Integer.parseInt(cmdline.getOptionValue("ms"));
        }
        if (cmdline.hasOption("r")) {
            this.rate = Integer.parseInt(cmdline.getOptionValue("r"));
        }
        if (cmdline.hasOption("mr")) {
            this.maxRate = Integer.parseInt(cmdline.getOptionValue("mr"));
        }
        if (cmdline.hasOption("cr")) {
            this.changeRate = Integer.parseInt(cmdline.getOptionValue("cr"));
        }
        if (cmdline.hasOption("ci")) {
            this.changeRateSeconds = Integer.parseInt(cmdline.getOptionValue("ci"));
        }
        if (cmdline.hasOption("t")) {
            this.concurrency = Integer.parseInt(cmdline.getOptionValue("t"));
        }
        if (cmdline.hasOption("m")) {
            this.mode = cmdline.getOptionValue("m");
        }
        if (cmdline.hasOption("u")) {
            this.dlUri = URI.create(cmdline.getOptionValue("u"));
        }
        if (cmdline.hasOption("bs")) {
            this.batchSize = Integer.parseInt(cmdline.getOptionValue("bs"));
            Preconditions.checkArgument(("write" != this.mode ? 1 : 0) != 0, (Object)"batchSize supported only for mode=write");
        }
        if (cmdline.hasOption("c")) {
            String configFile = cmdline.getOptionValue("c");
            this.conf.loadConf(new File(configFile).toURI().toURL());
        }
        if (cmdline.hasOption("rps")) {
            this.readersPerStream = Integer.parseInt(cmdline.getOptionValue("rps"));
        }
        if (cmdline.hasOption("msid")) {
            this.maxStreamId = Integer.parseInt(cmdline.getOptionValue("msid"));
        }
        if (cmdline.hasOption("ti")) {
            this.truncationInterval = Integer.parseInt(cmdline.getOptionValue("ti"));
        }
        if (cmdline.hasOption("ssid")) {
            this.startStreamId = Integer.parseInt(cmdline.getOptionValue("ssid"));
        }
        if (cmdline.hasOption("esid")) {
            this.endStreamId = Integer.parseInt(cmdline.getOptionValue("esid"));
        }
        if (cmdline.hasOption("hccs")) {
            this.hostConnectionCoreSize = Integer.parseInt(cmdline.getOptionValue("hccs"));
        }
        if (cmdline.hasOption("hcl")) {
            this.hostConnectionLimit = Integer.parseInt(cmdline.getOptionValue("hcl"));
        }
        if (cmdline.hasOption("sb")) {
            this.sendBufferSize = Integer.parseInt(cmdline.getOptionValue("sb"));
        }
        if (cmdline.hasOption("rb")) {
            this.recvBufferSize = Integer.parseInt(cmdline.getOptionValue("rb"));
        }
        if (cmdline.hasOption("rs")) {
            this.routingServiceFinagleNameString = cmdline.getOptionValue("rs");
        }
        this.thriftmux = cmdline.hasOption("mx");
        this.handshakeWithClientInfo = cmdline.hasOption("hsci");
        this.readFromHead = cmdline.hasOption("rfh");
        this.enableBatching = cmdline.hasOption("bt");
        if (cmdline.hasOption("bbs")) {
            this.batchBufferSize = Integer.parseInt(cmdline.getOptionValue("bbs"));
        }
        if (cmdline.hasOption("bfi")) {
            this.batchFlushIntervalMicros = Integer.parseInt(cmdline.getOptionValue("bfi"));
        }
        Preconditions.checkArgument((this.shardId >= 0 ? 1 : 0) != 0, (Object)"shardId must be >= 0");
        Preconditions.checkArgument((this.numStreams > 0 ? 1 : 0) != 0, (Object)"numStreams must be > 0");
        Preconditions.checkArgument((this.durationMins > 0 ? 1 : 0) != 0, (Object)"durationMins must be > 0");
        Preconditions.checkArgument((this.streamPrefix != null ? 1 : 0) != 0, (Object)"streamPrefix must be defined");
        Preconditions.checkArgument((this.hostConnectionCoreSize > 0 ? 1 : 0) != 0, (Object)"host connection core size must be > 0");
        Preconditions.checkArgument((this.hostConnectionLimit > 0 ? 1 : 0) != 0, (Object)"host connection limit must be > 0");
        this.statsProvider = cmdline.hasOption("p") ? (StatsProvider)ReflectionUtils.newInstance((String)cmdline.getOptionValue("p"), StatsProvider.class) : new NullStatsProvider();
        logger.info("Starting stats provider : {}.", this.statsProvider.getClass());
        this.statsProvider.start((Configuration)this.conf);
        Worker w = null;
        if (this.mode.startsWith("read")) {
            w = this.runReader();
        } else if (this.mode.startsWith("write")) {
            w = this.runWriter();
        } else if (this.mode.startsWith("dlwrite")) {
            w = this.runDLWriter();
        } else if (this.mode.startsWith("dlread")) {
            w = this.runDLReader();
        }
        if (w == null) {
            throw new IOException("Unknown mode " + this.mode + " to run the benchmark.");
        }
        Thread workerThread = new Thread((Runnable)w, this.mode + "-benchmark-thread");
        workerThread.start();
        TimeUnit.MINUTES.sleep(this.durationMins);
        logger.info("{} minutes passed, exiting...", (Object)this.durationMins);
        w.close();
        if (null != this.statsProvider) {
            this.statsProvider.stop();
        }
        Runtime.getRuntime().exit(0);
    }

    Worker runWriter() {
        Preconditions.checkArgument((!this.finagleNames.isEmpty() || !this.serversetPaths.isEmpty() || null != this.dlUri ? 1 : 0) != 0, (Object)"either serverset paths, finagle-names or uri required");
        Preconditions.checkArgument((this.msgSize > 0 ? 1 : 0) != 0, (Object)"messagesize must be greater than 0");
        Preconditions.checkArgument((this.rate > 0 ? 1 : 0) != 0, (Object)"rate must be greater than 0");
        Preconditions.checkArgument((this.maxRate >= this.rate ? 1 : 0) != 0, (Object)"max rate must be greater than rate");
        Preconditions.checkArgument((this.changeRate >= 0 ? 1 : 0) != 0, (Object)"change rate must be positive");
        Preconditions.checkArgument((this.changeRateSeconds >= 0 ? 1 : 0) != 0, (Object)"change rate must be positive");
        Preconditions.checkArgument((this.concurrency > 0 ? 1 : 0) != 0, (Object)"concurrency must be greater than 0");
        ShiftableRateLimiter rateLimiter = new ShiftableRateLimiter(this.rate, this.maxRate, this.changeRate, this.changeRateSeconds, TimeUnit.SECONDS);
        return this.createWriteWorker(this.streamPrefix, this.dlUri, null == this.startStreamId ? this.shardId * this.numStreams : this.startStreamId, null == this.endStreamId ? (this.shardId + 1) * this.numStreams : this.endStreamId, rateLimiter, this.concurrency, this.msgSize, this.batchSize, this.hostConnectionCoreSize, this.hostConnectionLimit, this.serversetPaths, this.finagleNames, this.statsReceiver.scope("write_client"), this.statsProvider.getStatsLogger("write"), this.thriftmux, this.handshakeWithClientInfo, this.sendBufferSize, this.recvBufferSize, this.enableBatching, this.batchBufferSize, this.batchFlushIntervalMicros, this.routingServiceFinagleNameString);
    }

    protected WriterWorker createWriteWorker(String streamPrefix, URI uri, int startStreamId, int endStreamId, ShiftableRateLimiter rateLimiter, int writeConcurrency, int messageSizeBytes, int batchSize, int hostConnectionCoreSize, int hostConnectionLimit, List<String> serverSetPaths, List<String> finagleNames, StatsReceiver statsReceiver, StatsLogger statsLogger, boolean thriftmux, boolean handshakeWithClientInfo, int sendBufferSize, int recvBufferSize, boolean enableBatching, int batchBufferSize, int batchFlushIntervalMicros, String routingServiceFinagleNameString) {
        return new WriterWorker(streamPrefix, uri, startStreamId, endStreamId, rateLimiter, writeConcurrency, messageSizeBytes, batchSize, hostConnectionCoreSize, hostConnectionLimit, serverSetPaths, finagleNames, statsReceiver, statsLogger, thriftmux, handshakeWithClientInfo, sendBufferSize, recvBufferSize, enableBatching, batchBufferSize, batchFlushIntervalMicros, routingServiceFinagleNameString);
    }

    Worker runDLWriter() throws IOException {
        Preconditions.checkNotNull((Object)this.dlUri, (Object)"dlUri must be defined");
        Preconditions.checkArgument((this.rate > 0 ? 1 : 0) != 0, (Object)"rate must be greater than 0");
        Preconditions.checkArgument((this.maxRate >= this.rate ? 1 : 0) != 0, (Object)"max rate must be greater than rate");
        Preconditions.checkArgument((this.changeRate >= 0 ? 1 : 0) != 0, (Object)"change rate must be positive");
        Preconditions.checkArgument((this.changeRateSeconds >= 0 ? 1 : 0) != 0, (Object)"change rate must be positive");
        Preconditions.checkArgument((this.concurrency > 0 ? 1 : 0) != 0, (Object)"concurrency must be greater than 0");
        ShiftableRateLimiter rateLimiter = new ShiftableRateLimiter(this.rate, this.maxRate, this.changeRate, this.changeRateSeconds, TimeUnit.SECONDS);
        return new DLWriterWorker(this.conf, this.dlUri, this.streamPrefix, this.shardId * this.numStreams, (this.shardId + 1) * this.numStreams, rateLimiter, this.concurrency, this.msgSize, this.statsProvider.getStatsLogger("dlwrite"));
    }

    Worker runReader() throws IOException {
        Preconditions.checkArgument((!this.finagleNames.isEmpty() || !this.serversetPaths.isEmpty() || null != this.dlUri ? 1 : 0) != 0, (Object)"either serverset paths, finagle-names or dlUri required");
        Preconditions.checkArgument((this.concurrency > 0 ? 1 : 0) != 0, (Object)"concurrency must be greater than 0");
        Preconditions.checkArgument((this.truncationInterval > 0 ? 1 : 0) != 0, (Object)"truncation interval should be greater than 0");
        return this.runReaderInternal(this.serversetPaths, this.finagleNames, this.truncationInterval);
    }

    Worker runDLReader() throws IOException {
        return this.runReaderInternal(new ArrayList<String>(), new ArrayList<String>(), 0);
    }

    private Worker runReaderInternal(List<String> serversetPaths, List<String> finagleNames, int truncationInterval) throws IOException {
        int esid;
        Preconditions.checkNotNull((Object)this.dlUri);
        int ssid = null == this.startStreamId ? this.shardId * this.numStreams : this.startStreamId;
        int n = esid = null == this.endStreamId ? (this.shardId + this.readersPerStream) * this.numStreams : this.endStreamId;
        if (null != this.maxStreamId) {
            esid = Math.min(esid, this.maxStreamId);
        }
        return this.createReaderWorker(this.conf, this.dlUri, this.streamPrefix, ssid, esid, this.concurrency, serversetPaths, finagleNames, truncationInterval, this.readFromHead, this.statsReceiver, this.statsProvider.getStatsLogger("dlreader"));
    }

    protected ReaderWorker createReaderWorker(DistributedLogConfiguration conf, URI uri, String streamPrefix, int startStreamId, int endStreamId, int readThreadPoolSize, List<String> serverSetPaths, List<String> finagleNames, int truncationIntervalInSeconds, boolean readFromHead, StatsReceiver statsReceiver, StatsLogger statsLogger) throws IOException {
        return new ReaderWorker(conf, uri, streamPrefix, startStreamId, endStreamId, readThreadPoolSize, serverSetPaths, finagleNames, truncationIntervalInSeconds, readFromHead, statsReceiver, statsLogger);
    }

    public static void main(String[] args) {
        Benchmarker benchmarker = new Benchmarker(args);
        try {
            benchmarker.run();
        }
        catch (Exception e) {
            logger.info("Benchmark quit due to : ", (Throwable)e);
        }
    }
}

