/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.bookkeeper.stats.CachingStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.commons.configuration.Configuration;

public class CachingStatsProvider
implements StatsProvider {
    protected final StatsProvider underlying;
    protected final ConcurrentMap<String, StatsLogger> statsLoggers;

    public CachingStatsProvider(StatsProvider provider) {
        this.underlying = provider;
        this.statsLoggers = new ConcurrentHashMap<String, StatsLogger>();
    }

    @Override
    public void start(Configuration conf) {
        this.underlying.start(conf);
    }

    @Override
    public void stop() {
        this.underlying.stop();
    }

    @Override
    public StatsLogger getStatsLogger(String scope) {
        StatsLogger statsLogger = (StatsLogger)this.statsLoggers.get(scope);
        if (null == statsLogger) {
            CachingStatsLogger newStatsLogger = new CachingStatsLogger(this.underlying.getStatsLogger(scope));
            StatsLogger oldStatsLogger = this.statsLoggers.putIfAbsent(scope, newStatsLogger);
            statsLogger = null == oldStatsLogger ? newStatsLogger : oldStatsLogger;
        }
        return statsLogger;
    }
}

