/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util.concurrent;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.concurrent.Callable;

final class TaskConverter {
    private TaskConverter() {
    }

    static Runnable alertingRunnable(final Runnable runnable, final Supplier<Thread.UncaughtExceptionHandler> handler) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    ((Thread.UncaughtExceptionHandler)handler.get()).uncaughtException(Thread.currentThread(), t);
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
    }

    static <V> Callable<V> alertingCallable(final Callable<V> callable, final Supplier<Thread.UncaughtExceptionHandler> handler) {
        return new Callable<V>(){

            @Override
            public V call() throws Exception {
                try {
                    return callable.call();
                }
                catch (Throwable t) {
                    ((Thread.UncaughtExceptionHandler)handler.get()).uncaughtException(Thread.currentThread(), t);
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
    }

    static <V> Collection<? extends Callable<V>> alertingCallables(Collection<? extends Callable<V>> callables, final Supplier<Thread.UncaughtExceptionHandler> handler) {
        return Collections2.transform(callables, (Function)new Function<Callable<V>, Callable<V>>(){

            public Callable<V> apply(Callable<V> callable) {
                return TaskConverter.alertingCallable(callable, (Supplier<Thread.UncaughtExceptionHandler>)handler);
            }
        });
    }
}

