/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.processing;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.openjdk.javax.annotation.processing.Filer;
import org.openjdk.javax.annotation.processing.FilerException;
import org.openjdk.javax.lang.model.SourceVersion;
import org.openjdk.javax.lang.model.element.Element;
import org.openjdk.javax.lang.model.element.Modifier;
import org.openjdk.javax.lang.model.element.NestingKind;
import org.openjdk.javax.tools.FileObject;
import org.openjdk.javax.tools.ForwardingFileObject;
import org.openjdk.javax.tools.JavaFileManager;
import org.openjdk.javax.tools.JavaFileObject;
import org.openjdk.javax.tools.StandardLocation;
import org.openjdk.tools.javac.code.Lint;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.Symtab;
import org.openjdk.tools.javac.comp.Modules;
import org.openjdk.tools.javac.main.Option;
import org.openjdk.tools.javac.model.JavacElements;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Names;
import org.openjdk.tools.javac.util.Options;
import org.openjdk.tools.javac.util.Pair;

public class JavacFiler
implements Filer,
Closeable {
    private static final String ALREADY_OPENED = "Output stream or writer has already been opened.";
    private static final String NOT_FOR_READING = "FileObject was not opened for reading.";
    private static final String NOT_FOR_WRITING = "FileObject was not opened for writing.";
    JavaFileManager fileManager;
    JavacElements elementUtils;
    Log log;
    Modules modules;
    Names names;
    Symtab syms;
    Context context;
    boolean lastRound;
    private final boolean lint;
    private final Set<FileObject> initialInputs;
    private final Set<FileObject> fileObjectHistory;
    private final Set<String> openTypeNames;
    private Set<String> generatedSourceNames;
    private final Map<Symbol.ModuleSymbol, Map<String, JavaFileObject>> generatedClasses;
    private Set<JavaFileObject> generatedSourceFileObjects;
    private final Set<Pair<Symbol.ModuleSymbol, String>> aggregateGeneratedSourceNames;
    private final Set<Pair<Symbol.ModuleSymbol, String>> aggregateGeneratedClassNames;
    private final Set<String> initialClassNames;
    private final String defaultTargetModule;

    JavacFiler(Context context) {
        this.context = context;
        this.fileManager = context.get(JavaFileManager.class);
        this.elementUtils = JavacElements.instance(context);
        this.log = Log.instance(context);
        this.modules = Modules.instance(context);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.initialInputs = Collections.synchronizedSet(new LinkedHashSet());
        this.fileObjectHistory = Collections.synchronizedSet(new LinkedHashSet());
        this.generatedSourceNames = Collections.synchronizedSet(new LinkedHashSet());
        this.generatedSourceFileObjects = Collections.synchronizedSet(new LinkedHashSet());
        this.generatedClasses = Collections.synchronizedMap(new LinkedHashMap());
        this.openTypeNames = Collections.synchronizedSet(new LinkedHashSet());
        this.aggregateGeneratedSourceNames = new LinkedHashSet<Pair<Symbol.ModuleSymbol, String>>();
        this.aggregateGeneratedClassNames = new LinkedHashSet<Pair<Symbol.ModuleSymbol, String>>();
        this.initialClassNames = new LinkedHashSet<String>();
        this.lint = Lint.instance(context).isEnabled(Lint.LintCategory.PROCESSING);
        Options options = Options.instance(context);
        this.defaultTargetModule = options.get(Option.DEFAULT_MODULE_FOR_CREATED_FILES);
    }

    @Override
    public JavaFileObject createSourceFile(CharSequence charSequence, Element ... elementArray) throws IOException {
        Pair<Symbol.ModuleSymbol, String> pair = this.checkOrInferModule(charSequence);
        return this.createSourceOrClassFile((Symbol.ModuleSymbol)pair.fst, true, (String)pair.snd);
    }

    @Override
    public JavaFileObject createClassFile(CharSequence charSequence, Element ... elementArray) throws IOException {
        Pair<Symbol.ModuleSymbol, String> pair = this.checkOrInferModule(charSequence);
        return this.createSourceOrClassFile((Symbol.ModuleSymbol)pair.fst, false, (String)pair.snd);
    }

    private Pair<Symbol.ModuleSymbol, String> checkOrInferModule(CharSequence charSequence) throws FilerException {
        String string;
        String string2;
        String string3 = charSequence.toString();
        int n = string3.indexOf(47);
        if (n == -1) {
            int n2 = string3.lastIndexOf(46);
            String string4 = n2 != -1 ? string3.substring(0, n2) : "";
            Symbol.ModuleSymbol moduleSymbol = this.inferModule(string4);
            if (moduleSymbol != null) {
                return Pair.of(moduleSymbol, string3);
            }
            if (this.defaultTargetModule == null) {
                throw new FilerException("Cannot determine target module.");
            }
            string2 = this.defaultTargetModule;
            string = string3;
        } else {
            string2 = string3.substring(0, n);
            string = string3.substring(n + 1);
        }
        Symbol.ModuleSymbol moduleSymbol = this.syms.getModule(this.names.fromString(string2));
        if (moduleSymbol == null) {
            throw new FilerException("Module: " + string2 + " does not exist.");
        }
        if (!this.modules.isRootModule(moduleSymbol)) {
            throw new FilerException("Cannot write to the given module.");
        }
        return Pair.of(moduleSymbol, string);
    }

    private JavaFileObject createSourceOrClassFile(Symbol.ModuleSymbol moduleSymbol, boolean bl, String string) throws IOException {
        JavaFileManager.Location location;
        Object object;
        Object object2;
        int n;
        Assert.checkNonNull(moduleSymbol);
        if (this.lint && (n = string.lastIndexOf(".")) != -1) {
            object2 = string.substring(n);
            Object object3 = object = bl ? ".java" : ".class";
            if (object2.equals(object)) {
                this.log.warning("proc.suspicious.class.name", string, object);
            }
        }
        this.checkNameAndExistence(moduleSymbol, string, bl);
        StandardLocation standardLocation = location = bl ? StandardLocation.SOURCE_OUTPUT : StandardLocation.CLASS_OUTPUT;
        if (this.modules.multiModuleMode) {
            location = this.fileManager.getLocationForModule(location, moduleSymbol.name.toString());
        }
        object2 = bl ? JavaFileObject.Kind.SOURCE : JavaFileObject.Kind.CLASS;
        object = this.fileManager.getJavaFileForOutput(location, string, (JavaFileObject.Kind)((Object)object2), null);
        this.checkFileReopening((FileObject)object, true);
        if (this.lastRound) {
            this.log.warning("proc.file.create.last.round", string);
        }
        if (bl) {
            this.aggregateGeneratedSourceNames.add(Pair.of(moduleSymbol, string));
        } else {
            this.aggregateGeneratedClassNames.add(Pair.of(moduleSymbol, string));
        }
        this.openTypeNames.add(string);
        return new FilerOutputJavaFileObject(moduleSymbol, string, (JavaFileObject)object);
    }

    @Override
    public FileObject createResource(JavaFileManager.Location location, CharSequence charSequence, CharSequence charSequence2, Element ... elementArray) throws IOException {
        Tuple3<JavaFileManager.Location, Symbol.ModuleSymbol, String> tuple3 = this.checkOrInferModule(location, charSequence, true);
        location = (JavaFileManager.Location)tuple3.a;
        Symbol.ModuleSymbol moduleSymbol = (Symbol.ModuleSymbol)tuple3.b;
        String string = (String)tuple3.c;
        this.locationCheck(location);
        String string2 = string.toString();
        if (string2.length() > 0) {
            this.checkName(string2);
        }
        FileObject fileObject = this.fileManager.getFileForOutput(location, string2, charSequence2.toString(), null);
        this.checkFileReopening(fileObject, true);
        if (fileObject instanceof JavaFileObject) {
            return new FilerOutputJavaFileObject(moduleSymbol, null, (JavaFileObject)fileObject);
        }
        return new FilerOutputFileObject(moduleSymbol, null, fileObject);
    }

    private void locationCheck(JavaFileManager.Location location) {
        StandardLocation standardLocation;
        if (location instanceof StandardLocation && !(standardLocation = (StandardLocation)location).isOutputLocation()) {
            throw new IllegalArgumentException("Resource creation not supported in location " + standardLocation);
        }
    }

    @Override
    public FileObject getResource(JavaFileManager.Location location, CharSequence charSequence, CharSequence charSequence2) throws IOException {
        FileObject fileObject;
        Tuple3<JavaFileManager.Location, Symbol.ModuleSymbol, String> tuple3 = this.checkOrInferModule(location, charSequence, false);
        location = (JavaFileManager.Location)tuple3.a;
        String string = (String)tuple3.c;
        if (string.length() > 0) {
            this.checkName(string);
        }
        if ((fileObject = location.isOutputLocation() ? this.fileManager.getFileForOutput(location, string, charSequence2.toString(), null) : this.fileManager.getFileForInput(location, string, charSequence2.toString())) == null) {
            String string2 = string.length() == 0 ? charSequence2.toString() : string + "/" + charSequence2;
            throw new FileNotFoundException(string2);
        }
        this.checkFileReopening(fileObject, false);
        return new FilerInputFileObject(fileObject);
    }

    private Tuple3<JavaFileManager.Location, Symbol.ModuleSymbol, String> checkOrInferModule(JavaFileManager.Location location, CharSequence charSequence, boolean bl) throws IOException {
        String string;
        String string2;
        Symbol.ModuleSymbol moduleSymbol;
        boolean bl2;
        String string3 = charSequence.toString();
        int n = string3.indexOf(47);
        boolean bl3 = bl2 = location.isModuleOrientedLocation() || this.modules.multiModuleMode && location.isOutputLocation();
        if (n == -1) {
            if (!bl2) {
                return new Tuple3<JavaFileManager.Location, Symbol.ModuleSymbol, String>(location, this.modules.getDefaultModule(), string3);
            }
            if (location.isOutputLocation() && (moduleSymbol = this.inferModule(string3)) != null) {
                JavaFileManager.Location location2 = this.fileManager.getLocationForModule(location, moduleSymbol.name.toString());
                return new Tuple3<JavaFileManager.Location, Symbol.ModuleSymbol, String>(location2, moduleSymbol, string3);
            }
            if (this.defaultTargetModule == null) {
                throw new FilerException("No module specified and the location is either a module-oriented location, or a multi-module output location.");
            }
            string2 = this.defaultTargetModule;
            string = string3;
        } else {
            string2 = string3.substring(0, n);
            string = string3.substring(n + 1);
        }
        if (bl2) {
            moduleSymbol = this.syms.getModule(this.names.fromString(string2));
            if (moduleSymbol == null) {
                throw new FilerException("Module: " + string2 + " does not exist.");
            }
            if (bl && !this.modules.isRootModule(moduleSymbol)) {
                throw new FilerException("Cannot write to the given module.");
            }
            JavaFileManager.Location location3 = this.fileManager.getLocationForModule(location, string2);
            return new Tuple3<JavaFileManager.Location, Symbol.ModuleSymbol, String>(location3, moduleSymbol, string);
        }
        throw new FilerException("Module specified but the location is neither a module-oriented location, nor a multi-module output location.");
    }

    private Symbol.ModuleSymbol inferModule(String string) {
        if (this.modules.getDefaultModule() == this.syms.noModule) {
            return this.modules.getDefaultModule();
        }
        Set<Symbol.ModuleSymbol> set = this.modules.getRootModules();
        if (set.size() == 1) {
            return set.iterator().next();
        }
        Symbol.PackageSymbol packageSymbol = this.elementUtils.getPackageElement(string);
        if (packageSymbol != null && packageSymbol.modle != this.syms.unnamedModule) {
            return packageSymbol.modle;
        }
        return null;
    }

    private void checkName(String string) throws FilerException {
        this.checkName(string, false);
    }

    private void checkName(String string, boolean bl) throws FilerException {
        if (!SourceVersion.isName(string) && !this.isPackageInfo(string, bl)) {
            if (this.lint) {
                this.log.warning("proc.illegal.file.name", string);
            }
            throw new FilerException("Illegal name " + string);
        }
    }

    private boolean isPackageInfo(String string, boolean bl) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return bl ? string.equals("package-info") : false;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return SourceVersion.isName(string2) && string3.equals("package-info");
    }

    private void checkNameAndExistence(Symbol.ModuleSymbol moduleSymbol, String string, boolean bl) throws FilerException {
        Symbol.ClassSymbol classSymbol;
        boolean bl2;
        this.checkName(string, bl);
        boolean bl3 = bl2 = this.aggregateGeneratedSourceNames.contains(Pair.of(moduleSymbol, string)) || this.aggregateGeneratedClassNames.contains(Pair.of(moduleSymbol, string)) || this.initialClassNames.contains(string) || (classSymbol = this.elementUtils.getTypeElement(string)) != null && this.initialInputs.contains(classSymbol.sourcefile);
        if (bl2) {
            if (this.lint) {
                this.log.warning("proc.type.recreate", string);
            }
            throw new FilerException("Attempt to recreate a file for type " + string);
        }
        if (!moduleSymbol.isUnnamed() && !string.contains(".")) {
            throw new FilerException("Attempt to create a type in unnamed package of a named module: " + string);
        }
    }

    private void checkFileReopening(FileObject fileObject, boolean bl) throws FilerException {
        if (this.isInFileObjectHistory(fileObject, bl)) {
            if (this.lint) {
                this.log.warning("proc.file.reopening", fileObject.getName());
            }
            throw new FilerException("Attempt to reopen a file for path " + fileObject.getName());
        }
        if (bl) {
            this.fileObjectHistory.add(fileObject);
        }
    }

    private boolean isInFileObjectHistory(FileObject fileObject, boolean bl) {
        if (bl) {
            for (FileObject object : this.initialInputs) {
                try {
                    if (!this.fileManager.isSameFile(object, fileObject)) continue;
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
            for (String string : this.initialClassNames) {
                try {
                    Symbol.ClassSymbol classSymbol = this.elementUtils.getTypeElement(string);
                    if (classSymbol == null || (classSymbol.sourcefile == null || !this.fileManager.isSameFile(classSymbol.sourcefile, fileObject)) && (classSymbol.classfile == null || !this.fileManager.isSameFile(classSymbol.classfile, fileObject))) continue;
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        for (FileObject fileObject2 : this.fileObjectHistory) {
            if (!this.fileManager.isSameFile(fileObject2, fileObject)) continue;
            return true;
        }
        return false;
    }

    public boolean newFiles() {
        return !this.generatedSourceNames.isEmpty() || !this.generatedClasses.isEmpty();
    }

    public Set<String> getGeneratedSourceNames() {
        return this.generatedSourceNames;
    }

    public Set<JavaFileObject> getGeneratedSourceFileObjects() {
        return this.generatedSourceFileObjects;
    }

    public Map<Symbol.ModuleSymbol, Map<String, JavaFileObject>> getGeneratedClasses() {
        return this.generatedClasses;
    }

    public void warnIfUnclosedFiles() {
        if (!this.openTypeNames.isEmpty()) {
            this.log.warning("proc.unclosed.type.files", this.openTypeNames.toString());
        }
    }

    public void newRound() {
        this.clearRoundState();
    }

    void setLastRound(boolean bl) {
        this.lastRound = bl;
    }

    public void setInitialState(Collection<? extends JavaFileObject> collection, Collection<String> collection2) {
        this.initialInputs.addAll(collection);
        this.initialClassNames.addAll(collection2);
    }

    @Override
    public void close() {
        this.clearRoundState();
        this.initialClassNames.clear();
        this.initialInputs.clear();
        this.fileObjectHistory.clear();
        this.openTypeNames.clear();
        this.aggregateGeneratedSourceNames.clear();
        this.aggregateGeneratedClassNames.clear();
    }

    private void clearRoundState() {
        this.generatedSourceNames.clear();
        this.generatedSourceFileObjects.clear();
        this.generatedClasses.clear();
    }

    public void displayState() {
        PrintWriter printWriter = this.context.get(Log.logKey).getWriter(Log.WriterKind.STDERR);
        printWriter.println("File Object History : " + this.fileObjectHistory);
        printWriter.println("Open Type Names     : " + this.openTypeNames);
        printWriter.println("Gen. Src Names      : " + this.generatedSourceNames);
        printWriter.println("Gen. Cls Names      : " + this.generatedClasses.keySet());
        printWriter.println("Agg. Gen. Src Names : " + this.aggregateGeneratedSourceNames);
        printWriter.println("Agg. Gen. Cls Names : " + this.aggregateGeneratedClassNames);
    }

    public String toString() {
        return "javac Filer";
    }

    private void closeFileObject(Symbol.ModuleSymbol moduleSymbol2, String string, FileObject fileObject) {
        if (string != null) {
            if (!(fileObject instanceof JavaFileObject)) {
                throw new AssertionError((Object)("JavaFileOject not found for " + fileObject));
            }
            JavaFileObject javaFileObject = (JavaFileObject)fileObject;
            switch (javaFileObject.getKind()) {
                case SOURCE: {
                    this.generatedSourceNames.add(string);
                    this.generatedSourceFileObjects.add(javaFileObject);
                    this.openTypeNames.remove(string);
                    break;
                }
                case CLASS: {
                    this.generatedClasses.computeIfAbsent(moduleSymbol2, moduleSymbol -> Collections.synchronizedMap(new LinkedHashMap())).put(string, javaFileObject);
                    this.openTypeNames.remove(string);
                    break;
                }
            }
        }
    }

    static final class Tuple3<A, B, C> {
        final A a;
        final B b;
        final C c;

        public Tuple3(A a, B b, C c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }
    }

    private class FilerWriter
    extends FilterWriter {
        Symbol.ModuleSymbol mod;
        String typeName;
        FileObject fileObject;
        boolean closed;

        FilerWriter(Symbol.ModuleSymbol moduleSymbol, String string, FileObject fileObject) throws IOException {
            super(fileObject.openWriter());
            this.closed = false;
            this.mod = moduleSymbol;
            this.typeName = string;
            this.fileObject = fileObject;
        }

        @Override
        public synchronized void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                JavacFiler.this.closeFileObject(this.mod, this.typeName, this.fileObject);
                this.out.close();
            }
        }
    }

    private class FilerOutputStream
    extends FilterOutputStream {
        Symbol.ModuleSymbol mod;
        String typeName;
        FileObject fileObject;
        boolean closed;

        FilerOutputStream(Symbol.ModuleSymbol moduleSymbol, String string, FileObject fileObject) throws IOException {
            super(fileObject.openOutputStream());
            this.closed = false;
            this.mod = moduleSymbol;
            this.typeName = string;
            this.fileObject = fileObject;
        }

        @Override
        public synchronized void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                JavacFiler.this.closeFileObject(this.mod, this.typeName, this.fileObject);
                this.out.close();
            }
        }
    }

    private class FilerInputJavaFileObject
    extends FilerInputFileObject
    implements JavaFileObject {
        private final JavaFileObject javaFileObject;

        FilerInputJavaFileObject(JavaFileObject javaFileObject) {
            super(javaFileObject);
            this.javaFileObject = javaFileObject;
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return this.javaFileObject.getKind();
        }

        @Override
        public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
            return this.javaFileObject.isNameCompatible(string, kind);
        }

        @Override
        public NestingKind getNestingKind() {
            return this.javaFileObject.getNestingKind();
        }

        @Override
        public Modifier getAccessLevel() {
            return this.javaFileObject.getAccessLevel();
        }
    }

    private class FilerInputFileObject
    extends ForwardingFileObject<FileObject> {
        FilerInputFileObject(FileObject fileObject) {
            super(fileObject);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            throw new IllegalStateException(JavacFiler.NOT_FOR_WRITING);
        }

        @Override
        public Writer openWriter() throws IOException {
            throw new IllegalStateException(JavacFiler.NOT_FOR_WRITING);
        }

        @Override
        public boolean delete() {
            return false;
        }
    }

    private class FilerOutputJavaFileObject
    extends FilerOutputFileObject
    implements JavaFileObject {
        private final JavaFileObject javaFileObject;

        FilerOutputJavaFileObject(Symbol.ModuleSymbol moduleSymbol, String string, JavaFileObject javaFileObject) {
            super(moduleSymbol, string, javaFileObject);
            this.javaFileObject = javaFileObject;
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return this.javaFileObject.getKind();
        }

        @Override
        public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
            return this.javaFileObject.isNameCompatible(string, kind);
        }

        @Override
        public NestingKind getNestingKind() {
            return this.javaFileObject.getNestingKind();
        }

        @Override
        public Modifier getAccessLevel() {
            return this.javaFileObject.getAccessLevel();
        }
    }

    private class FilerOutputFileObject
    extends ForwardingFileObject<FileObject> {
        private boolean opened;
        private Symbol.ModuleSymbol mod;
        private String name;

        FilerOutputFileObject(Symbol.ModuleSymbol moduleSymbol, String string, FileObject fileObject) {
            super(fileObject);
            this.opened = false;
            this.mod = moduleSymbol;
            this.name = string;
        }

        @Override
        public synchronized OutputStream openOutputStream() throws IOException {
            if (this.opened) {
                throw new IOException(JavacFiler.ALREADY_OPENED);
            }
            this.opened = true;
            return new FilerOutputStream(this.mod, this.name, this.fileObject);
        }

        @Override
        public synchronized Writer openWriter() throws IOException {
            if (this.opened) {
                throw new IOException(JavacFiler.ALREADY_OPENED);
            }
            this.opened = true;
            return new FilerWriter(this.mod, this.name, this.fileObject);
        }

        @Override
        public InputStream openInputStream() throws IOException {
            throw new IllegalStateException(JavacFiler.NOT_FOR_READING);
        }

        @Override
        public Reader openReader(boolean bl) throws IOException {
            throw new IllegalStateException(JavacFiler.NOT_FOR_READING);
        }

        @Override
        public CharSequence getCharContent(boolean bl) throws IOException {
            throw new IllegalStateException(JavacFiler.NOT_FOR_READING);
        }

        @Override
        public boolean delete() {
            return false;
        }
    }
}

