/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.provider;

import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.cloud.writer.S3ExternalFileWriterFactory;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.external.writer.LocalFSExternalFileWriterFactory;
import org.apache.asterix.external.writer.compressor.GzipExternalFileCompressStreamFactory;
import org.apache.asterix.external.writer.compressor.IExternalFileCompressStreamFactory;
import org.apache.asterix.external.writer.compressor.NoOpExternalFileCompressStreamFactory;
import org.apache.asterix.external.writer.printer.TextualExternalFilePrinterFactory;
import org.apache.asterix.formats.nontagged.CleanJSONPrinterFactoryProvider;
import org.apache.asterix.runtime.writer.ExternalFileWriterConfiguration;
import org.apache.asterix.runtime.writer.IExternalFileFilterWriterFactoryProvider;
import org.apache.asterix.runtime.writer.IExternalFilePrinterFactory;
import org.apache.asterix.runtime.writer.IExternalFileWriterFactory;
import org.apache.hyracks.algebricks.core.algebra.metadata.IWriteDataSink;
import org.apache.hyracks.algebricks.data.IPrinterFactory;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.control.cc.ClusterControllerService;

public class ExternalWriterProvider {
    private static final Map<String, IExternalFileFilterWriterFactoryProvider> CREATOR_MAP = new HashMap<String, IExternalFileFilterWriterFactoryProvider>();
    private static final Map<String, IExternalFileCompressStreamFactory> STREAM_COMPRESSORS;

    private ExternalWriterProvider() {
    }

    public static IExternalFileWriterFactory createWriterFactory(ICcApplicationContext appCtx, IWriteDataSink sink, String staticPath, SourceLocation pathExpressionLocation) {
        String adapterName = sink.getAdapterName().toLowerCase();
        IExternalFileFilterWriterFactoryProvider creator = CREATOR_MAP.get(adapterName);
        if (creator == null) {
            throw new UnsupportedOperationException("Unsupported adapter " + adapterName);
        }
        return creator.create(ExternalWriterProvider.createConfiguration(appCtx, sink, staticPath, pathExpressionLocation));
    }

    public static String getFileExtension(IWriteDataSink sink) {
        Map configuration = sink.getConfiguration();
        String format = ExternalWriterProvider.getFormat(configuration);
        String compression = ExternalWriterProvider.getCompression(configuration);
        return format + (String)(compression.isEmpty() ? "" : "." + compression);
    }

    public static int getMaxResult(IWriteDataSink sink) {
        String maxResultString = (String)sink.getConfiguration().get("max-objects-per-file");
        if (maxResultString == null) {
            return 1000;
        }
        return Integer.parseInt(maxResultString);
    }

    private static ExternalFileWriterConfiguration createConfiguration(ICcApplicationContext appCtx, IWriteDataSink sink, String staticPath, SourceLocation pathExpressionLocation) {
        Map params = sink.getConfiguration();
        boolean singleNodeCluster = ExternalWriterProvider.isSingleNodeCluster(appCtx);
        return new ExternalFileWriterConfiguration(params, pathExpressionLocation, staticPath, singleNodeCluster);
    }

    private static boolean isSingleNodeCluster(ICcApplicationContext appCtx) {
        ClusterControllerService ccs = (ClusterControllerService)appCtx.getServiceContext().getControllerService();
        return ccs.getNodeManager().getIpAddressNodeNameMap().size() == 1;
    }

    private static void addCreator(String adapterName, IExternalFileFilterWriterFactoryProvider creator) {
        IExternalFileFilterWriterFactoryProvider registeredCreator = CREATOR_MAP.get(adapterName.toLowerCase());
        if (registeredCreator != null) {
            throw new IllegalStateException("Adapter " + adapterName + " is registered to " + registeredCreator.getClass().getName());
        }
        CREATOR_MAP.put(adapterName.toLowerCase(), creator);
    }

    public static IExternalFilePrinterFactory createPrinter(IWriteDataSink sink, Object sourceType) {
        Map configuration = sink.getConfiguration();
        String format = (String)configuration.get("format");
        if (!"json".equalsIgnoreCase(format)) {
            throw new UnsupportedOperationException("Unsupported format " + format);
        }
        String compression = ExternalWriterProvider.getCompression(configuration);
        IExternalFileCompressStreamFactory compressStreamFactory = STREAM_COMPRESSORS.getOrDefault(compression, NoOpExternalFileCompressStreamFactory.INSTANCE);
        IPrinterFactory printerFactory = CleanJSONPrinterFactoryProvider.INSTANCE.getPrinterFactory(sourceType);
        return new TextualExternalFilePrinterFactory(printerFactory, compressStreamFactory);
    }

    private static String getFormat(Map<String, String> configuration) {
        return configuration.get("format");
    }

    private static String getCompression(Map<String, String> configuration) {
        return configuration.getOrDefault("compression", "");
    }

    public static char getSeparator(String adapterName) {
        IExternalFileFilterWriterFactoryProvider creator = CREATOR_MAP.get(adapterName.toLowerCase());
        if (creator == null) {
            throw new UnsupportedOperationException("Unsupported adapter " + adapterName);
        }
        return creator.getSeparator();
    }

    static {
        ExternalWriterProvider.addCreator("localfs", LocalFSExternalFileWriterFactory.PROVIDER);
        ExternalWriterProvider.addCreator("S3", S3ExternalFileWriterFactory.PROVIDER);
        STREAM_COMPRESSORS = new HashMap<String, IExternalFileCompressStreamFactory>();
        STREAM_COMPRESSORS.put("gzip", GzipExternalFileCompressStreamFactory.INSTANCE);
    }
}

