/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.win;

import org.apache.hyracks.algebricks.data.IBinaryBooleanInspector;
import org.apache.hyracks.algebricks.data.IBinaryBooleanInspectorFactory;
import org.apache.hyracks.algebricks.runtime.base.IRunningAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.win.AbstractWindowNestedPlansPushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.win.IWindowAggregatorDescriptor;
import org.apache.hyracks.algebricks.runtime.operators.win.WindowAggregatorDescriptorFactory;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PointableTupleReference;
import org.apache.hyracks.storage.common.MultiComparator;

final class WindowNestedPlansRunningPushRuntime
extends AbstractWindowNestedPlansPushRuntime {
    private static final int PARTITION_POSITION_SLOT = 0;
    private static final int FRAME_POSITION_SLOT = 1;
    private static final int TMP_POSITION_SLOT = 2;
    private static final int PARTITION_READER_SLOT_COUNT = 3;
    private final IScalarEvaluatorFactory[] frameValueEvalFactories;
    private IScalarEvaluator[] frameValueEvals;
    private PointableTupleReference frameValuePointables;
    private final IBinaryComparatorFactory[] frameValueComparatorFactories;
    private MultiComparator frameValueComparators;
    private final IScalarEvaluatorFactory[] frameEndEvalFactories;
    private IScalarEvaluator[] frameEndEvals;
    private PointableTupleReference frameEndPointables;
    private final boolean frameEndValidationExists;
    private final IScalarEvaluatorFactory[] frameEndValidationEvalFactories;
    private IScalarEvaluator[] frameEndValidationEvals;
    private PointableTupleReference frameEndValidationPointables;
    private IWindowAggregatorDescriptor nestedAggForInvalidFrame;
    private final int frameMaxObjects;
    private final IBinaryBooleanInspectorFactory booleanAccessorFactory;
    private IBinaryBooleanInspector booleanAccessor;
    private FrameTupleAccessor tAccess2;
    private FrameTupleReference tRef2;
    private int chunkIdxFrameEndGlobal;
    private int tBeginIdxFrameEndGlobal;
    private int toWrite;

    WindowNestedPlansRunningPushRuntime(int[] partitionColumns, IBinaryComparatorFactory[] partitionComparatorFactories, IBinaryComparatorFactory[] orderComparatorFactories, IScalarEvaluatorFactory[] frameValueEvalFactories, IBinaryComparatorFactory[] frameValueComparatorFactories, IScalarEvaluatorFactory[] frameEndEvalFactories, IScalarEvaluatorFactory[] frameEndValidationEvalFactories, int frameMaxObjects, IBinaryBooleanInspectorFactory booleanAccessorFactory, int[] projectionColumns, int[] runningAggOutColumns, IRunningAggregateEvaluatorFactory[] runningAggFactories, int nestedAggOutSchemaSize, WindowAggregatorDescriptorFactory nestedAggFactory, IHyracksTaskContext ctx, int memSizeInFrames, SourceLocation sourceLoc) {
        super(partitionColumns, partitionComparatorFactories, orderComparatorFactories, projectionColumns, runningAggOutColumns, runningAggFactories, nestedAggOutSchemaSize, nestedAggFactory, ctx, memSizeInFrames, sourceLoc);
        this.frameValueEvalFactories = frameValueEvalFactories;
        this.frameValueComparatorFactories = frameValueComparatorFactories;
        this.frameEndEvalFactories = frameEndEvalFactories;
        this.frameEndValidationEvalFactories = frameEndValidationEvalFactories;
        this.frameEndValidationExists = frameEndValidationEvalFactories != null && frameEndValidationEvalFactories.length > 0;
        this.frameMaxObjects = frameMaxObjects;
        this.booleanAccessorFactory = booleanAccessorFactory;
    }

    @Override
    protected void init() throws HyracksDataException {
        super.init();
        this.frameValueEvals = WindowNestedPlansRunningPushRuntime.createEvaluators(this.frameValueEvalFactories, this.ctx);
        this.frameValueComparators = MultiComparator.create((IBinaryComparatorFactory[])this.frameValueComparatorFactories);
        this.frameValuePointables = PointableTupleReference.create((int)this.frameValueEvalFactories.length, (IPointableFactory)VoidPointable.FACTORY);
        this.frameEndEvals = WindowNestedPlansRunningPushRuntime.createEvaluators(this.frameEndEvalFactories, this.ctx);
        this.frameEndPointables = PointableTupleReference.create((int)this.frameEndEvalFactories.length, (IPointableFactory)VoidPointable.FACTORY);
        if (this.frameEndValidationExists) {
            this.frameEndValidationEvals = WindowNestedPlansRunningPushRuntime.createEvaluators(this.frameEndValidationEvalFactories, this.ctx);
            this.frameEndValidationPointables = PointableTupleReference.create((int)this.frameEndValidationEvalFactories.length, (IPointableFactory)VoidPointable.FACTORY);
            this.booleanAccessor = this.booleanAccessorFactory.createBinaryBooleanInspector(this.ctx.getTaskContext());
            this.nestedAggForInvalidFrame = this.nestedAggCreate();
        }
        this.tAccess2 = new FrameTupleAccessor(this.inputRecordDesc);
        this.tRef2 = new FrameTupleReference();
    }

    @Override
    protected void beginPartitionImpl() throws HyracksDataException {
        super.beginPartitionImpl();
        this.nestedAggInit();
        if (this.frameEndValidationExists) {
            WindowNestedPlansRunningPushRuntime.nestedAggInit(this.nestedAggForInvalidFrame);
        }
        this.chunkIdxFrameEndGlobal = 0;
        this.tBeginIdxFrameEndGlobal = -1;
        this.toWrite = this.frameMaxObjects;
    }

    @Override
    protected void producePartitionTuples(int chunkIdx, IFrame chunkFrame) throws HyracksDataException {
        this.partitionReader.savePosition(0);
        int nChunks = this.getPartitionChunkCount();
        boolean isFirstChunkInPartition = chunkIdx == 0;
        boolean isLastChunkInPartition = chunkIdx == nChunks - 1;
        this.tAccess.reset(chunkFrame.getBuffer());
        int tBeginIdx = this.getTupleBeginIdx(chunkIdx);
        int tEndIdx = this.getTupleEndIdx(chunkIdx);
        for (int tIdx = tBeginIdx; tIdx <= tEndIdx; ++tIdx) {
            boolean isFirstTupleInPartition = isFirstChunkInPartition && tIdx == tBeginIdx;
            boolean isLastTupleInPartition = isLastChunkInPartition && tIdx == tEndIdx;
            this.tRef.reset((IFrameTupleAccessor)this.tAccess, tIdx);
            this.produceTuple(this.tupleBuilder, (IFrameTupleAccessor)this.tAccess, tIdx, this.tRef);
            boolean frameEndValid = true;
            if (this.frameEndValidationExists) {
                WindowNestedPlansRunningPushRuntime.evaluate(this.frameEndValidationEvals, (IFrameTupleReference)this.tRef, this.frameEndValidationPointables);
                frameEndValid = WindowNestedPlansRunningPushRuntime.allTrue((ITupleReference)this.frameEndValidationPointables, this.booleanAccessor);
            }
            if (frameEndValid) {
                WindowNestedPlansRunningPushRuntime.evaluate(this.frameEndEvals, (IFrameTupleReference)this.tRef, this.frameEndPointables);
                int chunkIdxInnerStart = this.chunkIdxFrameEndGlobal;
                int tBeginIdxInnerStart = this.tBeginIdxFrameEndGlobal;
                if (chunkIdxInnerStart < nChunks) {
                    if (!isFirstTupleInPartition) {
                        this.partitionReader.restorePosition(1);
                    } else {
                        this.partitionReader.rewind();
                    }
                }
                int chunkIdxFrameEndLocal = -1;
                int tBeginIdxFrameEndLocal = -1;
                block1: for (int chunkIdxInner = chunkIdxInnerStart; chunkIdxInner < nChunks; ++chunkIdxInner) {
                    int tBeginIdxInner;
                    this.partitionReader.savePosition(2);
                    IFrame frameInner = this.partitionReader.nextFrame(false);
                    this.tAccess2.reset(frameInner.getBuffer());
                    if (tBeginIdxInnerStart >= 0) {
                        tBeginIdxInner = tBeginIdxInnerStart;
                        tBeginIdxInnerStart = -1;
                    } else {
                        tBeginIdxInner = this.getTupleBeginIdx(chunkIdxInner);
                    }
                    int tEndIdxInner = this.getTupleEndIdx(chunkIdxInner);
                    for (int tIdxInner = tBeginIdxInner; tIdxInner <= tEndIdxInner && this.toWrite != 0; ++tIdxInner) {
                        this.tRef2.reset((IFrameTupleAccessor)this.tAccess2, tIdxInner);
                        WindowNestedPlansRunningPushRuntime.evaluate(this.frameValueEvals, (IFrameTupleReference)this.tRef2, this.frameValuePointables);
                        if (this.frameValueComparators.compare((ITupleReference)this.frameValuePointables, (ITupleReference)this.frameEndPointables) > 0) {
                            chunkIdxFrameEndLocal = chunkIdxInner;
                            tBeginIdxFrameEndLocal = tIdxInner;
                            this.partitionReader.copyPosition(2, 1);
                            break block1;
                        }
                        this.nestedAggAggregate(this.tAccess2, tIdxInner);
                        if (this.toWrite <= 0) continue;
                        --this.toWrite;
                    }
                }
                if (chunkIdxFrameEndLocal >= 0) {
                    this.chunkIdxFrameEndGlobal = chunkIdxFrameEndLocal;
                    this.tBeginIdxFrameEndGlobal = tBeginIdxFrameEndLocal;
                } else {
                    this.chunkIdxFrameEndGlobal = nChunks;
                    this.tBeginIdxFrameEndGlobal = 0;
                }
                this.nestedAggOutputPartialResult(this.tupleBuilder);
            } else {
                WindowNestedPlansRunningPushRuntime.nestedAggOutputPartialResult(this.nestedAggForInvalidFrame, this.tupleBuilder);
            }
            if (isLastTupleInPartition) {
                this.nestAggDiscardFinalResult();
                if (this.frameEndValidationExists) {
                    WindowNestedPlansRunningPushRuntime.nestAggDiscardFinalResult(this.nestedAggForInvalidFrame);
                }
            }
            this.appendToFrameFromTupleBuilder(this.tupleBuilder);
        }
        this.partitionReader.restorePosition(0);
    }

    @Override
    protected int getPartitionReaderSlotCount() {
        return 3;
    }
}

