/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.transfermanager;

import com.google.api.core.BetaApi;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.transfermanager.TransferStatus;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;

@BetaApi
public final class UploadResult {
    private final @NonNull BlobInfo input;
    private final @NonNull TransferStatus status;
    private final @MonotonicNonNull BlobInfo uploadedBlob;
    private final @MonotonicNonNull Exception exception;

    private UploadResult(@NonNull BlobInfo input, @NonNull TransferStatus status, BlobInfo uploadedBlob, Exception exception) {
        this.input = input;
        this.status = status;
        this.uploadedBlob = uploadedBlob;
        this.exception = exception;
    }

    @BetaApi
    public @NonNull BlobInfo getInput() {
        return this.input;
    }

    @BetaApi
    public @NonNull TransferStatus getStatus() {
        return this.status;
    }

    @BetaApi
    public @NonNull BlobInfo getUploadedBlob() {
        Preconditions.checkState((this.status == TransferStatus.SUCCESS ? 1 : 0) != 0, (String)"getUploadedBlob() only valid when status is SUCCESS but status was %s", (Object)((Object)this.status));
        return this.uploadedBlob;
    }

    @BetaApi
    public @NonNull Exception getException() {
        Preconditions.checkState((this.status == TransferStatus.FAILED_TO_START || this.status == TransferStatus.FAILED_TO_FINISH ? 1 : 0) != 0, (String)"getException() is only valid when an unexpected error has occurred but status was %s", (Object)((Object)this.status));
        return this.exception;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadResult that = (UploadResult)o;
        return this.input.equals(that.input) && this.status == that.status && this.uploadedBlob.equals(that.uploadedBlob) && this.exception.equals(that.exception);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.input, this.status, this.uploadedBlob, this.exception});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("input", (Object)this.input).add("status", (Object)this.status).add("uploadedBlob", (Object)this.uploadedBlob).add("exception", (Object)this.exception).toString();
    }

    @BetaApi
    public static Builder newBuilder(@NonNull BlobInfo input, @NonNull TransferStatus status) {
        return new Builder(input, status);
    }

    @BetaApi
    public static final class Builder {
        private @NonNull BlobInfo input;
        private @NonNull TransferStatus status;
        private @MonotonicNonNull BlobInfo uploadedBlob;
        private @MonotonicNonNull Exception exception;

        private Builder(@NonNull BlobInfo input, @NonNull TransferStatus status) {
            this.input = input;
            this.status = status;
        }

        @BetaApi
        public Builder setInput(@NonNull BlobInfo input) {
            this.input = input;
            return this;
        }

        @BetaApi
        public Builder setStatus(@NonNull TransferStatus status) {
            this.status = status;
            return this;
        }

        @BetaApi
        public Builder setUploadedBlob(@NonNull BlobInfo uploadedBlob) {
            this.uploadedBlob = uploadedBlob;
            return this;
        }

        @BetaApi
        public Builder setException(@NonNull Exception exception) {
            this.exception = exception;
            return this;
        }

        @BetaApi
        public UploadResult build() {
            Preconditions.checkNotNull((Object)this.input);
            Preconditions.checkNotNull((Object)((Object)this.status));
            if (this.status == TransferStatus.SUCCESS) {
                Preconditions.checkNotNull((Object)this.uploadedBlob);
            } else if (this.status == TransferStatus.FAILED_TO_START || this.status == TransferStatus.FAILED_TO_FINISH) {
                Preconditions.checkNotNull((Object)this.exception);
            }
            return new UploadResult(this.input, this.status, this.uploadedBlob, this.exception);
        }
    }
}

