/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util.aws.s3;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.external.IExternalFilterEvaluator;
import org.apache.asterix.external.input.record.reader.abstracts.AbstractExternalInputStreamFactory;
import org.apache.asterix.external.util.ExternalDataPrefix;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.HDFSUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.api.util.ExceptionUtils;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.InstanceProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.model.S3Response;

public class S3Utils {
    private S3Utils() {
        throw new AssertionError((Object)"do not instantiate");
    }

    public static boolean isRetryableError(String errorCode) {
        return errorCode.equals("InternalError") || errorCode.equals("SlowDown");
    }

    public static S3Client buildAwsS3Client(Map<String, String> configuration) throws CompilationException {
        AnonymousCredentialsProvider credentialsProvider;
        String instanceProfile = configuration.get("instanceProfile");
        String accessKeyId = configuration.get("accessKeyId");
        String secretAccessKey = configuration.get("secretAccessKey");
        String sessionToken = configuration.get("sessionToken");
        String regionId = configuration.get("region");
        String serviceEndpoint = configuration.get("serviceEndpoint");
        S3ClientBuilder builder = S3Client.builder();
        if (instanceProfile == null && accessKeyId == null && secretAccessKey == null && sessionToken == null) {
            credentialsProvider = AnonymousCredentialsProvider.create();
        } else if (instanceProfile != null) {
            if (!instanceProfile.equalsIgnoreCase("true")) {
                throw new CompilationException(ErrorCode.INVALID_PARAM_VALUE_ALLOWED_VALUE, new Serializable[]{"instanceProfile", "true"});
            }
            if (accessKeyId != null) {
                throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{"accessKeyId", "instanceProfile"});
            }
            if (secretAccessKey != null) {
                throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{"secretAccessKey", "instanceProfile"});
            }
            if (sessionToken != null) {
                throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{"sessionToken", "instanceProfile"});
            }
            credentialsProvider = InstanceProfileCredentialsProvider.create();
        } else if (accessKeyId != null || secretAccessKey != null) {
            if (accessKeyId == null) {
                throw new CompilationException(ErrorCode.REQUIRED_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"accessKeyId", "secretAccessKey"});
            }
            if (secretAccessKey == null) {
                throw new CompilationException(ErrorCode.REQUIRED_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"secretAccessKey", "accessKeyId"});
            }
            credentialsProvider = sessionToken != null ? StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)accessKeyId, (String)secretAccessKey, (String)sessionToken)) : StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKeyId, (String)secretAccessKey));
        } else {
            throw new CompilationException(ErrorCode.REQUIRED_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"accessKeyId", "sessionToken"});
        }
        builder.credentialsProvider((AwsCredentialsProvider)credentialsProvider);
        List regions = S3Client.serviceMetadata().regions();
        Optional<Region> selectedRegion = regions.stream().filter(region -> region.id().equals(regionId)).findFirst();
        if (selectedRegion.isEmpty()) {
            throw new CompilationException(ErrorCode.S3_REGION_NOT_SUPPORTED, new Serializable[]{regionId});
        }
        builder.region(selectedRegion.get());
        if (serviceEndpoint != null) {
            try {
                URI uri = new URI(serviceEndpoint);
                try {
                    builder.endpointOverride(uri);
                }
                catch (NullPointerException ex) {
                    throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, (Throwable)ex, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
                }
            }
            catch (URISyntaxException ex) {
                throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, (Throwable)ex, new Serializable[]{String.format("Invalid service endpoint %s", serviceEndpoint)});
            }
        }
        return (S3Client)builder.build();
    }

    public static void configureAwsS3HdfsJobConf(JobConf conf, Map<String, String> configuration, int numberOfPartitions) {
        String accessKeyId = configuration.get("accessKeyId");
        String secretAccessKey = configuration.get("secretAccessKey");
        String sessionToken = configuration.get("sessionToken");
        String serviceEndpoint = configuration.get("serviceEndpoint");
        HDFSUtils.disableHadoopFileSystemCache((Configuration)conf, "s3a");
        if (accessKeyId == null) {
            conf.set("fs.s3a.aws.credentials.provider", "org.apache.hadoop.fs.s3a.AnonymousAWSCredentialsProvider");
        } else {
            conf.set("fs.s3a.access.key", accessKeyId);
            conf.set("fs.s3a.secret.key", secretAccessKey);
            if (sessionToken != null) {
                conf.set("fs.s3a.session.token", sessionToken);
                conf.set("fs.s3a.aws.credentials.provider", "org.apache.hadoop.fs.s3a.TemporaryAWSCredentialsProvider");
            }
        }
        conf.set("fs.s3a.path.style.access", "true");
        conf.set("fs.s3a.connection.maximum", String.valueOf(numberOfPartitions));
        if (serviceEndpoint != null) {
            conf.set("fs.s3a.endpoint", serviceEndpoint);
        } else {
            conf.set("fs.s3a.endpoint", "s3.amazonaws.com");
        }
    }

    public static void validateProperties(Map<String, String> configuration, SourceLocation srcLoc, IWarningCollector collector) throws CompilationException {
        boolean isEmpty;
        S3Response response;
        String container;
        boolean useOldApi;
        block19: {
            if (configuration.get("format") == null) {
                throw new CompilationException(ErrorCode.PARAMETERS_REQUIRED, srcLoc, new Serializable[]{"format"});
            }
            String accessKeyId = configuration.get("accessKeyId");
            String secretAccessKey = configuration.get("secretAccessKey");
            if (accessKeyId == null || secretAccessKey == null) {
                if (accessKeyId != null) {
                    throw new CompilationException(ErrorCode.REQUIRED_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"secretAccessKey", "accessKeyId"});
                }
                if (secretAccessKey != null) {
                    throw new CompilationException(ErrorCode.REQUIRED_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"accessKeyId", "secretAccessKey"});
                }
            }
            ExternalDataUtils.validateIncludeExclude(configuration);
            try {
                new ExternalDataPrefix(configuration);
            }
            catch (AlgebricksException ex) {
                throw new CompilationException(ErrorCode.FAILED_TO_CALCULATE_COMPUTED_FIELDS, (Throwable)ex, new Serializable[0]);
            }
            S3Client s3Client = S3Utils.buildAwsS3Client(configuration);
            useOldApi = false;
            container = configuration.get("container");
            String prefix = ExternalDataUtils.getPrefix(configuration);
            try {
                response = S3Utils.isBucketEmpty(s3Client, container, prefix, false);
            }
            catch (S3Exception ex) {
                try {
                    if (ex.awsErrorDetails().errorCode().equals("NotImplemented")) {
                        useOldApi = true;
                        response = S3Utils.isBucketEmpty(s3Client, container, prefix, true);
                        break block19;
                    }
                    throw ex;
                }
                catch (SdkException ex2) {
                    throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, (Throwable)ex2, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
                }
            }
            catch (SdkException ex) {
                throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, (Throwable)ex, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
            }
            finally {
                if (s3Client != null) {
                    CleanupUtils.close((AutoCloseable)s3Client, null);
                }
            }
        }
        boolean bl = isEmpty = useOldApi ? ((ListObjectsResponse)response).contents().isEmpty() : ((ListObjectsV2Response)response).contents().isEmpty();
        if (isEmpty && collector.shouldWarn()) {
            Warning warning = Warning.of((SourceLocation)srcLoc, (IError)ErrorCode.EXTERNAL_SOURCE_CONFIGURATION_RETURNED_NO_FILES, (Serializable[])new Serializable[0]);
            collector.warn(warning);
        }
        if (!response.sdkHttpResponse().isSuccessful()) {
            throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_CONTAINER_NOT_FOUND, new Serializable[]{container});
        }
    }

    private static S3Response isBucketEmpty(S3Client s3Client, String container, String prefix, boolean useOldApi) {
        ListObjectsResponse response;
        if (useOldApi) {
            ListObjectsRequest.Builder listObjectsBuilder = ListObjectsRequest.builder();
            listObjectsBuilder.prefix(prefix);
            response = s3Client.listObjects((ListObjectsRequest)listObjectsBuilder.bucket(container).maxKeys(Integer.valueOf(1)).build());
        } else {
            ListObjectsV2Request.Builder listObjectsBuilder = ListObjectsV2Request.builder();
            listObjectsBuilder.prefix(prefix);
            response = s3Client.listObjectsV2((ListObjectsV2Request)listObjectsBuilder.bucket(container).maxKeys(Integer.valueOf(1)).build());
        }
        return response;
    }

    public static List<S3Object> listS3Objects(Map<String, String> configuration, AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher, IWarningCollector warningCollector, ExternalDataPrefix externalDataPrefix, IExternalFilterEvaluator evaluator) throws CompilationException, HyracksDataException {
        List<S3Object> filesOnly;
        block12: {
            String container = configuration.get("container");
            S3Client s3Client = S3Utils.buildAwsS3Client(configuration);
            String prefix = ExternalDataUtils.getPrefix(configuration);
            try {
                filesOnly = S3Utils.listS3Objects(s3Client, container, prefix, includeExcludeMatcher, externalDataPrefix, evaluator, warningCollector);
            }
            catch (S3Exception ex) {
                try {
                    if (ex.awsErrorDetails().errorCode().equals("NotImplemented")) {
                        filesOnly = S3Utils.oldApiListS3Objects(s3Client, container, prefix, includeExcludeMatcher, externalDataPrefix, evaluator, warningCollector);
                        break block12;
                    }
                    throw ex;
                }
                catch (SdkException ex2) {
                    throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, (Throwable)ex2, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
                }
            }
            catch (SdkException ex) {
                throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, (Throwable)ex, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
            }
            finally {
                if (s3Client != null) {
                    CleanupUtils.close((AutoCloseable)s3Client, null);
                }
            }
        }
        if (filesOnly.isEmpty() && warningCollector.shouldWarn()) {
            Warning warning = Warning.of(null, (IError)ErrorCode.EXTERNAL_SOURCE_CONFIGURATION_RETURNED_NO_FILES, (Serializable[])new Serializable[0]);
            warningCollector.warn(warning);
        }
        return filesOnly;
    }

    private static List<S3Object> listS3Objects(S3Client s3Client, String container, String prefix, AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher, ExternalDataPrefix externalDataPrefix, IExternalFilterEvaluator evaluator, IWarningCollector warningCollector) throws HyracksDataException {
        String newMarker = null;
        ArrayList<S3Object> filesOnly = new ArrayList<S3Object>();
        ListObjectsV2Request.Builder listObjectsBuilder = ListObjectsV2Request.builder().bucket(container);
        listObjectsBuilder.prefix(prefix);
        while (true) {
            ListObjectsV2Response listObjectsResponse = newMarker == null ? s3Client.listObjectsV2((ListObjectsV2Request)listObjectsBuilder.build()) : s3Client.listObjectsV2((ListObjectsV2Request)listObjectsBuilder.continuationToken(newMarker).build());
            S3Utils.collectAndFilterFiles(listObjectsResponse.contents(), includeExcludeMatcher.getPredicate(), includeExcludeMatcher.getMatchersList(), filesOnly, externalDataPrefix, evaluator, warningCollector);
            if (listObjectsResponse.isTruncated() == null || !listObjectsResponse.isTruncated().booleanValue()) break;
            newMarker = listObjectsResponse.nextContinuationToken();
        }
        return filesOnly;
    }

    private static List<S3Object> oldApiListS3Objects(S3Client s3Client, String container, String prefix, AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher, ExternalDataPrefix externalDataPrefix, IExternalFilterEvaluator evaluator, IWarningCollector warningCollector) throws HyracksDataException {
        String newMarker = null;
        ArrayList<S3Object> filesOnly = new ArrayList<S3Object>();
        ListObjectsRequest.Builder listObjectsBuilder = ListObjectsRequest.builder().bucket(container);
        listObjectsBuilder.prefix(prefix);
        while (true) {
            ListObjectsResponse listObjectsResponse = newMarker == null ? s3Client.listObjects((ListObjectsRequest)listObjectsBuilder.build()) : s3Client.listObjects((ListObjectsRequest)listObjectsBuilder.marker(newMarker).build());
            S3Utils.collectAndFilterFiles(listObjectsResponse.contents(), includeExcludeMatcher.getPredicate(), includeExcludeMatcher.getMatchersList(), filesOnly, externalDataPrefix, evaluator, warningCollector);
            if (listObjectsResponse.isTruncated() == null || !listObjectsResponse.isTruncated().booleanValue()) break;
            newMarker = listObjectsResponse.nextMarker();
        }
        return filesOnly;
    }

    private static void collectAndFilterFiles(List<S3Object> s3Objects, BiPredicate<List<Matcher>, String> predicate, List<Matcher> matchers, List<S3Object> filesOnly, ExternalDataPrefix externalDataPrefix, IExternalFilterEvaluator evaluator, IWarningCollector warningCollector) throws HyracksDataException {
        for (S3Object object : s3Objects) {
            if (!ExternalDataUtils.evaluate(object.key(), predicate, matchers, externalDataPrefix, evaluator, warningCollector)) continue;
            filesOnly.add(object);
        }
    }
}

