/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.work.GetThreadDumpWork;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NotifyThreadDumpResponse
extends AbstractWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ClusterControllerService ccs;
    private final String requestId;
    private final String threadDumpJSON;

    public NotifyThreadDumpResponse(ClusterControllerService ccs, String requestId, String threadDumpJSON) {
        this.ccs = ccs;
        this.requestId = requestId;
        this.threadDumpJSON = threadDumpJSON;
    }

    public void run() {
        LOGGER.debug("Delivering thread dump response: " + this.requestId);
        GetThreadDumpWork.ThreadDumpRun threadDumpRun = this.ccs.removeThreadDumpRun(this.requestId);
        if (threadDumpRun == null) {
            LOGGER.warn("Thread dump run " + this.requestId + " not found; discarding reply: " + this.threadDumpJSON);
        } else {
            threadDumpRun.notifyThreadDumpReceived(this.threadDumpJSON);
        }
    }
}

