/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public abstract class LazyNonPrimitive<OI extends ObjectInspector>
extends LazyObject<OI> {
    protected ByteArrayRef bytes = null;
    protected int start = 0;
    protected int length = 0;

    protected LazyNonPrimitive(OI oi) {
        super(oi);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        if (bytes == null) {
            throw new RuntimeException("bytes cannot be null!");
        }
        this.bytes = bytes;
        this.start = start;
        this.length = length;
        assert (start >= 0);
        assert (start + length <= bytes.getData().length);
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public int hashCode() {
        return LazyUtils.hashBytes(this.bytes.getData(), this.start, this.length);
    }
}

