/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class FunctionDecl
extends AbstractStatement {
    private final FunctionSignature signature;
    private final List<VarIdentifier> paramList;
    private Expression funcBody;
    private Expression funcBodyNormalized;
    private final boolean isStored;

    public FunctionDecl(FunctionSignature signature, List<VarIdentifier> paramList, Expression funcBody, boolean isStored) {
        this.signature = signature;
        this.paramList = paramList;
        this.funcBody = funcBody;
        this.isStored = isStored;
    }

    public FunctionSignature getSignature() {
        return this.signature;
    }

    public List<VarIdentifier> getParamList() {
        return this.paramList;
    }

    public Expression getFuncBody() {
        return this.funcBody;
    }

    public void setFuncBody(Expression funcBody) {
        this.funcBody = funcBody;
        this.funcBodyNormalized = null;
    }

    public Expression getNormalizedFuncBody() {
        return this.funcBodyNormalized;
    }

    public void setNormalizedFuncBody(Expression funcBody) {
        this.funcBodyNormalized = funcBody;
    }

    public boolean isStored() {
        return this.isStored;
    }

    public int hashCode() {
        return this.signature.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof FunctionDecl && ((FunctionDecl)o).getSignature().equals((Object)this.signature);
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.FUNCTION_DECL;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    @Override
    public byte getCategory() {
        return 1;
    }
}

