/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import io.netty.handler.codec.http.HttpMethod;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.asterix.api.http.server.QueryServiceServlet;
import org.apache.asterix.common.api.Duration;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.SessionConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.hyracks.util.JSONUtil;

public class QueryServiceRequestParameters {
    private static final Map<String, SessionConfig.PlanFormat> planFormats = ImmutableMap.of((Object)"json", (Object)SessionConfig.PlanFormat.JSON, (Object)"clean_json", (Object)SessionConfig.PlanFormat.JSON, (Object)"string", (Object)SessionConfig.PlanFormat.STRING);
    private static final Map<String, Boolean> booleanValues = ImmutableMap.of((Object)Boolean.TRUE.toString(), (Object)Boolean.TRUE, (Object)Boolean.FALSE.toString(), (Object)Boolean.FALSE);
    private static final Map<String, Boolean> csvHeaderValues = ImmutableMap.of((Object)"present", (Object)Boolean.TRUE, (Object)"absent", (Object)Boolean.FALSE);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private String host;
    private String path;
    private String statement;
    private String clientContextID;
    private SessionConfig.OutputFormat format = SessionConfig.OutputFormat.CLEAN_JSON;
    private IStatementExecutor.ResultDelivery mode = IStatementExecutor.ResultDelivery.IMMEDIATE;
    private SessionConfig.PlanFormat planFormat = SessionConfig.PlanFormat.JSON;
    private IStatementExecutor.Stats.ProfileType profileType = IStatementExecutor.Stats.ProfileType.COUNTS;
    private Map<String, String> optionalParams = null;
    private Map<String, JsonNode> statementParams = null;
    private boolean pretty = false;
    private boolean expressionTree = false;
    private boolean parseOnly = false;
    private boolean readOnly = false;
    private boolean rewrittenExpressionTree = false;
    private boolean logicalPlan = false;
    private boolean optimizedLogicalPlan = false;
    private boolean job = false;
    private boolean isCSVWithHeader = false;
    private boolean signature = true;
    private boolean multiStatement = true;
    private long timeout = TimeUnit.MILLISECONDS.toMillis(Long.MAX_VALUE);
    private long maxResultReads = 1L;
    private long maxWarnings = 0L;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String statement) {
        this.statement = statement;
    }

    public SessionConfig.OutputFormat getFormat() {
        return this.format;
    }

    public void setFormat(Pair<SessionConfig.OutputFormat, Boolean> formatAndHeader) {
        Objects.requireNonNull(formatAndHeader);
        Objects.requireNonNull((SessionConfig.OutputFormat)formatAndHeader.getLeft());
        this.format = (SessionConfig.OutputFormat)formatAndHeader.getLeft();
        if (this.format == SessionConfig.OutputFormat.CSV) {
            this.isCSVWithHeader = (Boolean)formatAndHeader.getRight();
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    public String getClientContextID() {
        return this.clientContextID;
    }

    public void setClientContextID(String clientContextID) {
        this.clientContextID = clientContextID;
    }

    public IStatementExecutor.ResultDelivery getMode() {
        return this.mode;
    }

    public void setMode(IStatementExecutor.ResultDelivery mode) {
        Objects.requireNonNull(mode);
        this.mode = mode;
    }

    public long getMaxResultReads() {
        return this.maxResultReads;
    }

    public void setMaxResultReads(long maxResultReads) {
        this.maxResultReads = maxResultReads;
    }

    public SessionConfig.PlanFormat getPlanFormat() {
        return this.planFormat;
    }

    public void setPlanFormat(SessionConfig.PlanFormat planFormat) {
        Objects.requireNonNull(planFormat);
        this.planFormat = planFormat;
    }

    public Map<String, String> getOptionalParams() {
        return this.optionalParams;
    }

    public void setOptionalParams(Map<String, String> optionalParams) {
        this.optionalParams = optionalParams;
    }

    public Map<String, JsonNode> getStatementParams() {
        return this.statementParams;
    }

    public void setStatementParams(Map<String, JsonNode> statementParams) {
        this.statementParams = statementParams;
    }

    public boolean isExpressionTree() {
        return this.expressionTree;
    }

    public void setExpressionTree(boolean expressionTree) {
        this.expressionTree = expressionTree;
    }

    public boolean isRewrittenExpressionTree() {
        return this.rewrittenExpressionTree;
    }

    public void setRewrittenExpressionTree(boolean rewrittenExpressionTree) {
        this.rewrittenExpressionTree = rewrittenExpressionTree;
    }

    public boolean isLogicalPlan() {
        return this.logicalPlan;
    }

    public void setLogicalPlan(boolean logicalPlan) {
        this.logicalPlan = logicalPlan;
    }

    public boolean isOptimizedLogicalPlan() {
        return this.optimizedLogicalPlan;
    }

    public void setOptimizedLogicalPlan(boolean optimizedLogicalPlan) {
        this.optimizedLogicalPlan = optimizedLogicalPlan;
    }

    public void setParseOnly(boolean parseOnly) {
        this.parseOnly = parseOnly;
    }

    public boolean isParseOnly() {
        return this.parseOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isJob() {
        return this.job;
    }

    public void setJob(boolean job) {
        this.job = job;
    }

    public void setProfileType(IStatementExecutor.Stats.ProfileType profileType) {
        Objects.requireNonNull(profileType);
        this.profileType = profileType;
    }

    public IStatementExecutor.Stats.ProfileType getProfileType() {
        return this.profileType;
    }

    public boolean isCSVWithHeader() {
        return this.format == SessionConfig.OutputFormat.CSV && this.isCSVWithHeader;
    }

    public boolean isSignature() {
        return this.signature;
    }

    public void setSignature(boolean signature) {
        this.signature = signature;
    }

    public boolean isMultiStatement() {
        return this.multiStatement;
    }

    public void setMultiStatement(boolean multiStatement) {
        this.multiStatement = multiStatement;
    }

    public void setMaxWarnings(long maxWarnings) {
        this.maxWarnings = maxWarnings;
    }

    public long getMaxWarnings() {
        return this.maxWarnings;
    }

    public ObjectNode asJson() {
        ObjectNode object = OBJECT_MAPPER.createObjectNode();
        object.put("host", this.host);
        object.put("path", this.path);
        object.put("statement", this.statement != null ? JSONUtil.escape((StringBuilder)new StringBuilder(), (String)this.statement).toString() : null);
        object.put("pretty", this.pretty);
        object.put("mode", this.mode.getName());
        object.put("clientContextID", this.clientContextID);
        object.put("format", this.format.toString());
        object.put("timeout", this.timeout);
        object.put("maxResultReads", this.maxResultReads);
        object.put("planFormat", this.planFormat.toString());
        object.put("expressionTree", this.expressionTree);
        object.put("rewrittenExpressionTree", this.rewrittenExpressionTree);
        object.put("logicalPlan", this.logicalPlan);
        object.put("optimizedLogicalPlan", this.optimizedLogicalPlan);
        object.put("job", this.job);
        object.put("profile", this.profileType.getName());
        object.put("signature", this.signature);
        object.put("multiStatement", this.multiStatement);
        object.put("parseOnly", this.parseOnly);
        object.put("readOnly", this.readOnly);
        object.put("maxWarnings", this.maxWarnings);
        if (this.statementParams != null) {
            for (Map.Entry<String, JsonNode> statementParam : this.statementParams.entrySet()) {
                object.set("$" + statementParam.getKey(), statementParam.getValue());
            }
        }
        return object;
    }

    public String toString() {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)this.asJson());
        }
        catch (JsonProcessingException e) {
            QueryServiceServlet.LOGGER.debug("unexpected exception marshalling {} instance to json", this.getClass(), (Object)e);
            return e.toString();
        }
    }

    public void setParameters(QueryServiceServlet servlet, IServletRequest request, Map<String, String> optionalParams) throws IOException {
        this.setHost(servlet.host(request));
        this.setPath(servlet.servletPath(request));
        this.setOptionalParams(optionalParams);
        try {
            if (this.useRequestParameters(request)) {
                this.setFromRequestParameters(request);
            } else {
                this.setFromRequestBody(request);
            }
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new RuntimeDataException(ErrorCode.INVALID_REQ_JSON_VAL, new Serializable[0]);
        }
    }

    private boolean useRequestParameters(IServletRequest request) {
        String contentType = HttpUtil.getContentTypeOnly((IServletRequest)request);
        HttpMethod method = request.getHttpRequest().method();
        return HttpMethod.GET.equals((Object)method) || !"application/json".equals(contentType);
    }

    private void setFromRequestBody(IServletRequest request) throws IOException {
        JsonNode jsonRequest = OBJECT_MAPPER.readTree(HttpUtil.getRequestBody((IServletRequest)request));
        this.setParams(jsonRequest, request.getHeader((CharSequence)"Accept"), QueryServiceRequestParameters::getParameter);
        this.setStatementParams(this.getOptStatementParameters(jsonRequest, jsonRequest.fieldNames(), JsonNode::get, v -> v));
        this.setExtraParams(jsonRequest);
    }

    private void setFromRequestParameters(IServletRequest request) throws IOException {
        this.setParams(request, request.getHeader((CharSequence)"Accept"), IServletRequest::getParameter);
        this.setStatementParams(this.getOptStatementParameters(request, request.getParameterNames().iterator(), IServletRequest::getParameter, arg_0 -> ((ObjectMapper)OBJECT_MAPPER).readTree(arg_0)));
        this.setExtraParams(request);
    }

    private <Req> void setParams(Req req, String acceptHeader, BiFunction<Req, String, String> valGetter) throws HyracksDataException {
        this.setStatement(valGetter.apply(req, Parameter.STATEMENT.str()));
        this.setClientContextID(valGetter.apply(req, Parameter.CLIENT_ID.str()));
        this.setFormatIfExists(req, acceptHeader, Parameter.FORMAT.str(), valGetter);
        this.setMode(QueryServiceRequestParameters.parseIfExists(req, Parameter.MODE.str(), valGetter, this.getMode(), IStatementExecutor.ResultDelivery::fromName));
        this.setPlanFormat(QueryServiceRequestParameters.parseIfExists(req, Parameter.PLAN_FORMAT.str(), valGetter, this.getPlanFormat(), planFormats::get));
        this.setProfileType(QueryServiceRequestParameters.parseIfExists(req, Parameter.PROFILE.str(), valGetter, this.getProfileType(), IStatementExecutor.Stats.ProfileType::fromName));
        this.setTimeout(QueryServiceRequestParameters.parseTime(req, Parameter.TIMEOUT.str(), valGetter, this.getTimeout()));
        this.setMaxResultReads(QueryServiceRequestParameters.parseLong(req, Parameter.MAX_RESULT_READS.str(), valGetter, this.getMaxResultReads()));
        this.setMaxWarnings(QueryServiceRequestParameters.parseLong(req, Parameter.MAX_WARNINGS.str(), valGetter, this.getMaxWarnings()));
        this.setPretty(QueryServiceRequestParameters.parseBoolean(req, Parameter.PRETTY.str(), valGetter, this.isPretty()));
        this.setExpressionTree(QueryServiceRequestParameters.parseBoolean(req, Parameter.EXPRESSION_TREE.str(), valGetter, this.isExpressionTree()));
        this.setRewrittenExpressionTree(QueryServiceRequestParameters.parseBoolean(req, Parameter.REWRITTEN_EXPRESSION_TREE.str(), valGetter, this.isRewrittenExpressionTree()));
        this.setLogicalPlan(QueryServiceRequestParameters.parseBoolean(req, Parameter.LOGICAL_PLAN.str(), valGetter, this.isLogicalPlan()));
        this.setParseOnly(QueryServiceRequestParameters.parseBoolean(req, Parameter.PARSE_ONLY.str(), valGetter, this.isParseOnly()));
        this.setReadOnly(QueryServiceRequestParameters.parseBoolean(req, Parameter.READ_ONLY.str(), valGetter, this.isReadOnly()));
        this.setOptimizedLogicalPlan(QueryServiceRequestParameters.parseBoolean(req, Parameter.OPTIMIZED_LOGICAL_PLAN.str(), valGetter, this.isOptimizedLogicalPlan()));
        this.setMultiStatement(QueryServiceRequestParameters.parseBoolean(req, Parameter.MULTI_STATEMENT.str(), valGetter, this.isMultiStatement()));
        this.setJob(QueryServiceRequestParameters.parseBoolean(req, Parameter.JOB.str(), valGetter, this.isJob()));
        this.setSignature(QueryServiceRequestParameters.parseBoolean(req, Parameter.SIGNATURE.str(), valGetter, this.isSignature()));
    }

    protected void setExtraParams(JsonNode jsonRequest) throws HyracksDataException {
    }

    protected void setExtraParams(IServletRequest request) throws HyracksDataException {
    }

    private <R, P> Map<String, JsonNode> getOptStatementParameters(R request, Iterator<String> paramNameIter, BiFunction<R, String, P> paramValueAccessor, CheckedFunction<P, JsonNode> paramValueParser) throws IOException {
        HashMap<String, JsonNode> result = null;
        while (paramNameIter.hasNext()) {
            JsonNode stmtParamValue;
            P paramValue;
            String paramName = paramNameIter.next();
            String stmtParamName = QueryServiceRequestParameters.extractStatementParameterName(paramName);
            if (stmtParamName != null) {
                if (result == null) {
                    result = new HashMap<String, JsonNode>();
                }
                paramValue = paramValueAccessor.apply(request, paramName);
                stmtParamValue = paramValueParser.apply(paramValue);
                result.put(stmtParamName, stmtParamValue);
                continue;
            }
            if (!Parameter.ARGS.str().equals(QueryServiceRequestParameters.toLower(paramName))) continue;
            if (result == null) {
                result = new HashMap();
            }
            if (!(stmtParamValue = paramValueParser.apply(paramValue = paramValueAccessor.apply(request, paramName))).isArray()) {
                throw new RuntimeDataException(ErrorCode.INVALID_REQ_PARAM_VAL, new Serializable[]{paramName, stmtParamValue.asText()});
            }
            int ln = stmtParamValue.size();
            for (int i = 0; i < ln; ++i) {
                result.put(String.valueOf(i + 1), stmtParamValue.get(i));
            }
        }
        return result;
    }

    public static String extractStatementParameterName(String name) {
        int ln = name.length();
        if ((ln == 2 || QueryServiceRequestParameters.isStatementParameterNameRest(name, 2)) && name.charAt(0) == '$' && Character.isLetter(name.charAt(1))) {
            return name.substring(1);
        }
        return null;
    }

    private static boolean isStatementParameterNameRest(CharSequence input, int startIndex) {
        int i;
        int ln = input.length();
        for (i = startIndex; i < ln; ++i) {
            boolean ok;
            char c = input.charAt(i);
            boolean bl = ok = c == '_' || Character.isLetterOrDigit(c);
            if (ok) continue;
            return false;
        }
        return i > startIndex;
    }

    private static <R> boolean parseBoolean(R request, String parameterName, BiFunction<R, String, String> valueAccessor, boolean defaultVal) throws HyracksDataException {
        String value = QueryServiceRequestParameters.toLower(valueAccessor.apply(request, parameterName));
        if (value == null) {
            return defaultVal;
        }
        Boolean booleanVal = booleanValues.get(value);
        if (booleanVal == null) {
            throw new RuntimeDataException(ErrorCode.INVALID_REQ_PARAM_VAL, new Serializable[]{parameterName, value});
        }
        return booleanVal;
    }

    private static <R> long parseLong(R request, String parameterName, BiFunction<R, String, String> valueAccessor, long defaultVal) throws HyracksDataException {
        String value = QueryServiceRequestParameters.toLower(valueAccessor.apply(request, parameterName));
        if (value == null) {
            return defaultVal;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeDataException(ErrorCode.INVALID_REQ_PARAM_VAL, new Serializable[]{parameterName, value});
        }
    }

    private static <R> long parseTime(R request, String parameterName, BiFunction<R, String, String> valueAccessor, long def) throws HyracksDataException {
        String value = QueryServiceRequestParameters.toLower(valueAccessor.apply(request, parameterName));
        if (value == null) {
            return def;
        }
        try {
            return TimeUnit.NANOSECONDS.toMillis(Duration.parseDurationStringToNanos((String)value));
        }
        catch (HyracksDataException e) {
            throw new RuntimeDataException(ErrorCode.INVALID_REQ_PARAM_VAL, new Serializable[]{parameterName, value});
        }
    }

    private <R> void setFormatIfExists(R request, String acceptHeader, String parameterName, BiFunction<R, String, String> valueAccessor) throws HyracksDataException {
        Pair<SessionConfig.OutputFormat, Boolean> formatAndHeader = this.parseFormatIfExists(request, acceptHeader, parameterName, valueAccessor);
        if (formatAndHeader != null) {
            this.setFormat(formatAndHeader);
        }
    }

    protected <R> Pair<SessionConfig.OutputFormat, Boolean> parseFormatIfExists(R request, String acceptHeader, String parameterName, BiFunction<R, String, String> valueAccessor) throws HyracksDataException {
        String value = QueryServiceRequestParameters.toLower(valueAccessor.apply(request, parameterName));
        if (value == null) {
            if (acceptHeader != null) {
                String[] mimeTypes = StringUtils.split((String)acceptHeader, (char)',');
                int size = mimeTypes.length;
                for (int i = 0; i < size; ++i) {
                    Pair<SessionConfig.OutputFormat, Boolean> formatAndHeader = QueryServiceRequestParameters.fromMime(mimeTypes[i]);
                    if (formatAndHeader == null) continue;
                    return formatAndHeader;
                }
            }
            return null;
        }
        if (value.equals("csv")) {
            return Pair.of((Object)SessionConfig.OutputFormat.CSV, (Object)Boolean.FALSE);
        }
        if (value.equals("json")) {
            return Pair.of((Object)SessionConfig.OutputFormat.CLEAN_JSON, (Object)Boolean.FALSE);
        }
        if (value.equals("adm")) {
            return Pair.of((Object)SessionConfig.OutputFormat.ADM, (Object)Boolean.FALSE);
        }
        throw new RuntimeDataException(ErrorCode.INVALID_REQ_PARAM_VAL, new Serializable[]{parameterName, value});
    }

    private static Pair<SessionConfig.OutputFormat, Boolean> fromMime(String mimeType) throws HyracksDataException {
        String[] mimeSplits = StringUtils.split((String)mimeType, (char)';');
        if (mimeSplits.length > 0) {
            String format = mimeSplits[0].toLowerCase().trim();
            if (format.equals("application/json")) {
                return Pair.of((Object)(QueryServiceRequestParameters.hasValue(mimeSplits, Attribute.LOSSLESS.str(), booleanValues) ? SessionConfig.OutputFormat.LOSSLESS_JSON : SessionConfig.OutputFormat.CLEAN_JSON), (Object)Boolean.FALSE);
            }
            if (format.equals("text/csv")) {
                return Pair.of((Object)SessionConfig.OutputFormat.CSV, (Object)(QueryServiceRequestParameters.hasValue(mimeSplits, Attribute.HEADER.str(), csvHeaderValues) ? Boolean.TRUE : Boolean.FALSE));
            }
            if (format.equals("application/x-adm")) {
                return Pair.of((Object)SessionConfig.OutputFormat.ADM, (Object)Boolean.FALSE);
            }
        }
        return null;
    }

    private static boolean hasValue(String[] mimeTypeParts, String attributeName, Map<String, Boolean> allowedValues) throws HyracksDataException {
        int size = mimeTypeParts.length;
        for (int i = 1; i < size; ++i) {
            String[] attNameAndVal = StringUtils.split((String)mimeTypeParts[i], (char)'=');
            if (attNameAndVal.length != 2 || !attNameAndVal[0].toLowerCase().trim().equals(attributeName)) continue;
            Boolean value = allowedValues.get(attNameAndVal[1].toLowerCase().trim());
            if (value == null) {
                throw new RuntimeDataException(ErrorCode.INVALID_REQ_PARAM_VAL, new Serializable[]{attributeName, attNameAndVal[1]});
            }
            return value;
        }
        return false;
    }

    private static <Req, Param> Param parseIfExists(Req request, String parameterName, BiFunction<Req, String, String> valueAccessor, Param defaultVal, Function<String, Param> parseFunction) throws HyracksDataException {
        String valueInRequest = QueryServiceRequestParameters.toLower(valueAccessor.apply(request, parameterName));
        if (valueInRequest == null) {
            return defaultVal;
        }
        Param resultValue = parseFunction.apply(valueInRequest);
        if (resultValue == null) {
            throw new RuntimeDataException(ErrorCode.INVALID_REQ_PARAM_VAL, new Serializable[]{parameterName, valueInRequest});
        }
        return resultValue;
    }

    protected static String getParameter(JsonNode node, String parameter) {
        JsonNode value = node.get(parameter);
        return value != null ? value.asText() : null;
    }

    protected static String toLower(String s) {
        return s != null ? s.toLowerCase() : s;
    }

    @FunctionalInterface
    static interface CheckedFunction<I, O> {
        public O apply(I var1) throws IOException;
    }

    private static enum Attribute {
        HEADER("header"),
        LOSSLESS("lossless");

        private final String str;

        private Attribute(String str) {
            this.str = str;
        }

        public String str() {
            return this.str;
        }
    }

    public static enum Parameter {
        ARGS("args"),
        STATEMENT("statement"),
        FORMAT("format"),
        CLIENT_ID("client_context_id"),
        PRETTY("pretty"),
        MODE("mode"),
        TIMEOUT("timeout"),
        PLAN_FORMAT("plan-format"),
        MAX_RESULT_READS("max-result-reads"),
        EXPRESSION_TREE("expression-tree"),
        REWRITTEN_EXPRESSION_TREE("rewritten-expression-tree"),
        LOGICAL_PLAN("logical-plan"),
        OPTIMIZED_LOGICAL_PLAN("optimized-logical-plan"),
        PARSE_ONLY("parse-only"),
        READ_ONLY("readonly"),
        JOB("job"),
        PROFILE("profile"),
        SIGNATURE("signature"),
        MULTI_STATEMENT("multi-statement"),
        MAX_WARNINGS("max-warnings");

        private final String str;

        private Parameter(String str) {
            this.str = str;
        }

        public String str() {
            return this.str;
        }
    }
}

