/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.mapred.InvalidInputException;

@InterfaceAudience.Private
public class LocatedFileStatusFetcher {
    private final Path[] inputDirs;
    private final PathFilter inputFilter;
    private final Configuration conf;
    private final boolean recursive;
    private final boolean newApi;
    private final ExecutorService rawExec;
    private final ListeningExecutorService exec;
    private final BlockingQueue<List<FileStatus>> resultQueue;
    private final List<IOException> invalidInputErrors = new LinkedList<IOException>();
    private final ProcessInitialInputPathCallback processInitialInputPathCallback = new ProcessInitialInputPathCallback();
    private final ProcessInputDirCallback processInputDirCallback = new ProcessInputDirCallback();
    private final AtomicInteger runningTasks = new AtomicInteger(0);
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private volatile Throwable unknownError;

    public LocatedFileStatusFetcher(Configuration conf, Path[] dirs, boolean recursive, PathFilter inputFilter, boolean newApi) throws InterruptedException, IOException {
        int numThreads = conf.getInt("mapreduce.input.fileinputformat.list-status.num-threads", 1);
        this.rawExec = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("GetFileInfo #%d").build());
        this.exec = MoreExecutors.listeningDecorator((ExecutorService)this.rawExec);
        this.resultQueue = new LinkedBlockingQueue<List<FileStatus>>();
        this.conf = conf;
        this.inputDirs = dirs;
        this.recursive = recursive;
        this.inputFilter = inputFilter;
        this.newApi = newApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<FileStatus> getFileStatuses() throws InterruptedException, IOException {
        this.runningTasks.incrementAndGet();
        for (Path p : this.inputDirs) {
            this.runningTasks.incrementAndGet();
            ListenableFuture future = this.exec.submit((Callable)new ProcessInitialInputPathCallable(p, this.conf, this.inputFilter));
            Futures.addCallback((ListenableFuture)future, (FutureCallback)this.processInitialInputPathCallback);
        }
        this.runningTasks.decrementAndGet();
        this.lock.lock();
        try {
            while (this.runningTasks.get() != 0 && this.unknownError == null) {
                this.condition.await();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.exec.shutdownNow();
        if (this.unknownError != null) {
            if (this.unknownError instanceof Error) {
                throw (Error)this.unknownError;
            }
            if (this.unknownError instanceof RuntimeException) {
                throw (RuntimeException)this.unknownError;
            }
            if (this.unknownError instanceof IOException) {
                throw (IOException)this.unknownError;
            }
            if (this.unknownError instanceof InterruptedException) {
                throw (InterruptedException)this.unknownError;
            }
            throw new IOException(this.unknownError);
        }
        if (this.invalidInputErrors.size() != 0) {
            if (this.newApi) {
                throw new org.apache.hadoop.mapreduce.lib.input.InvalidInputException(this.invalidInputErrors);
            }
            throw new InvalidInputException(this.invalidInputErrors);
        }
        return Iterables.concat(this.resultQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerInvalidInputError(List<IOException> errors) {
        LocatedFileStatusFetcher locatedFileStatusFetcher = this;
        synchronized (locatedFileStatusFetcher) {
            this.invalidInputErrors.addAll(errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerError(Throwable t) {
        this.lock.lock();
        try {
            if (this.unknownError == null) {
                this.unknownError = t;
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementRunningAndCheckCompletion() {
        this.lock.lock();
        try {
            if (this.runningTasks.decrementAndGet() == 0) {
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private class ProcessInitialInputPathCallback
    implements FutureCallback<ProcessInitialInputPathCallable.Result> {
        private ProcessInitialInputPathCallback() {
        }

        public void onSuccess(ProcessInitialInputPathCallable.Result result) {
            try {
                if (result.errors != null) {
                    LocatedFileStatusFetcher.this.registerInvalidInputError(result.errors);
                }
                if (result.matchedFileStatuses != null) {
                    for (FileStatus matched : result.matchedFileStatuses) {
                        LocatedFileStatusFetcher.this.runningTasks.incrementAndGet();
                        ListenableFuture future = LocatedFileStatusFetcher.this.exec.submit((Callable)new ProcessInputDirCallable(result.fs, matched, LocatedFileStatusFetcher.this.recursive, LocatedFileStatusFetcher.this.inputFilter));
                        Futures.addCallback((ListenableFuture)future, (FutureCallback)LocatedFileStatusFetcher.this.processInputDirCallback);
                    }
                }
                LocatedFileStatusFetcher.this.decrementRunningAndCheckCompletion();
            }
            catch (Throwable t) {
                LocatedFileStatusFetcher.this.registerError(t);
            }
        }

        public void onFailure(Throwable t) {
            LocatedFileStatusFetcher.this.registerError(t);
        }
    }

    private static class ProcessInitialInputPathCallable
    implements Callable<Result> {
        private final Path path;
        private final Configuration conf;
        private final PathFilter inputFilter;

        public ProcessInitialInputPathCallable(Path path, Configuration conf, PathFilter pathFilter) {
            this.path = path;
            this.conf = conf;
            this.inputFilter = pathFilter;
        }

        @Override
        public Result call() throws Exception {
            Result result = new Result();
            FileSystem fs = this.path.getFileSystem(this.conf);
            result.fs = fs;
            FileStatus[] matches = fs.globStatus(this.path, this.inputFilter);
            if (matches == null) {
                result.addError(new IOException("Input path does not exist: " + this.path));
            } else if (matches.length == 0) {
                result.addError(new IOException("Input Pattern " + this.path + " matches 0 files"));
            } else {
                Result.access$1602(result, matches);
            }
            return result;
        }

        private static class Result {
            private List<IOException> errors;
            private FileStatus[] matchedFileStatuses;
            private FileSystem fs;

            private Result() {
            }

            void addError(IOException ioe) {
                if (this.errors == null) {
                    this.errors = new LinkedList<IOException>();
                }
                this.errors.add(ioe);
            }

            static /* synthetic */ FileStatus[] access$1602(Result x0, FileStatus[] x1) {
                x0.matchedFileStatuses = x1;
                return x1;
            }
        }
    }

    private class ProcessInputDirCallback
    implements FutureCallback<ProcessInputDirCallable.Result> {
        private ProcessInputDirCallback() {
        }

        public void onSuccess(ProcessInputDirCallable.Result result) {
            try {
                if (result.locatedFileStatuses.size() != 0) {
                    LocatedFileStatusFetcher.this.resultQueue.add(result.locatedFileStatuses);
                }
                if (result.dirsNeedingRecursiveCalls.size() != 0) {
                    for (FileStatus fileStatus : result.dirsNeedingRecursiveCalls) {
                        LocatedFileStatusFetcher.this.runningTasks.incrementAndGet();
                        ListenableFuture future = LocatedFileStatusFetcher.this.exec.submit((Callable)new ProcessInputDirCallable(result.fs, fileStatus, LocatedFileStatusFetcher.this.recursive, LocatedFileStatusFetcher.this.inputFilter));
                        Futures.addCallback((ListenableFuture)future, (FutureCallback)LocatedFileStatusFetcher.this.processInputDirCallback);
                    }
                }
                LocatedFileStatusFetcher.this.decrementRunningAndCheckCompletion();
            }
            catch (Throwable t) {
                LocatedFileStatusFetcher.this.registerError(t);
            }
        }

        public void onFailure(Throwable t) {
            LocatedFileStatusFetcher.this.registerError(t);
        }
    }

    private static class ProcessInputDirCallable
    implements Callable<Result> {
        private final FileSystem fs;
        private final FileStatus fileStatus;
        private final boolean recursive;
        private final PathFilter inputFilter;

        ProcessInputDirCallable(FileSystem fs, FileStatus fileStatus, boolean recursive, PathFilter inputFilter) {
            this.fs = fs;
            this.fileStatus = fileStatus;
            this.recursive = recursive;
            this.inputFilter = inputFilter;
        }

        @Override
        public Result call() throws Exception {
            Result result = new Result();
            result.fs = this.fs;
            if (this.fileStatus.isDirectory()) {
                RemoteIterator iter = this.fs.listLocatedStatus(this.fileStatus.getPath());
                while (iter.hasNext()) {
                    LocatedFileStatus stat = (LocatedFileStatus)iter.next();
                    if (!this.inputFilter.accept(stat.getPath())) continue;
                    if (this.recursive && stat.isDirectory()) {
                        result.dirsNeedingRecursiveCalls.add(stat);
                        continue;
                    }
                    result.locatedFileStatuses.add(stat);
                }
            } else {
                result.locatedFileStatuses.add(this.fileStatus);
            }
            return result;
        }

        private static class Result {
            private List<FileStatus> locatedFileStatuses = new LinkedList<FileStatus>();
            private List<FileStatus> dirsNeedingRecursiveCalls = new LinkedList<FileStatus>();
            private FileSystem fs;

            private Result() {
            }
        }
    }
}

