/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.properties;

import java.util.List;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMissableTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypeEnvPointer;

public abstract class TypePropagationPolicy {
    public static final TypePropagationPolicy ALL = new TypePropagationPolicy(){

        @Override
        public Object getVarType(LogicalVariable var, IMissableTypeComputer ntc, List<LogicalVariable> nonMissableVariableList, List<List<LogicalVariable>> correlatedMissableVariableLists, ITypeEnvPointer ... typeEnvs) throws AlgebricksException {
            for (ITypeEnvPointer p : typeEnvs) {
                IVariableTypeEnvironment env = p.getTypeEnv();
                if (env == null) {
                    throw new AlgebricksException("Null environment for pointer " + p + " in getVarType for var=" + var);
                }
                Object t = env.getVarType(var, nonMissableVariableList, correlatedMissableVariableLists);
                if (t == null) continue;
                if (ntc != null && ntc.canBeMissing(t)) {
                    for (List<LogicalVariable> list : correlatedMissableVariableLists) {
                        if (!list.contains(var)) continue;
                        for (LogicalVariable v : list) {
                            if (!nonMissableVariableList.contains(v)) continue;
                            return ntc.getNonOptionalType(t);
                        }
                    }
                }
                return t;
            }
            return null;
        }
    };
    public static final TypePropagationPolicy LEFT_OUTER = new TypePropagationPolicy(){

        @Override
        public Object getVarType(LogicalVariable var, IMissableTypeComputer ntc, List<LogicalVariable> nonMissableVariableList, List<List<LogicalVariable>> correlatedMissableVariableLists, ITypeEnvPointer ... typeEnvs) throws AlgebricksException {
            int n = typeEnvs.length;
            for (int i = n - 1; i >= 0; --i) {
                Object t = typeEnvs[i].getTypeEnv().getVarType(var, nonMissableVariableList, correlatedMissableVariableLists);
                if (t == null) continue;
                if (i == 0) {
                    return t;
                }
                boolean nonMissingVarIsProduced = false;
                for (LogicalVariable v : nonMissableVariableList) {
                    boolean toBreak = false;
                    if (v == var) {
                        nonMissingVarIsProduced = true;
                        toBreak = true;
                    } else if (typeEnvs[i].getTypeEnv().getVarType(v) != null) {
                        nonMissingVarIsProduced = true;
                        toBreak = true;
                    }
                    if (!toBreak) continue;
                    break;
                }
                if (nonMissingVarIsProduced) {
                    return t;
                }
                return ntc.makeMissableType(t);
            }
            return null;
        }
    };

    public abstract Object getVarType(LogicalVariable var1, IMissableTypeComputer var2, List<LogicalVariable> var3, List<List<LogicalVariable>> var4, ITypeEnvPointer ... var5) throws AlgebricksException;
}

