/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ParseException
extends HyracksDataException {
    private static final long serialVersionUID = 1L;
    private String filename;
    private int line = -1;
    private int column = -1;

    public ParseException(String message) {
        super(message);
    }

    public ParseException(int errorCode, Serializable ... param) {
        super("ASX", errorCode, ErrorCode.getErrorMessage((int)errorCode), param);
    }

    public ParseException(int errorCode, Throwable e, Serializable ... param) {
        super("ASX", errorCode, e, new Serializable[]{ErrorCode.getErrorMessage((int)errorCode), param});
        this.addSuppressed(e);
    }

    public ParseException(Throwable cause) {
        super(cause);
    }

    public ParseException(String message, Throwable cause) {
        super(message, cause);
    }

    public ParseException(Throwable cause, String filename, int line, int column) {
        super(cause);
        this.setLocation(filename, line, column);
    }

    public void setLocation(String filename, int line, int column) {
        this.filename = filename;
        this.line = line;
        this.column = column;
    }

    public String getMessage() {
        StringBuilder msg = new StringBuilder("Parse error");
        if (this.filename != null) {
            msg.append(" in file ").append(this.filename);
        }
        if (this.line >= 0) {
            msg.append(" in line ").append(this.line);
            if (this.column >= 0) {
                msg.append(", at column ").append(this.column);
            }
        }
        return msg.append(": ").append(super.getMessage()).toString();
    }
}

