/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;

public class IfNanOrInfTypeComputer
extends AbstractResultTypeComputer {
    public static final IfNanOrInfTypeComputer INSTANCE = new IfNanOrInfTypeComputer(false);
    public static final IfNanOrInfTypeComputer INSTANCE_SKIP_MISSING = new IfNanOrInfTypeComputer(true);
    private final boolean skipMissing;

    private IfNanOrInfTypeComputer(boolean skipMissing) {
        this.skipMissing = skipMissing;
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        if (strippedInputTypes.length < 2 || strippedInputTypes.length > Short.MAX_VALUE) {
            String functionName = ((AbstractFunctionCallExpression)expr).getFunctionIdentifier().getName();
            throw new CompilationException(1087, expr.getSourceLocation(), new Serializable[]{functionName});
        }
        boolean any = false;
        IAType currentType = null;
        for (IAType type : strippedInputTypes) {
            if (currentType != null && !type.equals(currentType)) {
                any = true;
                break;
            }
            currentType = type;
        }
        if (any || currentType == null) {
            return BuiltinType.ANY;
        }
        switch (currentType.getTypeTag()) {
            case MISSING: {
                if (this.skipMissing) {
                    return BuiltinType.ANULL;
                }
            }
            case ANY: 
            case BIGINT: 
            case INTEGER: 
            case SMALLINT: 
            case TINYINT: {
                return currentType;
            }
            case DOUBLE: 
            case FLOAT: {
                return AUnionType.createNullableType(currentType, null);
            }
        }
        return BuiltinType.ANULL;
    }

    @Override
    protected boolean propagateNullAndMissing() {
        return false;
    }
}

