/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.formats.nontagged;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.hyracks.algebricks.data.IBinaryBooleanInspector;
import org.apache.hyracks.algebricks.data.IBinaryBooleanInspectorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class BinaryBooleanInspector {
    public static final IBinaryBooleanInspectorFactory FACTORY = new IBinaryBooleanInspectorFactory(){
        private static final long serialVersionUID = 1L;

        public IBinaryBooleanInspector createBinaryBooleanInspector(IHyracksTaskContext ctx) {
            return BinaryBooleanInspector::getBooleanValue;
        }
    };
    private static final String NAME = "boolean-inspector";

    private BinaryBooleanInspector() {
    }

    public static boolean getBooleanValue(byte[] bytes, int offset, int length) throws HyracksDataException {
        byte serializedTypeTag = bytes[offset];
        if (serializedTypeTag == ATypeTag.SERIALIZED_MISSING_TYPE_TAG || serializedTypeTag == ATypeTag.SERIALIZED_NULL_TYPE_TAG) {
            return false;
        }
        ATypeTag typeTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serializedTypeTag);
        if (typeTag != ATypeTag.BOOLEAN) {
            throw new RuntimeDataException(2, new Serializable[]{NAME, Integer.valueOf(0), ATypeTag.BOOLEAN, typeTag});
        }
        return bytes[offset + 1] == 1;
    }
}

